function [samples types]=getannotsamplesandtypes(varargin)

## wrapper for rdann from Matlab/octave wfdb toolbox
## does not return error when there are no annotations
##
##   Wrapper to WFDB RDANN:
##     http://www.physionet.org/physiotools/wag/rdann-1.htm

## Reads a WFDB annotation and returns:
## ann  Nx1 vector of the ints. The time of the annotation in samples
##      with respect to the fist sample in the signals in recordName.
##
## type  NxT vector of the chars describing annotation type.
##
## subtype  Nx1 vector of the chars describing annotation subtype.
##
## chan  Nx1 vector of the ints describing annotation subtype.
##
## num  Nx1 vector of the ints describing annotation NUM.
##
## comments  Nx1 vector of the cells describing annotation comments.
##
## Required Parameters:
##
## recorName
##       String specifying the name of the record (including the full path)
##
## annotator
##     String specifying the name of the annotation file 

recordname=varargin{1};
annotator=varargin{2};

# filename=[recordname,'.', annotator];
# cmd=['wc -c ', filename];

cmd=['rdann -r ',recordname,' -a ',annotator," |  awk \' { print $2, $3 } \' "];


[output, text] = system (cmd);  

[cstr] = strsplit (text);

l=length(cstr);
num=floor(l/2);

types=blanks(num);
samples=zeros(1,num);

for i=1:num
  types(i)=cstr{2*i};
  samples(i)=str2num(cstr{2*i-1});
endfor

types=types';
# if(str2num(cstr{1})>2)
#   if(nargin()==2)
#     varagout{1}=rdann(varargin{1},varargin{2});
    
#   endif
# else
#  varargout=[];
# endif  
    
    