function output=flatLineECG(signal,threshold=0.000001, radius=8)

  ## we call ABP and PLETH pulsatil signals
  ##
  ## detects if in the neighbourhood of each point the variance is too
  ## small (flat line)
  ##
  ## 
  ## default radius is thought for FS=250 Hz
  ##
  ## output is a signal with the same length as the signal having a one where
  ## local variance is under threshold and zero otherwise
  ##
  ## it could be used in the following way: an interval is flat if any
  ## point (or a percentage of points) in the output is non zero


  locVar=computeLocalVariance(signal,radius);

  output=locVar<threshold;

endfunction