function q=equalityAnnot(ann1,ann2,thres,N0,LECG)

  ann1=ann1(ann1>N0);
  ann1=ann1(ann1<N0+LECG);

  if(length(ann1)==0)
    q=0;
    return
  endif

  ## deal with border problems

  aux1=ann2>N0;
  if(!any(aux1))
    q=0;
    return
  else
    ini=find(aux1)(1);
  endif



  ## beginning of ann2
  if(ini>1)
    [d ind]=min([abs(ann1(1)-ann2(ini)), abs(ann1(1)-ann2(ini-1))]); # find the nearest element of
                                # [ann2(ini),ann2(ini+1)] to ann1(1)
  else
    d=abs(ann1(1)-ann2(ini));
    ind=1;
  endif

  if(d>thres)
    q=0;
    return
  elseif(ind==1)
    ann2=ann2(ini:end);
  else
    ann2=ann2(ini-1:end);
  endif

  ## end of ann2  and ann1

  aux2=ann2<N0+LECG;
  if(!any(aux2))
    q=0;
    return
  else
    last=find(aux2)(end);
  endif


  ann2=ann2(1:last);
  if((ann1(end)>N0+LECG-thres)&&(abs(ann1(end)-ann2(end))>thres))
    ann1(end)=[]; # remove last element of ann1
  endif 
  if((ann2(end)>N0+LECG-thres)&&(abs(ann1(end)-ann2(end))>thres))
    ann2(end)=[]; # remove last element of ann2
  endif 

  if(length(ann1)!=length(ann2))
     q=0;
     return
   endif

   aux=abs(ann1(:)-ann2(:));

   if(any(aux>thres))
     q=0;
   else
     q=1;
   endif

endfunction

