function [c,Dist,D,k,w]=dtw2(t,r)
%Dynamic Time Warping Algorithm
%Dist is unnormalized distance between t and r
%D is the accumulated distance matrix
%k is the normalizing factor
%w is the optimal path
%t is the vector you are testing against
%r is the vector you are testing
# Copyright (c) 2006, Timothy Felty
# All rights reserved.

# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:

#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in
#       the documentation and/or other materials provided with the distribution

# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.




  [rows,N]=size(t);
  [rows,M]=size(r);
%for n=1:N
%    for m=1:M
%        d(n,m)=(t(n)-r(m))^2;
%    end
%end
  d=(repmat(t(:),1,M)-repmat(r(:)',N,1)).^2; %this replaces the nested for loops from above Thanks Georg Schmitz 

  D=zeros(size(d));
  D(1,1)=d(1,1);

  for n=2:N
    D(n,1)=d(n,1)+D(n-1,1);
  endfor
  for m=2:M
    D(1,m)=d(1,m)+D(1,m-1);
  endfor
  for n=2:N
    for m=2:M
      D(n,m)=d(n,m)+min([D(n-1,m),D(n-1,m-1),D(n,m-1)]);
    endfor
  endfor

  Dist=D(N,M);
  n=N;
  m=M;
  k=1;
  w=[];
  w(1,:)=[N,M];
  while ((n+m)~=2)
    if (n-1)==0
      m=m-1;
    elseif (m-1)==0
      n=n-1;
    else 
      [values,number]=min([D(n-1,m),D(n,m-1),D(n-1,m-1)]);
      switch number
        case 1
          n=n-1;
        case 2
          m=m-1;
        case 3
          n=n-1;
          m=m-1;
      endswitch
    endif
    k=k+1;
    #w=cat(1,w,[n,m]);
    w=[n m; w]; 
  endwhile

  t_warped=t(w(:,1)); 
  r_warped=r(w(:,2));
  
  c=corr(t_warped,r_warped);
  if(c<0) 
    c=0;
  endif
endfunction


