function newsig=detectpacespikes(signal, Fs, threshold)
  ## single channel signal
  ## threshold is used to conclude for the presence of pace spikes

  ## sampling frequency must be 125Hz
  assert(Fs==125);

  assert((size(signal,1)==1)||(size(signal,2)==1));

  if(size(signal,1)>size(signal,2))
    signal=signal';
  endif

  l=length(signal);



  ## code for general Fs _> too slowly
  # s=4; ## displacement where interpolation is done
  # locations=[];
  # for i=1:l-s+1
  #   yi=interp1([i,i+s-1],[signal(i),signal(i+s-1)],[i:i+s-1]);
  #   m=max(abs([signal(i:i+s-1)]-yi));
  #   if(m>threshold)
  #     locations=[locations, i];
  #   endif                   
  # endfor

  ## estimate one data point with the average of the predessor and the sucessor
  ## and compute the absolute difference between the estimate and the
  ## real value
  aux=abs(signal(2:end-1)-0.5*(signal(1:end-2)+signal(3:end)));

  locations=find(aux>threshold);
  locations=locations+1;

  newsig=signal;

  nseg=l/Fs;
  A=nseg*10;
  if(length(locations)>A)
    return;
  endif
 

  if(length(locations>0))

     intervals=createintervals(locations);
     l=size(intervals,1);


     ## in each interval replace signal by interpolation
     for i=1:l
     newsig(intervals(i,1)-1:intervals(i,2)+1)=...
        interp1([intervals(i,1)-1, intervals(i,2)+1],...
                [newsig(intervals(i,1)-1),newsig(intervals(i,2)+1)],
                [intervals(i,1)-1:intervals(i,2)+1]);
   endfor

 endif
 
endfunction




function intervals=createintervals(locations)

  ## create groups of consecutive integers

  assert(length(locations)>0);

  aux1=diff(locations); # 1s represent consecutive locations
  aux2=find(aux1>1);
  l=length(aux2);
  intervals=zeros(l+1,2);

  ## first interval starts with the first element of locations
  intervals(1,1)=locations(1);
  for i=1:l
    intervals(i,2)=locations(aux2(i));
    intervals(i+1,1)=locations(aux2(i)+1);
  endfor
  intervals(l+1,2)=locations(end);

endfunction

