function locVar=computeLocalVariance(record,radius)

  ## each signal in the record is a column otherwise transpose it
  [N M]=size(record);
  if(M>N)
    record=record';
    [N M]=size(record);
  endif
  locVar=zeros(N,M);

  if(N>2*radius)
    for i=radius+1:N-radius
      locVar(i,:)=var(record(i-radius:i+radius,:),0);
    endfor
    ## at the begining and end make it constant
    locVar(1:radius,:)=locVar(radius+1,:);
    locVar(N-radius+1:N,:)=locVar(N-radius,:);
  endif
