function alldata=checkFlat(record,alarm_type,Fs=250)

  ## plot last segment signal, high noise and flat detectors


  databasedir='/data/physionet/challenge2015/training/';
  copyfile([databasedir,record,'.hea'],[record,'.hea']);
  copyfile([databasedir,record,'.mat'],[record,'.mat']);



  alldata=challenge(record,alarm_type);

  if(record(end)=='s')
    x=1:4000;
  else
    x=1:11500;
  endif

  ecg1=alldata.signal(71000+x,1);
  ecg1flat=flatLineECG(ecg1);
  ecg2=alldata.signal(71000+x,2);
  ecg2flat=flatLineECG(ecg2);

  threshold=0.8;
  printf("numsecs flat ecg on channel 1 is %d\n",
         detectHighFlatOnSeconds(ecg1flat,Fs,threshold));
  printf("numsecs flat flat ecg on channel 2 is %d\n",
         detectHighFlatOnSeconds(ecg2flat,Fs,threshold));

  clf;
  plot(x, medfilt1(ecg1,9),'k',x, ecg1flat-2,'r'); hold on
  plot(x, medfilt1(ecg2,9)-4,'k',x, ecg2flat-6,'r');

  k=4;
  ppg_ind=[];
  abp_ind=[];
  nsigs=size(alldata.signal,2);
  for i=3:nsigs
    if(strcmp(alldata.description(i),'PLETH')==1)
      ppg=alldata.signal(71000+x,i);
      ppg_ind(1)=i;
      ppgflat=flatLinePulsatil(120*ppg);
      if(max(ppg)~=min(ppg))
        ppg=(ppg-min(ppg))/(max(ppg)-min(ppg));
        k+=4;plot(x, ppg-k-2, x, ppgflat-k-4);
      endif
      printf("numsecs flat ppg is %d\n",
             detectHighFlatOnSeconds(ppgflat,Fs,threshold));
    elseif(strcmp(alldata.description(i),'ABP')==1)
      abp=alldata.signal(71000+x,i);
      abp_ind(1)=i;
      abpflat=flatLinePulsatil(abp);
      if(max(abp)~=min(abp))
         abp=(abp-min(abp))/(max(abp)-min(abp));
         k+=4;plot(x, abp-k-2, x, abpflat-k-4);
       endif
      printf("numsecs flat abp is %d\n",
             detectHighFlatOnSeconds(abpflat,Fs,threshold));
    endif
  endfor

  title(record);
  
  hold off;

  #delete([record,'.hea']);
  #delete([record,'.mat']);

endfunction


function n=detectHighFlatOnSeconds(flat,Fs,threshold)

  ## flat should be avector with only zeros and ones
  assert((size(flat,1)==1)||(size(flat,2)==1));

  l=length(flat);
  aux=zeros(1,l);
  nsecs=floor(l/Fs);

  for i=1:nsecs
    aux(i)=sum(flat((i-1)*Fs+1:i*Fs))/Fs;
  endfor

  n=sum(aux>threshold);

endfunction