function RR = RR_check(RR)
%
% RR = RR_check(RR)
%
% Replaces unreasonable RR distances with NaNs.
%
% Required Parameters:
%
% RR
%       Nx1 vector containing RR distances.
%
%
%
% Written by Marcus Vollmer, 2015
% Last Modified: February 10, 2015
% Version 0.1
%
%endOfHelp

if length(RR)>2

    relRR = 2*(RR(2:end)-RR(1:end-1))./(RR(2:end)+RR(1:end-1));
    relRR_pct = round(relRR*1000)/10;

    % unreasonable beat differences
        RR(find(relRR_pct(1:end-1)>50 & relRR_pct(2:end)<-50)+1) = NaN; %one inrecognized beat
        relRR = 2*(RR(2:end)-RR(1:end-1))./(RR(2:end)+RR(1:end-1));
        relRR_pct = round(relRR*1000)/10;

    for wbp_lim = 80:-10:30
        wbp = find(abs(diff(relRR_pct))>wbp_lim);    
        wbp = wbp(diff(wbp)==1);
        d = diff(wbp);
        wbp = wbp(d(1:end)~=1 & [0; d(1:end-1)]~=1);  
        %wbp = find(abs(diff(relRR_pct))>35);
        RR(wbp+1) = NaN; RR(wbp+2) = NaN; %wrong beat positions
        relRR = 2*(RR(2:end)-RR(1:end-1))./(RR(2:end)+RR(1:end-1));
        relRR_pct = round(relRR*1000)/10; 
    end

        postmp = find(isnan(RR(1:end-2)));
        RR(postmp(abs(relRR_pct(postmp+1))>15)+1) = NaN; %unreasonble differences after NaN-values
        relRR = 2*(RR(2:end)-RR(1:end-1))./(RR(2:end)+RR(1:end-1));
        relRR_pct = round(relRR*1000)/10; 

        postmp = find(abs(relRR_pct(1:end-1))>50);
        RR(postmp) = NaN; RR(postmp+1) = NaN; %unreasonble relRR_pct values
        relRR = 2*(RR(2:end)-RR(1:end-1))./(RR(2:end)+RR(1:end-1));
        relRR_pct = round(relRR*1000)/10; 

end