function [ quality, histo, histogramBinSize,topHistBorder ] = signalQuality( fullSkelet,N,sfreq )
    %signalQuality funkcja do oceny jakoci kanau
    % Polega on na: wyrysowaniu rozkadu penych anotacji przed
    % removeOutliers dla danego kanau, a nastpnie znalezieniu maksimum
    % takiego rozkadu i sprawdzeniu, czy jest ono >0.5s (to gwarantuje, e
    % dobre odlegoci RR s w stanie wybi si ponad szumowe, czyli, e
    % kana niesie rzeczywicie sensown informacj).
    % Drugie kryterium: jeli penych anotacji jest <100 dla caego zapisu
    % to odrzucamy kana (jeli wykry jest tak mao, to znaczy, e w tym
    % kanale naprawd prawie nic nie ma).
    
    
    histogramBinSize = floor(sfreq/62);     % szeroko binu  histogramu RRw do oceny jakoci kanau o szerokoci 15 ms
    topHistBorder = 2*sfreq;                % grna granica histogramu = 2 s
    bottomHistBorder = sfreq/10;            % dolna granica histogramu = 100 ms
    minimalAnnotationsCount = N/sfreq/6;    % minimalnie 100 wykry musi si znalezc w anotacjach
    minimalMaximumCount = N/sfreq/40;       % minimalna amplituda maksimum hist. to  15 wykry 
    
    dispSkelet = diff(fullSkelet);                  % dispSelet - lista rrw do tworzenia histogramu 
    dispSkelet(dispSkelet > topHistBorder) = [];    %ograniczamy histogram z gry na 2 s (ni echcemy bra pod uwag dziur
    dispSkelet(dispSkelet < bottomHistBorder) = []; %ograniczamy histogram z dou na 100 ms (nie chcemy bra pod uwag b.drobnych mieci, - lokalny szum moe ich naprodukowa bardzo duo
    sizeSkelet = size(dispSkelet,1);
    
    if(sizeSkelet > minimalAnnotationsCount)
        histo = histc(dispSkelet,1:histogramBinSize:topHistBorder);     %tworzymy tablic z histogramem

        [skewSkeletHistMax,skewSkeletHistMaxIndex] =max(histo);         
        skewSkeletHistMaxIndex = skewSkeletHistMaxIndex*histogramBinSize;

        if(skewSkeletHistMaxIndex > 0.5*250 && skewSkeletHistMax > minimalMaximumCount)
            quality = 1;
        else
            quality = 0;                
        end    
    else
        quality = 0; 
        histo = 0;
    end


end

