function plotAnnotations(annotationTable,fsample, amplitude, marker)
    % Funkcja plotAnotations wyswietla anotacje z podanej tablicy anotacji
    % W wyniku powstaje wykres szpilkowy.
    % annotationsTable - tablica z anotacjami w probkach do wyswietlenia.
    % fsample -          czestotliwosc probkowania sygnalu
    % amplitude -        amplituda szpilek do wyswietlenia
    % marker -           string z dfinicja koloru i ksztaltu markera, np: 
    %                    'ob' - wyswietl okragle koncowki szpilek w kolorze
    %                           niebieskim
    %                    'xk' - wyswietl X-owate koncowki szpilek w kolorze
    %                           czarnym
    
    Amatrix = annotationTable;                          %  Amatrix - tablica anotacji
               
    Amatrix = Amatrix / fsample;                            % przeliczam probki na czas w sekundach

    amplitudes = ones(1,length(Amatrix)) * amplitude;   	% generuje tabloice rownych wartosci odpowiadajacom wysokosci szpilek na wykresie "szpilkowym"
    amplitudes = amplitudes';                               % zamieniam tablica wierszowa na kolumne
    
    stem(Amatrix,amplitudes,marker)                         % wyswietlam wykres szpilkowy z anotacjami
end