%Funkcja laczaca szkielety (a wiec dane uwazane juz za dane o niezlej
%jakosci) w jeden wspolny szkielet. Szkielety moga pochodzic np. z roznych
%kanalow danych (EKG i BP).


function  polaczonySzkielet=joinSkeletons(stary,nowy,sfreq)    %Funkcja pobiera 
%dwa szkielety do polaczenia: stary i nowy, przy czym stary dostaje wyzszy priorytet.
%Funkcja pobiera rowniez czestotliwosc probkowania.
%Oddaje polaczony szkielet.

        minSkeletonDiff = 0.2*sfreq; %Minimalny RR ktory pozwalamy aby powstal = 0.3 s (tu przeliczone na liczbe probek).   
        maxSkeletonDiff = 1.4*sfreq; %Maksymalny RR ktory pozwalamy aby powstal = 1.4 s (tu przeliczone na liczbe probek). 
        
        for iterStary=1:size(stary,1)-1 %przechodzimy po wszystkich anotacjach w "starym" szkielecie

  
            nowy( abs(nowy - stary(iterStary,1)) < minSkeletonDiff  ) = [];
            if( abs(stary(iterStary+1,1) - stary(iterStary,1)) < maxSkeletonDiff  )
                nowy( ((stary(iterStary,1) - nowy) < abs(stary(iterStary+1,1) - stary(iterStary,1))) &   ( stary(iterStary,1) - nowy > 0)) = [];
            end
%             for iterNowy=1:size(nowy,1) %przechodzimy po wszystkich anotacjach w "nowym" szkielecie
%                 
%                 if( abs(stary(iterStary,1) - nowy(iterNowy,1)) < minSkeletonDiff      ) %Jesli nowy szkielet chcialby dodac od siebie 
%                     %anotacje ktora znajduje sie blizej niz minSkeletonDiff (0.3 s) od starego, 
%                     %to taka proba zostaje odrzucona.
%                     nowy(iterNowy,1) = 999999;
%                 end
%                 
%                 if( abs(stary(iterStary+1,1) - stary(iterStary,1)) < maxSkeletonDiff  && ... %1. Mamy dobrego RRa w starym szkielecie (ponizej maxSkeletonDiff = 1.4 s)
%                     stary(iterStary,1) - nowy(iterNowy,1) < abs(stary(iterStary+1,1) - stary(iterStary,1)) && ... %Nowa anotacja probuje wstrzelic sie pomiedzy dwie dobre stare
%                     stary(iterStary,1) - nowy(iterNowy,1) > 0) %Nowa anotacja nie pokrywa sie dokladnie ze stara
%                     nowy(iterNowy,1) = 999999; %Jesli wszystkie powyzsze trzy warunki sa spelnione, to znaczy ze nowa anotacja "rozstrzelilaby" i zepsula nam stare dobre anotacje.
%                     %Dlatego ja odrzucamy.
%                 end
%                 
%             end
        end
        nowy(nowy==999999)=[]; %Usuwamy wszystkie dziewiatki
        polaczonySzkielet=[stary;nowy]; %Za polaczony szkielet uznajemy stary i to co pozostalo w powyzszych krokach z nowego
        polaczonySzkielet = sort(polaczonySzkielet); %Sortujemy na wszelki wypadek, chyba do usuniecia
end
