function alarmResult=challenge(recordName, alarm_type)
close all

% recordName=strcat('challenge/training/',recordName);
% Name of file containing answers
answers = 'answers.txt';

[~,config] = wfdbloadlib;                           % inicjalizacja pakietu wfdb
%     if(config.inOctave)
%         crash_dumps_octave_core(0);
%     end

annName = 'qrs';                                    % ustalenie nazwy anotacji (wymagane przez warunki Challenge)

% [siginfo, fs] = wfdbdesc2(recordName);
% % wczytanie danych informacyjnych o nagraniu pod zmienn siginfo (dziwna struktura o formacie wfdb)
% description = squeeze(struct2cell(siginfo));        % przekonwertowanie danych informacyjnych na czytelny format tablicy "komrkowej" matlaba
% descriptionNamesTable = description(5,:)           % wycignicie samych nazw sygnaw na wyjciu mamy jednowymiarow tablic ze stringami zawierajcymi nazwy kanaw

[~,signal,Fs,siginfo]=rdmat([ recordName]);
description = squeeze(struct2cell(siginfo));        % przekonwertowanie danych informacyjnych na czytelny format tablicy "komrkowej" matlaba
descriptionNamesTable = description(4,:);           % wycignicie samych nazw sygnaw na wyjciu mamy jednowymiarow tablic ze stringami zawierajcymi nazwy kanaw
fs = Fs;
signal(isnan(signal))=0;
tm = [0:length(signal)-1]/fs;

if(~isnan(fs))
    sfreq = fs(1);
else
    sfreq=sscanf(siginfo(1).SamplingFrequency,'%f');
end


%[tm,signal] = rdsamp(recordName);                 % wczytanie sygnaw dla aktualnie analizowanego przypadku
% tm - podstawa czasowa sygnau
% signal - wszystkie sygnay istniejce dla danego przypadku.
%Tablica N x m, gdzie N to dugo nagrania, a m - ilo dostpnych sygnaw


ecg_ind = 1;
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'I')'; get_index(descriptionNamesTable,'II')'; get_index(descriptionNamesTable,'III')'];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'IV')'; get_index(descriptionNamesTable,'V')'; get_index(descriptionNamesTable,'VI')'];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'aVF')'; get_index(descriptionNamesTable,'aVL')'; get_index(descriptionNamesTable,'aVR')'];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'MLP')'];
ecg_ind = unique(ecg_ind);

bp_ind = [get_index(descriptionNamesTable,'BP'); get_index(descriptionNamesTable,'ABP'); get_index(descriptionNamesTable,'ART')];
bp_ind = unique(bp_ind);

pleth_ind = [get_index(descriptionNamesTable,'PLETH')];
pleth_ind = unique(pleth_ind);

RESP_ind = [get_index(descriptionNamesTable,'RESP')];
RESP_ind = unique(RESP_ind);


%--------------------------------------------------------------------------
%-[3] Analiza sygnaw EKG ------------------------------------------------
%--------------------------------------------------------------------------
%granice dla sprawdzania:
graniceRSslopeEKG = [   0.017, 0.036;...
    0.026, 0.036;...
    0.035, 0.046;...
    0.017, 0.046;...
    0.026, 0.046;...
    0.017, 0.056;...
    0.026, 0.056;...
    0.035, 0.056;...
    0.017, 0.15;...
    0.035, 0.15];
graniceRSslopeEKG = floor(graniceRSslopeEKG .* sfreq);
graniceAmpEKG= [0.03, 0.97];
lowAmpBest = 0.03;                                                % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 95% prbek w sygnale
highAmpBest = 0.97;                                                     % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
window = round(0.250*sfreq);                                        % wybieram dlugosc okna dla ruchomej mediany na 250 ms
quality=0;
AnnSkeletonECG=[];
AnnSkeletonECGRS=[];
AnnSkeletonECGQ = [];
dAnnSkeletonECG=[];
ANNourREFstage1=[];
prog1=0;
prog2=0;   % do kosza?
lowLengthBest=floor( 0.017 *sfreq);
highLengthBest=floor(0.055 *sfreq);
fullSkelet =[];
dobrySYGNAL=0;
ANNourREFstage1=[];
ecg = 0;

wykrycia = zeros(length(ecg_ind),1);
if(~isempty(ecg_ind) )                                               % sprawdzam, czy wystpuje w ogole kanal EKG. Jesli tak - zaczynam analize
    for currentEcg=1:length(ecg_ind)
        dobrySYGNAL = movingMedian(signal(:,ecg_ind(currentEcg)),window);               % odejmowanie ruchomej mediany od sygnalu EKG za pomoca funkcji umieszczonej
        %w pliku movingMedian.m
        %  dobrySygnal - sygnal EKG po odjeciu mediany
        % uruchamiam algorytm wyszukiwania spadkow RS
        
        [b, a] = butter(8,40/(sfreq/2));                                    % filtruje sygna poniej 40 Hz filtrem Butterwortha 8 rzdu
        dobrySYGNAL = filter(b,a,dobrySYGNAL);
        
        [AnnSkeletonECGRS,lowLengthBest,highLengthBest, fullSkelet,lowAmpBest,highAmpBest,ANNourINDEXBest, SQdiff] = rsSlopeDetectionEKG(dobrySYGNAL,sfreq, graniceRSslopeEKG, graniceAmpEKG,1);
        
        if strcmp(alarm_type, 'Tachycardia')
            [AnnSkeletonECGQ,sign,en_thres,R_t] = qrs_detect2(dobrySYGNAL,0.2,0.200,sfreq,[],[],0);
            
        else
            [AnnSkeletonECGQ,sign,en_thres,R_t] = qrs_detect2(dobrySYGNAL,0.6,0.250,sfreq,[],[],0);
        end
        AnnSkeletonECGQ = AnnSkeletonECGQ';
        
        nowy = AnnSkeletonECGQ;
        stary = AnnSkeletonECGRS;
        
        polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG z qrs_detect2 (stary szkielet) z anotacjami z RSslope, uzyskujc nowy szkielet (szkielet 2.0)
        AnnSkeletonECG =  polaczonySzkielet;
        
        %         AnnSkeletonECG=AnnSkeletonECGRS;
        %  AnnSkeletonECG - znalezione anotacje EKG ( szkielet 1.0)
        %  lowLengthBest - dobrana minimalna dlugosc spadku RS (w probkach)
        %  highLengthBest - dobrana maksymalna dlugosc spadku RS (w probkach)
        %  fullSkelet - znalezione anotacje EKG wraz z dodatkowymi, nie odrzucownymi podczas czyszczenia smieciami
        %
        %         quality = signalQuality( fullSkelet,size(dobrySYGNAL,1),sfreq );
        %             if(quality==0)
        %                 %ANN
        %             else
        wykrycia(currentEcg) = length(AnnSkeletonECG);
        stary = ANNourREFstage1;
        nowy = AnnSkeletonECG;
        polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
        ANNourREFstage1 =  polaczonySzkielet;                           %  ANNourREFstage2 - ostateczny szkielet 2.0
        %             end
        %         if( strcmp(alarm_type, 'Tachycardia') || strcmp(alarm_type, 'Ventricular_Tachycardia')  || strcmp(alarm_type, 'Ventricular_Flutter_Fib'))
        %             newrecordName = strcat(recordName(end-4:end),'new');
        %             mat2wfdb(dobrySYGNAL,newrecordName,sfreq,[],'mV');
        %             gqrs(newrecordName,[],[],1,[],'qra');          %tutaj jest recordName a nie dobrySYGNAL, poniewaz gqrs przyjmuje stringa oznaczajacego nazwe pliku
        %             ANNfromGQRS = rdann(newrecordName,'qra');
        %             ANNfromGQRS = removeOutliers(ANNfromGQRS,sfreq);
        %             delete(strcat(newrecordName,'.dat'));
        %             delete(strcat(newrecordName,'.hea'));
        %             delete(strcat(newrecordName,'.qra'));
        %
        %             stary = ANNourREFstage1;
        %             nowy = ANNfromGQRS;
        %             polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
        %             ANNourREFstage1 =  polaczonySzkielet;
        %         end
    end
end

Qrspos = ANNourREFstage1;
for i=2:length(ANNourREFstage1)
    rr2=ANNourREFstage1(i);
    rr1=ANNourREFstage1(i-1);
    if ((rr2-rr1)<25)              % jezeli annotacje s bliej ni 200ms, to usuwamy pierwsz z nich (5probek - 20ms)
        Qrspos(i)=0;
    end
end
Qrspos=unique(Qrspos);

% do adnego rysowania wykresw
if length(wykrycia)>1 && wykrycia(1,1)<wykrycia(2,1)
    dobrySYGNAL = movingMedian(signal(:,ecg_ind(2)),window);               % odejmowanie ruchomej mediany od sygnalu EKG za pomoca funkcji umieszczone w pliku movingMedian.m
    %  dobrySygnal - sygnal EKG po odjeciu mediany
    
    [b, a] = butter(8,40/(sfreq/2));                                    % filtruje sygna poniej 40 Hz filtrem Butterwortha 8 rzdu
    dobrySYGNAL = filter(b,a,dobrySYGNAL);
else
    dobrySYGNAL = movingMedian(signal(:,ecg_ind(1)),window);               % odejmowanie ruchomej mediany od sygnalu EKG za pomoca funkcji umieszczonej w pliku movingMedian.m
    %  dobrySygnal - sygnal EKG po odjeciu mediany
    
    [b, a] = butter(8,40/(sfreq/2));                                    % filtruje sygna poniej 40 Hz filtrem Butterwortha 8 rzdu
    dobrySYGNAL = filter(b,a,dobrySYGNAL);
end
%--------------------------------------------------------------------------
%-[3] Analiza sygnau BP --------------------------------------------------
%--------------------------------------------------------------------------

window = floor(0.35*sfreq);                                            % wybieram dlugosc okna dla ruchomej mediany na 350 ms                                                                           %  dobreBP - sygnal BP po odjeciu mediany i odwroceniu czasu
dolnaLOW= floor( 0.090 *sfreq);                                 %  dolnaLOW   - lewy zakres szukania minimalnej dlugosci spadku na 90 ms
dolnaHIGH= floor(0.090 *sfreq);                                 %  dolnaHIGH  - prawy zakres szukania minimalnej dlugosci spadku na 110 ms
gornaLOW= floor(0.140 *sfreq);                                  %  usgornaLOW - lewy zakres szukania maksymalnej dlugosci spadku na 140 ms
gornaHIGH= floor(0.160 *sfreq);                                 %  gornaHIGH  - prawy zakres szukania maksymalnej dlugosci spadku na 160 ms
stepLn = round(0.02*sfreq);                                     %  stepLn - rozdzielczosc szukania dobrych zakresow dlugosci spadkow na 5 ms
lowg = 0.10;                                                    % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 90% prbek w sygnale
highg = 0.90;                                                   % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
offset=0;
qualityBP=0;
dobreBPmedian = 0;
annsBP=[];
AnnSkeletonBP =  [];                                               % jesli nie bylo sygnalu BP -  szkielet 2.0 bedzie po prostu kopia szkieletu 1.0
ANNourREFstage2=Qrspos;
AnnSkeletonBPost = [];

if(~isempty(bp_ind) )                                                % sprawdzam, czy wystpuje w ogole kanal cisnienia BP. Jesli tak - zaczynam analize
    for currentBP=1:length(bp_ind)
        
        dobreBPmedian = movingMean(signal(:,bp_ind(currentBP)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        dobreBP = flipud(dobreBPmedian);                                % Odwracamy czas (-t), by patrzec na wzrosty.
        % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        
        [b, a] = butter(8,40/(sfreq/2));
        dobreBP = filter(b,a,dobreBP);
        [annsBP,lowLengthBestBP,highLengthBestBP, fullSkeletBP] = rsSlopeDetection(dobreBP,sfreq, dolnaLOW, dolnaHIGH, gornaLOW, gornaHIGH, stepLn, lowg, highg,0);
        %         dobreBP = flipud(dobreBP);
        %[annsBP,sign,en_thres,R_t] = qrs_detect2(dobreBP,0.250,0.6,sfreq,[],[],0);
        %  annsBP - znalezione anotacje BP
        %  lowLengthBestBP - dobrana minimalna dlugosc spadku krzywej BP (w probkach)
        %  highLengthBestBP - dobrana maksymalna dlugosc spadku krzywej BP (w probkach)
        %  fullSkeletBP - znalezione anotacje pikow BP wraz z dodatkowymi, nie odrzucownymi podczas czyszczenia smieciami
        annsBP_notmoved = size(dobreBP,1) - annsBP;                     % Odwracamy z powrotem czas dla anotacji (-t) --> (t),  mie je ustawione w dobrym kierunku.
        
        %             if(~isempty(ecg_ind))                                       % Jesli byl sygnal EKG, licze na jego podstawie srednie przesuniecie pomiedzy pikami R w sygnale EKG, a maksimami wychylen krzywej cisnienia
        %                 if(size(ANNourREFstage1,1)<3)
        %                     offset = floor(0.28 * sfreq);
        %                 else
        %annsBP_notmoved = annsBP_notmoved';
        offset = floor(bpOffsetDetection(ANNourREFstage1,annsBP_notmoved,sfreq));
        %                 end
        %             else                                                            % Jesli nie bylo kanalu EKG - ustalam przeuniecie na 280 ms
        %             offset = floor(0.28 * sfreq);                                      %  offset - srednie przesuniecie pomiedzy pikami R w EKG a pikami krzywej BP
        %             end
        AnnSkeletonBP = annsBP_notmoved - round(offset);                % Przesuwam anotacje dla krzywej BP by otrzymac ostateczna liste anotacji
        AnnSkeletonBP = sort(AnnSkeletonBP);
        
        stary = AnnSkeletonBPost;
        nowy = AnnSkeletonBP;
        polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
        AnnSkeletonBPost =  polaczonySzkielet;
        
    end
    %         qualityBP = signalQuality( fullSkeletBP,size(dobreBP,1),sfreq );
    %             if(qualityBP==0)
    %               %  AnnSkeletonBP=[];                                             %#ok<NASGU>
    %             else
    stary = ANNourREFstage2;
    nowy = AnnSkeletonBP;
    polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
    ANNourREFstage2 =  polaczonySzkielet;                           %  ANNourREFstage2 - ostateczny szkielet 2.0
    %             end
end

%         plotAnnotations(AnnSkeletonBP, sfreq, 100,'mx');

%plotAnnotations(fullSkelet, sfreq, 1,'ro');

%       ANN_OST=plotAnnotations(ANNost, sfreq, 1);
%       ANN_BP=plotAnnotations(ANNourREFstage2, bp_fs, 1);

%--------------------------------------------------------------------------
%-[4] Analiza sygnau PLETH --------------------------------------------------
%--------------------------------------------------------------------------

window = floor(0.35*sfreq);                                            % wybieram dlugosc okna dla ruchomej mediany na 350 ms                                                                           %  dobreBP - sygnal BP po odjeciu mediany i odwroceniu czasu
dolnaLOW= floor( 0.040 *sfreq);                                 %  dolnaLOW   - lewy zakres szukania minimalnej dlugosci spadku na 90 ms
dolnaHIGH= floor(0.120 *sfreq);                                 %  dolnaHIGH  - prawy zakres szukania minimalnej dlugosci spadku na 110 ms
gornaLOW= floor(0.140 *sfreq);                                  %  usgornaLOW - lewy zakres szukania maksymalnej dlugosci spadku na 140 ms
gornaHIGH= floor(0.20 *sfreq);                                 %  gornaHIGH  - prawy zakres szukania maksymalnej dlugosci spadku na 160 ms
stepLn = round(0.02*sfreq);                                    %  stepLn - rozdzielczosc szukania dobrych zakresow dlugosci spadkow na 5 ms
lowg = 0.10;                                                     % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 90% prbek w sygnale
highg = 0.90;                                                       % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
offset=0;
qualityPLETH=0;
annsPLETH = [];
dobrePLETH=[];
dobrePLETHmedian = 0;
AnnSkeletonPLETH = [];                                             % jesli nie bylo sygnalu BP -  szkielet 2.0 bedzie po prostu kopia szkieletu 1.0
ANNourREFstage3=ANNourREFstage2;
ANNourREFstage4 =ANNourREFstage3;

annsPLETHAll=cell(2,1);

if(~isempty(pleth_ind) )                                                % sprawdzam, czy wystpuje w ogole kanal cisnienia BP. Jesli tak - zaczynam analize
    
    for currentPLETH=1:length(pleth_ind)
        
        %         if( strcmp(alarm_type, 'Tachycardia') || strcmp(alarm_type, 'Ventricular_Tachycardia')  || strcmp(alarm_type, 'Ventricular_Flutter_Fib'))
        %             for o=1:2
        %                 dobrePLETHmedian = movingMean(signal(:,pleth_ind(currentPLETH)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        %                 if(o==1) dobrePLETH = flipud(dobrePLETHmedian); else dobrePLETH=dobrePLETHmedian; end                               % Odwracamy czas (-t), by patrzec na wzrosty.
        %                 % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        %
        %                 [b, a] = butter(8,40/(sfreq/2));
        %                 dobrePLETH = filter(b,a,dobrePLETH);
        %
        %                 [annsPLETH,lowLengthBestPLETH,highLengthBestPLETH, fullSkeletPLETH] = rsSlopeDetection(dobrePLETH,sfreq, dolnaLOW, dolnaHIGH, gornaLOW, gornaHIGH, stepLn, lowg, highg,0);
        %                 if(o==1) annsPLETHAll{o} = size(dobrePLETH,1) - annsPLETH; else annsPLETHAll{o}=annsPLETH; end                   % Odwracamy z powrotem czas dla anotacji (-t) --> (t),  mie je ustawione w dobrym kierunku.
        %             end
        %             %             length(annsPLETHAll{1})
        %             %             length(annsPLETHAll{2})
        %             [~ , inxMAX] = max([length(annsPLETHAll{1}) length(annsPLETHAll{2}) ]);
        %             annsPLETH_notmoved=annsPLETHAll{inxMAX};
        %         else
        %             dobrePLETHmedian = movingMean(signal(:,pleth_ind(currentPLETH)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        %             dobrePLETH = flipud(dobrePLETHmedian);                                % Odwracamy czas (-t), by patrzec na wzrosty.
        %             % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        %
        %             [b, a] = butter(8,40/(sfreq/2));
        %             dobrePLETH = filter(b,a,dobrePLETH);
        %
        %             [annsPLETH,lowLengthBestPLETH,highLengthBestPLETH, fullSkeletPLETH] = rsSlopeDetection(dobrePLETH,sfreq, dolnaLOW, dolnaHIGH, gornaLOW, gornaHIGH, stepLn, lowg, highg,0);
        %             annsPLETH_notmoved = size(dobrePLETH,1) - annsPLETH;                     % Odwracamy z powrotem czas dla anotacji (-t) --> (t),  mie je ustawione w dobrym kierunku.
        %         end
        
        dobrePLETHmedian = movingMean(signal(:,pleth_ind(currentPLETH)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        dobrePLETH = (dobrePLETHmedian);                                % Odwracamy czas (-t), by patrzec na wzrosty.
        % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        
        [b, a] = butter(8,40/(sfreq/2));
        dobrePLETH = filter(b,a,dobrePLETH);
        
        %kombinacje Igi z min/max
        upperPLETH = dobrePLETH(dobrePLETH>0);
        lowerPLETH = dobrePLETH(dobrePLETH<0);
        if abs(mean(upperPLETH)) < abs(mean(lowerPLETH))      % jeeli jest wicej prbek w grnej czci to zakadam e w dolnej sa adne piki i tam ich szukam
            disp('patrze na min')
            minpeakheight = 0.9*abs(mean(lowerPLETH));
            [~, annsPLETH] = findpeaks(-dobrePLETH,'MINPEAKDISTANCE', 40, 'MINPEAKHEIGHT', minpeakheight);%, 'THRESHOLD', 0.001*minpeakheight );
        else
            disp('patrze na max')
            minpeakheight = 0.9*abs(mean(upperPLETH));
            [~, annsPLETH] = findpeaks(dobrePLETH,'MINPEAKHEIGHT', minpeakheight,'MINPEAKDISTANCE', 40);% 'THRESHOLD', 0.001*minpeakheight );
        end
        
        annsPLETH_notmoved =annsPLETH ;% size(dobrePLETH,1) - annsPLETH;
        
        offset = floor(plethOffsetDetection(Qrspos,annsPLETH_notmoved,sfreq));
        
        AnnSkeletonPLETH = annsPLETH_notmoved - round(offset);                % Przesuwam anotacje dla krzywej BP by otrzymac ostateczna liste anotacji
        AnnSkeletonPLETH = sort(AnnSkeletonPLETH);
    end
    % usuwanie za bliskich annotacji
    annpos = AnnSkeletonPLETH;
    for i=2:length(AnnSkeletonPLETH)
        rr2=AnnSkeletonPLETH(i);
        rr1=AnnSkeletonPLETH(i-1);
        if ((rr2-rr1)<60)              % jezeli annotacje s bliej ni 200ms, to usuwamy pierwsz z nich (5probek - 20ms)
            annpos(i)=0;
        end
    end
    AnnSkeletonPLETH=unique(annpos);
    
    stary = ANNourREFstage3;
    nowy = AnnSkeletonPLETH;
    polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
    
    ANNourREFstage4 =  polaczonySzkielet;
end

annpos = ANNourREFstage4;
for i=2:length(ANNourREFstage4)
    rr2=ANNourREFstage4(i);
    rr1=ANNourREFstage4(i-1);
    if ((rr2-rr1)<50)              % jezeli annotacje s bliej ni 160ms, to usuwamy pierwsz z nich (5probek - 20ms)
        annpos(i)=0;
    end
end
ANNourREFstage4=unique(annpos);

%--------------------------------------------------------------------------
%-[] WARUNKI NA TYPY ALARMW ----------------------------------------------
%--------------------------------------------------------------------------

timeANN=[];
lastANN=[];
diffLastANN = [];
timeANN = ANNourREFstage4/sfreq;    % ostatni szkielet w skali czasu

alarmResult=1;

if length(dobrySYGNAL)<=75000
    lastANN = timeANN(timeANN>=270 & timeANN<=300);    % fragment osi powyzej 270s
    diffLastANN = diff(lastANN);        % rnice pomidzy kolejnymi annotacjami wikszymi od 270s
    
    switch alarm_type
        case 'Asystole'
            ANNourREFstage4(end+1) = 75000;
            timeANN=[];
            lastANN=[];
            diffLastANN = [];
            timeANN = ANNourREFstage4/sfreq;
            lastANN = timeANN(timeANN>=270 & timeANN<=300);
            diffLastANN = diff(lastANN);
            if (max(diffLastANN)<4)
                alarmResult = 0;
            end
        case 'Bradycardia'
            
                  annpos = Qrspos;
            for i=2:length(Qrspos)
                rr2=Qrspos(i);
                rr1=Qrspos(i-1);
                if ((rr2-rr1)<70)              % jezeli annotacje s bliej ni 350ms, to usuwamy pierwsz z nich (5probek - 20ms)
                    annpos(i)=0;
                end
            end
            Qrspos = unique(annpos);
            
            if max(diff(Qrspos(Qrspos>=270*250 & Qrspos<=300*250))) < 2*250
                timeANN = ANNourREFstage3/sfreq;
                lastANN = timeANN(timeANN>=270 & timeANN<=300);
            end
            
            N=length(lastANN);
            y=lastANN;
            window=4;
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =mean(diff(y(nr:nr+3)));
            end
            
            if (max(okno) < 1.5)
                alarmResult = 0;
            end
        case 'Tachycardia'
            N=length(lastANN);
            y=lastANN;      %ostatnie 30sek
            window=17;
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =mean(diff(y(nr:nr+16)));
            end
            
            if (min(okno)>(0.4286))
                alarmResult = 0;
            end
        case 'Ventricular_Tachycardia'
            N=length(lastANN);
            y=lastANN;
            window = 6;
            
            HR = mean(diff(y));     % HR w ostatnich 30sek zapisu
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =median(diff(y(nr:nr+5)));     % bya rednia, ale pozwalaa na jedn dodatkow annotacje ktra psua wszystko zmniejszajc redni
            end
            if (min(okno)>(0.6) || HR < 0.575 )    % mwimy ze alarm by faszywy jeeli w oknie z najkrtszymi RR jest wiecej niz 0.6,  albo jak ostatnie 30sek sygnau ma HR > 100BPM
                alarmResult = 0;
            end
        case 'Ventricular_Flutter_Fib'  %JAK NA RAZIE SAM WARUNEK NA TRZEPOTANIE!
            
            zeroSTDTable=[];
            if(~isempty(ecg_ind) )
                
                for currentEcg=1:length(ecg_ind)
                    
                    %             [zeroSTD]=zeroDetection(dobrySYGNAL, sfreq)
                    [zeroSTD]=zeroDetection(signal(:,ecg_ind(currentEcg)), sfreq);
                    zeroSTDTable=[zeroSTDTable ; zeroSTD];
                end
            end
            
            if (sum(zeroSTDTable > 15))
                alarmResult = 0;
            end
            
        otherwise
            error(['Unknown alarm type: ' alarm_type])
    end
    
else
    %% wersja retrospektywna
    lastANN = timeANN(timeANN>=270 & timeANN<=301);    % fragment osi powyzej 270s
    diffLastANN = diff(lastANN);        % rnice pomidzy kolejnymi annotacjami wikszymi od 270s
    
    switch alarm_type
        case 'Asystole'
            
            ANNourREFstage4(end+1) = 75250;
            timeANN=[];
            lastANN=[];
            diffLastANN = [];
            timeANN = ANNourREFstage4/sfreq;
            lastANN = timeANN(timeANN>=270 & timeANN<=301);
            diffLastANN = diff(lastANN);
            
            if (max(diffLastANN)<4)
                alarmResult = 0;
            end
        case 'Bradycardia'
            
            annpos = Qrspos;
            for i=2:length(Qrspos)
                rr2=Qrspos(i);
                rr1=Qrspos(i-1);
                if ((rr2-rr1)<70)              % jezeli annotacje s bliej ni 350ms, to usuwamy pierwsz z nich (5probek - 20ms)
                    annpos(i)=0;
                end
            end
            Qrspos = unique(annpos);
            
            max(diff(Qrspos(Qrspos>=270*250 & Qrspos<=301*250)))
            if max(diff(Qrspos(Qrspos>=270*250 & Qrspos<=301*250))) < 0.1*250
                timeANN = ANNourREFstage3/sfreq;
                lastANN = timeANN(timeANN>=270 & timeANN<=301);
            end
            
            N=length(lastANN);
            y=lastANN;
            window=4;
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =mean(diff(y(nr:nr+3)));
            end
            
            if (max(okno) < 1.5)
                alarmResult = 0;
            end
            
            
        case 'Tachycardia'
            N=length(lastANN);
            y=lastANN;      %ostatnie 30sek
            window=17;
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =mean(diff(y(nr:nr+16)));
            end
            
            if (min(okno)>(0.4286))
                alarmResult = 0;
            end
        case 'Ventricular_Tachycardia'
            N=length(lastANN);
            y=lastANN;
            window = 6;
            
            HR = mean(diff(y));     % HR w ostatnich 30sek zapisu
            
            Nramek=N-window+1; % ilosc ramek
            okno=zeros(1,Nramek);
            for nr = 1:Nramek
                % pobranie kolejnego fragmentu sygnalu
                okno(nr) =median(diff(y(nr:nr+5)));     % bya rednia, ale pozwalaa na jedn dodatkow annotacje ktra psua wszystko zmniejszajc redni
            end
            if (min(okno)>(0.6) || HR < 0.575 )    % mwimy ze alarm by faszywy jeeli w oknie z najkrtszymi RR jest wiecej niz 0.6,  albo jak ostatnie 30sek sygnau ma HR > 100BPM
                alarmResult = 0;
            end
            
        case 'Ventricular_Flutter_Fib'  %JAK NA RAZIE SAM WARUNEK NA TRZEPOTANIE!
            
            zeroSTDTable=[];
            if(~isempty(ecg_ind) )
                
                for currentEcg=1:length(ecg_ind)
                    
                    %             [zeroSTD]=zeroDetection(dobrySYGNAL, sfreq)
                    [zeroSTD]=zeroDetection(signal(:,ecg_ind(currentEcg)), sfreq);
                    zeroSTDTable=[zeroSTDTable ; zeroSTD];
                end
            end
            
            if (sum(zeroSTDTable > 15))
                alarmResult = 0;
            end
            
        otherwise
            error(['Unknown alarm type: ' alarm_type])
    end
end


D = fileread('./ALARMS1.txt');
pat = [recordName(end-4:end) ',(\w*),'];
a = regexp(D, pat, 'end');

ichalarm = D(a+1);

close all;                                                            % zamykam wszystkie otwarte okna z outputem

CZY_PLOT=1;
if(CZY_PLOT)
    dipLow = 4.5*60;                                                        %  dipLow - dolny zakres wyswietlania wynikow w s (zerowa sekunda)
    dipHigh= 5*60;                                                      %  dipHigh - gorny zakres wyswietlania wynikow w s (30 sekunda)
    h1 = figure;                                                          % otwieram nowy rysunek                  % tworzymy trzy wykresy w pionie
    subplot(2,1,1);                                                        % na pierwszym wykresie umieszczamy sygnal EKG po usunieciu terndu z anotacjami referencyjnymi i wybranymi szkieletami
    hold on;
    plot( tm,dobrySYGNAL,'-k', 'MarkerSize', 2 )                        % wyswietl sygnal EKG po usunieciu trendu
    plotAnnotations(ANNourREFstage4, fs, 1.0, 'or');                         % dodaj do wykresu anotacje z ostatecznego szkieletu - czyli ostateczny wynik dzialania algorytmu
    plotAnnotations(Qrspos, fs, 0.8, 'oc');                 % dodaj do wykresu anotacje wykrytem na samym sygnale EKG
    plotAnnotations(ANNourREFstage2, fs, 0.6, 'om');
    axis([dipLow dipHigh 50 350], 'autoy');                             % ustaw zakres wyswietlania
    % ustaw legede, tytul itp.
    legend({'ECG', 'ostateczny szkielet', 'anotacje z EKG','anotacje z BP'},'Location','Southoutside', 'Orientation','horizontal');
    ylabel('ECG');
    xlabel('time[s]');
    title([recordName(end-4:end)  '      WYNIK  nasz: ' num2str(alarmResult)  '     prawidlowy: '  num2str(ichalarm)], 'FontWeight','bold' )
    if(~isempty(pleth_ind) )
        subplot(2,1,2);                                                       % na trzecim wykresie umieszczamy tachogram (RRy) ostateczny oraz referencyjny
        hold on;
        plot( tm,(dobrePLETH+0.0001),'-k', 'MarkerSize', 2 )                      % wyswietl sygnal BP po usunieciu trendu
        maxx = max(signal(:,pleth_ind));
        if (~isempty(AnnSkeletonPLETH))
            plotAnnotations(AnnSkeletonPLETH, fs, 1.1*maxx, 'or');           % dodaj do wykresu anotacje wykryte na sygnale BP
            plotAnnotations(annsPLETH_notmoved, fs, 0.9*maxx, 'og');
        end
        axis([dipLow dipHigh 50 350], 'autoy');                             % ustaw zakres wyswietlania
        %        ustaw legede, tytul itp.
        legend({'sygnal PLETH', 'anotacje z BP'},'Location','Southoutside', 'Orientation','horizontal');
        ylabel('PLETH');
        xlabel('time[s]');
        hold off;
    elseif(~isempty(bp_ind) )
        subplot(2,1,2);                                                       % na drugim wykresie umieszczamy sygnal BP po usunieciu terndu z anotacjami referencyjnymi i wybranymi szkieletami
        hold on;
        plot( tm,flipud(dobreBP),'-k', 'MarkerSize', 2 )                      % wyswietl sygnal BP po usunieciu trendu
        maxx = max(signal(:,bp_ind));
        if (~isempty(AnnSkeletonBP))
            plotAnnotations(AnnSkeletonBP, fs, 1.1*maxx, 'or');           % dodaj do wykresu anotacje wykryte na sygnale BP
            plotAnnotations(annsBP_notmoved, fs, 0.9*maxx, 'oc');
        end
        axis([dipLow dipHigh 50 350], 'autoy');                             % ustaw zakres wyswietlania
        % ustaw legede, tytul itp.
        legend({'sygnal BP', 'anotacje z BP','anotacje z BP not moved'},'Location','Southoutside', 'Orientation','horizontal');
        ylabel('BP');
        xlabel('time[s]');
    end
    
    
    %% zapis obrazkow
    ktorobi = 'igrzegorczyk';
    nazwafolderu = 'wyniki_1908_2\';
    if exist(strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu , alarm_type, '\dobre'),'dir') == 0
        mkdir(strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu  , alarm_type, '\dobre' ))
    end
    if exist(strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu  , alarm_type, '\zle'),'dir') == 0
        mkdir(strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu  , alarm_type, '\zle'))
    end
    
    if alarmResult == str2num(ichalarm)
        output=strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu , alarm_type, '\dobre\' , recordName(end-4:end));
    else
        output=strcat('C:\Users\',  ktorobi ,  '\Desktop\', nazwafolderu , alarm_type, '\zle\' , recordName(end-4:end));
    end
    saveas(h1, output, 'jpg')
end
%%
% Write result to answers.txt
fid = fopen(answers, 'a');

if (fid == -1)
    error('Could not open answer file');
end

% Get base name of record (without directories)
i = strfind(recordName, filesep);
if (~isempty(i))
    basename = recordName(i(end)+1 : end);
else
    basename = recordName;
end

fprintf(fid, '%s,%d\n', basename, alarmResult);
fclose(fid);

end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end
end
