function alarmResult=challengeNASZ(recordName, alarm_type)
close all

recordName=strcat('challenge/training/',recordName);
% Name of file containing answers
answers = 'answers.txt';

[~,config] = wfdbloadlib;                           % inicjalizacja pakietu wfdb
%     if(config.inOctave)
%         crash_dumps_octave_core(0);
%     end

annName = 'qrs';                                    % ustalenie nazwy anotacji (wymagane przez warunki Challenge)

[siginfo, fs] = wfdbdesc2(recordName);
% wczytanie danych informacyjnych o nagraniu pod zmienn siginfo (dziwna struktura o formacie wfdb)
description = squeeze(struct2cell(siginfo));        % przekonwertowanie danych informacyjnych na czytelny format tablicy "komrkowej" matlaba
descriptionNamesTable = description(5,:)           % wycignicie samych nazw sygnaw na wyjciu mamy jednowymiarow tablic ze stringami zawierajcymi nazwy kanaw

% [~,signal,Fs,siginfo]=rdmat(recordName);
% description = squeeze(struct2cell(siginfo));        % przekonwertowanie danych informacyjnych na czytelny format tablicy "komrkowej" matlaba
% descriptionNamesTable = description(4,:);           % wycignicie samych nazw sygnaw na wyjciu mamy jednowymiarow tablic ze stringami zawierajcymi nazwy kanaw
% fs = Fs;

if(~isnan(fs))
    sfreq = fs(1);
else
    sfreq=sscanf(siginfo(1).SamplingFrequency,'%f');
end


[tm,signal] = rdsamp(recordName);                 % wczytanie sygnaw dla aktualnie analizowanego przypadku
% tm - podstawa czasowa sygnau
% signal - wszystkie sygnay istniejce dla danego przypadku.
%Tablica N x m, gdzie N to dugo nagrania, a m - ilo dostpnych sygnaw


ecg_ind = 1;
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'I'); get_index(descriptionNamesTable,'II'); get_index(descriptionNamesTable,'III')];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'IV'); get_index(descriptionNamesTable,'V'); get_index(descriptionNamesTable,'VI')];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'aVF'); get_index(descriptionNamesTable,'aVL'); get_index(descriptionNamesTable,'aVR')];
ecg_ind = [ecg_ind; get_index(descriptionNamesTable,'MLP')];
ecg_ind = unique(ecg_ind);

bp_ind = [get_index(descriptionNamesTable,'BP'); get_index(descriptionNamesTable,'ABP'); get_index(descriptionNamesTable,'ART')];
bp_ind = unique(bp_ind);

pleth_ind = [get_index(descriptionNamesTable,'PLETH')];
pleth_ind = unique(pleth_ind);

RESP_ind = [get_index(descriptionNamesTable,'RESP')];
RESP_ind = unique(RESP_ind);



%--------------------------------------------------------------------------
%-[3] Analiza sygnaw EKG ------------------------------------------------
%--------------------------------------------------------------------------
%granice dla sprawdzania:
graniceRSslopeEKG = [   0.017, 0.036;...
    0.026, 0.036;...
    0.035, 0.046;...
    0.017, 0.046;...
    0.026, 0.046;...
    0.017, 0.090;...
    0.026, 0.090;...
    0.035, 0.090;...
    0.017, 0.15;...
    0.035, 0.15];
graniceRSslopeEKG = floor(graniceRSslopeEKG .* sfreq);
graniceAmpEKG= [0.03, 0.97];
sfreq
lowAmpBest = 0.03;                                                % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 95% prbek w sygnale
highAmpBest = 0.97;                                                     % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
window = round(0.250*sfreq);                                        % wybieram dlugosc okna dla ruchomej mediany na 250 ms
quality=0;
AnnSkeletonECG=[];
dAnnSkeletonECG=[];
ANNourREFstage1=[];
prog1=0;
prog2=0;   % do kosza?
lowLengthBest=floor( 0.017 *sfreq);
highLengthBest=floor(0.055 *sfreq);
fullSkelet =[];
dobrySYGNAL=0;
ANNourREFstage1=[];
ecg = 0;

if(~isempty(ecg_ind) )                                               % sprawdzam, czy wystpuje w ogole kanal EKG. Jesli tak - zaczynam analize
    for currentEcg=1:length(ecg_ind)
        disp('EKG');
        dobrySYGNAL = movingMedian(signal(:,ecg_ind(currentEcg)),window);               % odejmowanie ruchomej mediany od sygnalu EKG za pomoca funkcji umieszczonej
        %w pliku movingMedian.m
        %  dobrySygnal - sygnal EKG po odjeciu mediany
        % uruchamiam algorytm wyszukiwania spadkow RS
        
        [b, a] = butter(8,40/(sfreq/2));                                    % filtruje sygna poniej 40 Hz filtrem Butterwortha 8 rzdu
        dobrySYGNAL = filter(b,a,dobrySYGNAL);
        
        %                  figure
        %                 hold on
        %                 plot(signal(:,ecg_ind(currentEcg)), 'g')
        %                 hold on
        %                 plot(dobrySYGNAL, 'm')
        
        
        [AnnSkeletonECG,lowLengthBest,highLengthBest, fullSkelet,lowAmpBest,highAmpBest,ANNourINDEXBest, SQdiff] = rsSlopeDetectionEKG(dobrySYGNAL,sfreq, graniceRSslopeEKG, graniceAmpEKG,1);
        %  AnnSkeletonECG - znalezione anotacje EKG ( szkielet 1.0)
        %  lowLengthBest - dobrana minimalna dlugosc spadku RS (w probkach)
        %  highLengthBest - dobrana maksymalna dlugosc spadku RS (w probkach)
        %  fullSkelet - znalezione anotacje EKG wraz z dodatkowymi, nie odrzucownymi podczas czyszczenia smieciami
        %
        stary = ANNourREFstage1;
        nowy = AnnSkeletonECG;
        polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
        ANNourREFstage1 =  polaczonySzkielet;
        
        %
        %         %%%%%%%%%%%%%%%%fullSkelet przyjmujemy jako anotacje, ktore
        %         %%%%%%%%%%%%%%%%analizujemy
        %
        %         figure(currentEcg)
        % %
        %         plot(ecgx,dobrySYGNAL,'b')
        %         hold
        % %         plotAnnotations(AnnSkeletonECG, sfreq, 1,'ro');
        %        plotAnnotations(fullSkelet, sfreq, 1,'ro');
        
        %       ANN_OST=plotAnnotations(ANNost, sfreq, 1);
        %       ANN_BP=plotAnnotations(ANNourREFstage2, bp_fs, 1);
        
    end
end


%--------------------------------------------------------------------------
%-[3] Analiza sygnau BP --------------------------------------------------
%--------------------------------------------------------------------------

window = floor(0.35*sfreq);                                            % wybieram dlugosc okna dla ruchomej mediany na 350 ms                                                                           %  dobreBP - sygnal BP po odjeciu mediany i odwroceniu czasu
dolnaLOW= floor( 0.090 *sfreq);                                 %  dolnaLOW   - lewy zakres szukania minimalnej dlugosci spadku na 90 ms
dolnaHIGH= floor(0.090 *sfreq);                                 %  dolnaHIGH  - prawy zakres szukania minimalnej dlugosci spadku na 110 ms
gornaLOW= floor(0.140 *sfreq);                                  %  usgornaLOW - lewy zakres szukania maksymalnej dlugosci spadku na 140 ms
gornaHIGH= floor(0.160 *sfreq);                                 %  gornaHIGH  - prawy zakres szukania maksymalnej dlugosci spadku na 160 ms
stepLn = round(0.02*sfreq);                                    %  stepLn - rozdzielczosc szukania dobrych zakresow dlugosci spadkow na 5 ms
lowg = 0.10;                                                     % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 90% prbek w sygnale
highg = 0.90;                                                       % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
offset=0;
qualityBP=0;
dobreBPmedian = 0;
annsBP=[];
AnnSkeletonBP = [];
dAnnSkeletonBP =  [];                                               % jesli nie bylo sygnalu BP -  szkielet 2.0 bedzie po prostu kopia szkieletu 1.0
ANNourREFstage2=ANNourREFstage1;

if(~isempty(bp_ind) )                                                % sprawdzam, czy wystpuje w ogole kanal cisnienia BP. Jesli tak - zaczynam analize
    for currentBP=1:length(bp_ind)
        
        disp('BP');
        dobreBPmedian = movingMean(signal(:,bp_ind(currentBP)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        dobreBP = flipud(dobreBPmedian);                                % Odwracamy czas (-t), by patrzec na wzrosty.
        % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        
        %                 figure
        %         hold on
        %         plot(signal(:,bp_ind(currentBP)), 'g')
        %         hold on
        %         plot(dobreBPmedian, 'm'), title('BP');
        
        [b, a] = butter(8,40/(sfreq/2));
        dobreBP = filter(b,a,dobreBP);
        [annsBP,lowLengthBestBP,highLengthBestBP, fullSkeletBP] = rsSlopeDetection(dobreBP,sfreq, dolnaLOW, dolnaHIGH, gornaLOW, gornaHIGH, stepLn, lowg, highg,0);
        %  annsBP - znalezione anotacje BP
        %  lowLengthBestBP - dobrana minimalna dlugosc spadku krzywej BP (w probkach)
        %  highLengthBestBP - dobrana maksymalna dlugosc spadku krzywej BP (w probkach)
        %  fullSkeletBP - znalezione anotacje pikow BP wraz z dodatkowymi, nie odrzucownymi podczas czyszczenia smieciami
        annsBP_notmoved = size(dobreBP,1) - annsBP;                     % Odwracamy z powrotem czas dla anotacji (-t) --> (t),  mie je ustawione w dobrym kierunku.
        
        %             if(~isempty(ecg_ind))                                       % Jesli byl sygnal EKG, licze na jego podstawie srednie przesuniecie pomiedzy pikami R w sygnale EKG, a maksimami wychylen krzywej cisnienia
        %                 if(size(ANNourREFstage1,1)<3)
        %                     offset = floor(0.28 * sfreq);
        %                 else
        offset = floor(bpOffsetDetection(ANNourREFstage1,annsBP_notmoved,sfreq));
        %                 end
        %             else                                                            % Jesli nie bylo kanalu EKG - ustalam przeuniecie na 280 ms
        %             offset = floor(0.28 * sfreq);                                      %  offset - srednie przesuniecie pomiedzy pikami R w EKG a pikami krzywej BP
        %             end
        AnnSkeletonBP = annsBP_notmoved - round(offset);                % Przesuwam anotacje dla krzywej BP by otrzymac ostateczna liste anotacji
        AnnSkeletonBP = sort(AnnSkeletonBP);
        
    end
end

stary = ANNourREFstage2;
nowy = AnnSkeletonBP;
polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
ANNourREFstage2 =  polaczonySzkielet;

%         plotAnnotations(AnnSkeletonBP, sfreq, 100,'mx');




%plotAnnotations(fullSkelet, sfreq, 1,'ro');

%       ANN_OST=plotAnnotations(ANNost, sfreq, 1);
%       ANN_BP=plotAnnotations(ANNourREFstage2, bp_fs, 1);


%--------------------------------------------------------------------------
%-[4] Analiza sygnau PLETH --------------------------------------------------
%--------------------------------------------------------------------------

window = floor(0.35*sfreq);                                            % wybieram dlugosc okna dla ruchomej mediany na 350 ms                                                                           %  dobreBP - sygnal BP po odjeciu mediany i odwroceniu czasu
dolnaLOW= floor( 0.090 *sfreq);                                 %  dolnaLOW   - lewy zakres szukania minimalnej dlugosci spadku na 90 ms
dolnaHIGH= floor(0.090 *sfreq);                                 %  dolnaHIGH  - prawy zakres szukania minimalnej dlugosci spadku na 110 ms
gornaLOW= floor(0.140 *sfreq);                                  %  usgornaLOW - lewy zakres szukania maksymalnej dlugosci spadku na 140 ms
gornaHIGH= floor(0.160 *sfreq);                                 %  gornaHIGH  - prawy zakres szukania maksymalnej dlugosci spadku na 160 ms
stepLn = round(0.02*sfreq);                                    %  stepLn - rozdzielczosc szukania dobrych zakresow dlugosci spadkow na 5 ms
lowg = 0.10;                                                     % bede szukal spadku RS, tylko wtedy, gdy amplituda piku R jest wyzsza od wartoci 90% prbek w sygnale
highg = 0.90;                                                       % nie ma grnego ograniczenia na warto amplitudy R (100% rozkadu amplitud prbek)
offset=0;
qualityPLETH=0;
annsPLETH = [];
dobrePLETHmedian = 0;
AnnSkeletonPLETH = [];
dAnnSkeletonPLETH =  [];                                               % jesli nie bylo sygnalu BP -  szkielet 2.0 bedzie po prostu kopia szkieletu 1.0
ANNourREFstage3=ANNourREFstage2;

if(~isempty(pleth_ind) )                                                % sprawdzam, czy wystpuje w ogole kanal cisnienia BP. Jesli tak - zaczynam analize
    for currentPLETH=1:length(pleth_ind)
        
        disp('PLETH');
        dobrePLETHmedian = movingMean(signal(:,pleth_ind(currentPLETH)),window);            % odejmowanie ruchomej mediany od sygnalu BP za pomoca funkcji umieszczonej w pliku movingMedian.m
        dobrePLETH = flipud(dobrePLETHmedian);                                % Odwracamy czas (-t), by patrzec na wzrosty.
        % uruchamiam algorytm wyszukiwania spadkow RS na sygnale BP
        
        
        [b, a] = butter(8,40/(sfreq/2));
        dobrePLETH1 = filter(b,a,dobrePLETH);
        
        %         figure
        %         hold on
        %         plot(signal(:,pleth_ind(currentPLETH)), 'g')
        %         hold on
        %         plot(dobrePLETHmedian, 'm'), title('PLETH')
        
        
        [annsPLETH,lowLengthBestPLETH,highLengthBestPLETH, fullSkeletPLETH] = rsSlopeDetection(dobrePLETH,sfreq, dolnaLOW, dolnaHIGH, gornaLOW, gornaHIGH, stepLn, lowg, highg,0);
        %  annsBP - znalezione anotacje BP
        %  lowLengthBestBP - dobrana minimalna dlugosc spadku krzywej BP (w probkach)
        %  highLengthBestBP - dobrana maksymalna dlugosc spadku krzywej BP (w probkach)
        %  fullSkeletBP - znalezione anotacje pikow BP wraz z dodatkowymi, nie odrzucownymi podczas czyszczenia smieciami
        annsPLETH_notmoved = size(dobrePLETH,1) - annsPLETH;                     % Odwracamy z powrotem czas dla anotacji (-t) --> (t),  mie je ustawione w dobrym kierunku.
        
        %             if(~isempty(ecg_ind))                                       % Jesli byl sygnal EKG, licze na jego podstawie srednie przesuniecie pomiedzy pikami R w sygnale EKG, a maksimami wychylen krzywej cisnienia
        %                 if(size(ANNourREFstage1,1)<3)
        %                     offset = floor(0.28 * sfreq);
        %                 else
        offset = floor(bpOffsetDetection(ANNourREFstage1,annsPLETH_notmoved,sfreq));
        %                 end
        %             else                                                            % Jesli nie bylo kanalu EKG - ustalam przeuniecie na 280 ms
        %             offset = floor(0.15 * sfreq);                                      %  offset - srednie przesuniecie pomiedzy pikami R w EKG a pikami krzywej BP
        %             end
        AnnSkeletonPLETH = annsPLETH_notmoved - round(offset);                % Przesuwam anotacje dla krzywej BP by otrzymac ostateczna liste anotacji
        AnnSkeletonPLETH = sort(AnnSkeletonPLETH);
        
    end
end

stary = ANNourREFstage3;
nowy = AnnSkeletonPLETH;
polaczonySzkielet=joinSkeletons(stary,nowy,sfreq);              % lacze anotacje EKG (stary szkielet) z anotacjami z kanalu BP, uzyskujc nowy szkielet (szkielet 2.0)
ANNourREFstage3 =  polaczonySzkielet;
ANNourREFstage3 = removeOutliers(ANNourREFstage3,sfreq);


if(~isempty(ecg_ind) )
    figure
    ecgx=(1:length(dobrySYGNAL))/250;
    %plot(ecgx, ecg(1), 'b');
    plot(ecgx,signal(:,ecg_ind(1)),'b');
    hold on
    if(~isempty(ANNourREFstage1))
        plotAnnotations(ANNourREFstage1, sfreq, 1,'ro');
    end
    hold off;
    
    
    figure
    ecgx=(1:length(dobrySYGNAL))/250;
    %plot(ecgx, ecg(2), 'b');
    plot(ecgx,signal(:,ecg_ind(2)),'b');
    hold on
    if(~isempty(ANNourREFstage1))
        plotAnnotations(ANNourREFstage1, sfreq, 1,'ro');
    end
    
    hold off;
end

if(~isempty(bp_ind) )
    bpx=(1:length(dobreBP))/250;
    figure
    plot(bpx,dobreBP,'b')
    hold on;
    if(~isempty(ANNourREFstage2))
        plotAnnotations(ANNourREFstage2, sfreq, 1,'ro');
    end
    hold off;
end

if(~isempty(pleth_ind) )
    plethx=(1:length(dobrePLETH))/250;
    figure
    plot(plethx,dobrePLETH,'b')
    hold on;
    if(~isempty(ANNourREFstage3))
        plotAnnotations(ANNourREFstage3, sfreq, 1,'ro');
    end
    hold off;
end
%
timeANN=[];
lastANN=[];
diffLastANN = [];
timeANN = ANNourREFstage1/sfreq;
lastANN = timeANN(timeANN>=270);
diffLastANN = diff(lastANN);

alarmResult=1;

switch alarm_type
    case 'Asystole'
        ANNourREFstage3(end+1) = 75000;
        timeANN=[];
        lastANN=[];
        diffLastANN = [];
        timeANN = ANNourREFstage3/sfreq;
        lastANN = timeANN(timeANN>=270);
        diffLastANN = diff(lastANN);
        if (max(diffLastANN<4))
            alarmResult = 0;
        end
    case 'Bradycardia'
        N=length(lastANN);
        y=lastANN;
        window=4;
        
        Nramek=N-window+1; % ilosc ramek
        okno=zeros(1,Nramek);
        for nr = 1:Nramek
            % pobranie kolejnego fragmentu sygnalu
            okno(nr) =mean(diff(y(nr:nr+3)));
        end
        
        if (max(okno) < 1.5)
            alarmResult = 0;
        end
    case 'Tachycardia'
        N=length(lastANN);
        y=lastANN;      %ostatnie 30sek
        window=17;
        
        Nramek=N-window+1; % ilosc ramek
        okno=zeros(1,Nramek);
        for nr = 1:Nramek
            % pobranie kolejnego fragmentu sygnalu
            okno(nr) =mean(diff(y(nr:nr+16)));
        end
        
        if (min(okno)>(3/7))
            alarmResult = 0;
        end
    case 'Ventricular_Tachycardia'
        N=length(lastANN);
        y=lastANN;
        window = 17;
        
        Nramek=N-window+1; % ilosc ramek
        okno=zeros(1,Nramek);
        for nr = 1:Nramek
            % pobranie kolejnego fragmentu sygnalu
            okno(nr) =mean(diff(y(nr:nr+16)));
        end
        
        if (min(okno)>(3/7))
            alarmResult = 0;
        end
    case 'f' %'Ventricular_Flutter_Fib'  %JAK NA RAZIE SAM WARUNEK NA TRZEPOTANIE!
        
        zeroSTDTable=[];
        if(~isempty(ecg_ind) )
            
            for currentEcg=1:length(ecg_ind)
                
                %             [zeroSTD]=zeroDetection(dobrySYGNAL, sfreq)
                [zeroSTD]=zeroDetection(signal(:,ecg_ind(currentEcg)), sfreq);
                zeroSTDTable=[zeroSTDTable ; zeroSTD];
            end   
        end
                
        if (sum(zeroSTDTable > 15))
            alarmResult = 0;
        end
        
        
    otherwise
        error(['Unknown alarm type: ' alarm_type])
end

end


%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end
end
