function [offset] = bpOffsetDetection(skeletonECG,skeletonBP,sfreq)
    %  Funkcja bpOffsetDetection wylicza srednie przesuniecie pomiedzy
    % pikiem R sygnalu EKG, a pikiem cisnienia w sygnale BP. 
    %  Podstawa do obliczenia jest istnienie znalezionych anotacji z kanalu
    % EKG, jesli ich nie ma - funkcja nie zwroci dobrej wartosci lub sie
    % wywali.
    %
    % WEJSCIE:
    % skeletonEKG   - tablica z anotacjami pikow R w EKG w probkach
    % skeletonBP    - tablica z anotacjami maksimow sygnalu BP w probkach
    % sfreq         - czestotliwosc probkowania sygnalow (zakladamy
    %                 jednakowa
    % WYJSCIE:
    % offset        - wartosc przesuniecia w probkach
    

    dolnaDlugoscOffsetu = 0.040 * sfreq;                            % przyjmuje, ze offset nie bedzie krotszy niz 50 ms
    gornaDlugoscOffsetu = 0.360 * sfreq;                            % przyjmuje, ze offset nie bedzie dluzszy niz 300 ms
    
    polaczonySzkielet=[skeletonECG;skeletonBP];                     % lacze ze soba oba zestawy anotacji (z EKG i BP) w jedna tablice, jedna po drugiej
    polaczonySzkielet = sort(polaczonySzkielet);                    % sortuje tablice polaczonch anotacji, w wyniku dostaje uporzadkowany rosnaco zestaw anotacji
    diffySzkieletu = diff(polaczonySzkielet);                       % obliczam roznice pomiedzy sasiednimi anotacjami (analogicznie do tachogramu i RRow)
    diffySzkieletu(diffySzkieletu > gornaDlugoscOffsetu ) = [];     % wyrzucam z zestawu roznic wszystkie roznice wieksze niz gorna dopuszczalna dlugosc offsetu (gornaDlugoscOffsetu)
    diffySzkieletu(diffySzkieletu < dolnaDlugoscOffsetu ) = [];     % wyrzucam z zestawu roznic wszystkie roznice krotsze niz dolna dopuszczalna dlugosc offsetu (dolnaDlugoscOffsetu)
    if(~isempty(diffySzkieletu))                                                             % to co zostalo w tablicy "diffySzkieletu" to na pewno w znacznej wiekszosci wartosci offsetu
        skrajneL = 0;                                                    
        skrajneP = 0;
        dltabdiff=size(diffySzkieletu,1);                               % obliczam dlugosc uzyskanej tablicy "diffySzkieletu"
        skrajneL = ceil(0.2*dltabdiff);                                % wyznaczam lewostronna granice odciecia jako 20% dlugosci tablicy 
        skrajneP = floor(0.8*dltabdiff);                                % wyznaczam prawostronna granice odciecia jako 20% dl tablic
                                                                 
        % po odcieciu po 20% skrajnych przypadkow z kazdej strony zostaje 60% najbardziej potymalnych z ktorych liczymy offset                                                                
                                                                  
        i=skrajneL:skrajneP;                                            % okreslamy iterator, ktory wyznaczy nam srodkowe 60% tablicy diffySzkieletu
        diffySzkieletu1=diffySzkieletu(i);                              % przypisujemy te 60% diffySzkieletu do tablicy diffySzkieletu1 
                                                                    
                                                                                                                                
        offset = mean(diffySzkieletu1);                                  % obliczamy srednia wartosc tego co zostalo w "diffySzkieletu" po obcieciu skrajnych, czyli sredni offset.
    else
        offset = 0;
    end        
end
