function [Rvalues, Svalues, Qvalues] = QRSParameters(analysedSignal,lowBorderDist,upBorderDist,lowLength,upLength,liczQS)
    % Glowna funkcja algorytmu wykrywania spadkow RS. Funkcja znajduje w
    % sygnale wejsciowym spadki w sygnale, ktorych dlugosc jest zawarta w
    % przedziale <lowLength,upLength>, oraz amplituda poczatku sygnalu
    % zawiera sie w procentowym przedziale <lowBorderDist,upBorderDist> 
    % dystrybucji  wszystkich wartosci amplitud w calym sygnale. Przez
    % spadek rozumiemy tutaj ciag monotonicznie malejacych wartosci.
    % Dopuszczalne jest zlamanie monotonicznosci dla jednej probki (taki
    % zadzior na sygnale spowodowany szumem).
    %
    % WEJSCIE:
    % analysedSignal - odtrendowiony sygnal wejsciowy, niekoniecznie EKG
    % lowBorderDist  - dolna granica przedzialu, w ktorym znajdzie sie
    %                  amplituda poczatku spadku ( zakres od 0 do 1 )
    % upBorderDist   - gorna granica przedzialu, w ktorym znajdzie sie
    %                  amplituda poczatku spadku ( zakres od 0 do 1 )
    % upBorderDist   - gorna granica przedzialu dopuszczalnych dlugosci 
    %                  spadkow, wyrazona w probkach
    % lowLength      - gorna granica przedzialu dopuszczalnych dlugosci 
    %                  spadkow, wyrazona w probkach
    % amplitudaKonca        - parametr  oznacza wymuszenie koniecznosci przejscia
    %                  wyszukanego spadku przez ta wskazana wartosc.
    % WYJSCIE:
    % annotations    - posortowana tablica polozen poczatkow kazdego z 
    %                  wykrytych ciagow spadkow, wyrazona w probkach
    
                                                 % N - dlugosc analizowanego sygnalu
    sortowane = sort(analysedSignal);                                  % sortuje rosnaco wartosci bezwzgledne wszystkich wartosci wystepujacych w sygnale, 
    progdolny = sortowane(round(size(sortowane,1)*lowBorderDist));
    proggorny = sortowane(round(size(sortowane,1)*upBorderDist));
    RSamp = proggorny - progdolny;
    
%     if(upBorderDist == 1)                                                   % jesli granica gorna ampltudy wynosi 100%, upewnij sie, ze liczbowo bedzie wieksza od maksymalnej amplitudy w sygnale, 
%         prog2 = max(sortowane) + 1.0;                                       % tak by nie bylo ograniczenia z gory na amplitude poczatku spadku
%     else
%         prog2 = sortowane(round(size(sortowane,1)*upBorderDist));           % jesli granica gorna amplitudy < 100% dystrybucji wartosci amplitud - oblicz ja
%     end
%     prog3 = RSamp/30;                                                       % prog 3 - maksymalna wysokosc dopuszczalnego "zadzioru" w sygnale ( o tyle 1 probka w sygnale moze odbiegac od monotonicznosci)
    
    ECGdiffs=diff(analysedSignal);                                          % ciag roznic pomiedzy sasiednimi probkami ("pochodna dyksretna")

    % glowna czesc algorytmu - najlepiej to sobie rozrysowac
    SplitIndexes = (ECGdiffs >= 0);
    SplitIndexesL = [0; SplitIndexes(2:size(SplitIndexes)-1); 0];
    SplitIndexesP = [0; SplitIndexes(1:size(SplitIndexes)-2); 0];
    SplitPositions = (1:size(ECGdiffs,1))';
    
    indices = (SplitIndexes | (SplitIndexesL & SplitIndexesP));
    if(liczQS) 
        SplitPositionsQ = SplitPositions(~indices)+1;
    end
    SplitPositions = SplitPositions(indices);

     
    % w tym momencie, w SplitPositions mamy polozenia wszystkich probek,
    % ktore nie znajduja sie wewnatrz spadku, posortowane rosnaco. Teraz,
    % jesli odejmiemy od siebie sasiednie elementy tablicy SplitPositions,
    % otrzymamy tablice dlugosci spadkow w sygnale (brak spadku jest
    % rownoznaczny z dlugoscia = 1)
    
    
    piki = [];                                                              % piki - tu bedziemy przetrzymywac polozenia poczatkow spadkow o okreslonych parametrach (czyli np. polozen pikow R)
    Rposition = [];
    pikiS= [];
    pikiQ= [];
    Sposition = [];
    if isempty(SplitPositions)~=1                                           % jesli w ogole w sygnale byly spadki ,to...

        dlugoscipochodow = diff(SplitPositions);
        
        goodLengthIndexes = (lowLength <= dlugoscipochodow) & (upLength  >= dlugoscipochodow);
        positionsAtBeginnings= (SplitPositions(goodLengthIndexes));
        
        positionsAtEnds= SplitPositions(goodLengthIndexes) + dlugoscipochodow(goodLengthIndexes);
        indxesOfR = (1:size(positionsAtBeginnings,1))';
        indxesOfR = indxesOfR(RSamp <= (analysedSignal(positionsAtBeginnings)- analysedSignal(positionsAtEnds)));
        piki=positionsAtBeginnings(indxesOfR);
        Rposition = analysedSignal(piki+1,1);
        if(liczQS >= 1) 
            pikiS = positionsAtEnds(indxesOfR)-1;
            Sposition = analysedSignal(pikiS+1,1);
             if isempty(SplitPositionsQ)~=1                                           % jesli w ogole w sygnale byly spadki ,to...

                dlugoscipochodowQ = diff(SplitPositionsQ);
                [~,positionsAtR] = intersect(SplitPositionsQ,piki+2);
                positionsAtQ = positionsAtR-1;
                positionsAtQ(positionsAtQ<1) = 1;
                dlugoscipochodowQ = dlugoscipochodowQ(positionsAtQ);
                pikiQ = piki-dlugoscipochodowQ;
                pikiQ(pikiQ<1) = 1;
                Qposition = analysedSignal(pikiQ,1);

            end   
        end 
        if(liczQS == 2) 
          
             if isempty(SplitPositionsQ)~=1                                           % jesli w ogole w sygnale byly spadki ,to...
                lengthQ = piki-pikiQ;
                ampQ = Rposition - Qposition;
                
%                 piki((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
%                 pikiQ((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
%                 pikiS((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
%                 Rposition((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
%                 Sposition((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
%                 Qposition((ampQ < 0.25 * RSamp) | (lengthQ < (lowLength/2)))=[];
            end   
        end          
    end   

    if(isempty(piki))
        Rvalues = [];
    else
   	    Rvalues(:,1) = piki;
    end% wypisz znalezione poczatki spadkow na wyjscie.
    if(isempty(Rposition))
        Rvalues = [];
    else
        Rvalues(:,2) = Rposition;
    end
    if(isempty(pikiS))
        Svalues = [];
    else    
        Svalues(:,1) = pikiS;
    end
    if(isempty(Sposition))
        Sposition = [];
    else
        Svalues(:,2) = Sposition;
    end
     if(isempty(pikiQ))
        Qvalues = [];
    else
        Qvalues(:,1) = pikiQ;
    end
     if(isempty(pikiQ))
        Qvalues = [];
    else
      %  Qvalues(:,2) = analysedSignal(pikiQ(:,1)+1,1);
        Qvalues(:,2)=Qposition;
    end
    
    
end