% This script will generate the features set that will be used for
% training the neural network
%
% This script was only tested in MATLAB and requres the NN toobox
%
%
% Written by  Haidar Almubarak April 06, 2015
%             h.almubarak@ieee.org

clear all;close all;clc
data_dir=[pwd filesep 'training' filesep];

%Add the function on this directory to the MATLAB path
%This is not permanent. This change is only valid for this session of
%MATLAB (will reset once MATLAB is restarted).
addpath(pwd)

if(exist('OCTAVE_VERSION'))
    more off %this seems necessary in order to get back the screen in Octave, but we have not tested this script on Octave yet.
end


% extract signal features 
fprintf('Generating features set, please wait...\n')
fid=fopen([data_dir 'ALARMS'],'r');
if(fid ~= -1)
    RECLIST=textscan(fid,'%s %s %d','Delimiter',',');
    fclose(fid);
else
    error('Could not open ALARMS.txt for scoring. Exiting...')
end

RECORDS=RECLIST{1};
ALARMS=RECLIST{2};
N=length(RECORDS);

% Read the true alarms
fid=fopen(['ALARMS'],'r');
if(fid ~= -1)
    GOLD=textscan(fid,'%s %s %d','Delimiter',',');
    fclose(fid);
else
    error('Could not open challenge/ALARMS for scoring. Exiting...')
end

% create features matrix for each type
Asystole_features = [];
Bradycardia_features = [];
Tachycardia_features= [];
Ventricular_Tachycardia_features = [];
Ventricular_Flutter_Fib_features = [];
total_time=0;
for i=1:N
    % get record name
    fname=RECORDS{i};
    % get the ture value from GOLD
    rec_ind=strmatch(fname,GOLD{1});
    if(isempty(rec_ind))
        warning(['Could not find answer for record: ' RECORDS{i} , ' setting it to a false alarm.'])
        this_answer=0;
    else
        this_answer=GOLD{3}(rec_ind);
    end
    
    tic;
    display(['Features(' num2str(i) ')=GetFeatures(''' data_dir fname ');'])
    try
        % call the function getFeatures to get the signal features
        feat = getFeatures([data_dir fname]);
        % add the true alarm  for the signal 
        feat = [feat,this_answer];
        % save the feature into the corresponding matraix of abnormality 
        switch ALARMS{i}
            case 'Asystole'
                Asystole_features = [Asystole_features;feat];
            case 'Bradycardia'
                Bradycardia_features = [Bradycardia_features;feat];
            case 'Tachycardia'
                Tachycardia_features = [Tachycardia_features;feat];
            case 'Ventricular_Tachycardia'
                Ventricular_Tachycardia_features = [Ventricular_Tachycardia_features;feat];
            case 'Ventricular_Flutter_Fib'
                Ventricular_Flutter_Fib_features = [Ventricular_Flutter_Fib_features;feat];
            otherwise
                error(['Unknown alarm type: ' ALARMS{i}])
        end

    catch
        warning(lasterr)
    end
    total_time=total_time+toc;
    if(~mod(i,10))
        fprintf(['---Processed ' num2str(i) ' out of ' num2str(N) ' records.\n'])
    end
end

averageTime = total_time/N;
fprintf(['Generation of features completed !! Total time= ' ...
    num2str(total_time) ' average time= ' num2str(averageTime) '\n'])

save('all_features.mat','Ventricular_Tachycardia_features', 'Ventricular_Flutter_Fib_features', 'Tachycardia_features', 'Bradycardia_features', 'Asystole_features');
fprintf(['Features file created at : ' pwd 'all_features.mat. Processing completed!!\n'])


