function result = testVentTachycardia( chanResults,signals,invalids, description )

result = false;

datasize = 3500;

resultArray = zeros(size(chanResults,2),datasize);

finalResult = zeros(datasize+500,1);

titAdd = ' (regular process)';

% prohledme kanly, zda nhodou njak z nich nen peci jen zdrav. V tom
% ppad se to cel zru. Volan funkce je mrnj varianta
% isRegularActivity

% totalLF = 0;

for c=1:size(chanResults,2) 
    if ventIsRegularActivity(chanResults(c).rr,invalids(:,c),description(c),chanResults(c).lfMaxLength)
        result = true;
        finalResult = ones(datasize+500,1).*(-1)+finalResult;
        %titAdd = strcat(' isReg acc:',description(c));
        titAdd = description(c);
    end
    

%        if (~isnan(chanResults(c).lfMaxLength))
%          totalLF = totalLF+chanResults(c).lfMaxLength;
%        end

end

%kontroln souet MAXLF. Toto je hodn hooopy. Bastl jako hrom.
% LFlimit = 16;
% if totalLF>LFlimit
%     finalResult = ones(2500,1);
%     titAdd = ' (LF limit accelerator)';
%     result = true;
% end


if (result==false) %provdm to pouze tehdy, pokud nen njak kanl zdrav
%smyka prhledvacho okna s dlkou asystSamples

minQRScount=4; %potebuji nejmn 4 QRS koplexy skupiny 2
limitBPM=95;

for c=1:size(chanResults,2) %Iteruji pes vechny kanly
    
  
    
    if c<=2 %Pouze pro ECG kanly
    for q=1:length(chanResults(c).qrs)-minQRScount %iteruji pes vechny QRS danho kanlu. 
        if (chanResults(c).group(q)==0) %nejedn se o QRS skupiny 2
            continue
        end
        
        groupQRSpos = chanResults(c).qrs(q:q+(minQRScount-1));
        
        
        sz = 25;
        lt = chanResults(c).qrs(q)-sz;
        rt = chanResults(c).qrs(q)+sz;
        
        minCorr = 0.99;
        
        if (lt>0 && rt<datasize)
        
        QRSblock = signals(lt:rt,c);
        
        corrs = zeros(minQRScount,1);
        
        
        
         for r=q+1:q+minQRScount-1
              if r<size(chanResults(c).qrs,2)
                lt = chanResults(c).qrs(r)-sz;
                rt = chanResults(c).qrs(r)+sz;
                
                 if (lt>0 && rt<datasize)
                   corrBlock = signals(lt:rt,c);
                   corrs(r-q) = corr(QRSblock,corrBlock);
                 end
              end
             
         end
        end
        
        %test, zda ti nsledujc QRS jsou taky ze skupiny 2 anebo pokud
        %to patn koreluje s nsledujcmi QRS
     %   if min(corrs)<minCorr
         if min(chanResults(c).group(q:q+(minQRScount-1)))==0
            continue   %pokud ne, jdu na dal QRS
         end
      %  end
        
        rrG2 = diff(groupQRSpos)/250;
        
        bpm = getBPM(rrG2);

        winStart = groupQRSpos(1);
        winEnd = groupQRSpos(minQRScount);
        
        score = bpm>limitBPM;
        
        cinv = sum(invalids(winStart:winEnd,c))/(winEnd-winStart);
        if (cinv>1) 
              cinv = 1;
        end
        score = score*(1-cinv);

        finalResult(winStart:winEnd) =finalResult(winStart:winEnd)+ score; %finalResult(winStart:winEnd)+
        
    end
    else %pro ne ECG kanly
        if isBPChannel(description(c))
            
        winSize = 3; 
        winSamples = winSize*249; 
        winStep = 250; 
        
        vtTrueRatio = 0.7;
        
        maxVR = 50;
        
        allVarRange = max(signals(:,c))-min(signals(:,c));
        
        
        meanBP = zeros(datasize+500,1);
        stdBP = zeros(datasize+500,1);
        
        stdLimit = 25;
        avgMin = 60;
        
        statStep = 250;
        statSamples = 250;
        
        for pos = 1:statStep:datasize-statSamples
            winStart = pos;
            winEnd = pos+statSamples;
            stdBP(pos:pos+statSamples)=std(signals(winStart:winEnd,c));
            meanBP(pos:pos+statSamples)=mean(signals(winStart:winEnd,c));
        end
        
        if doPictures
            xv = 1:datasize+500;
            plot(xv,stdBP,'r',xv,0.05.*meanBP, 'c');
            
        end
        
        for pos = 1:winStep:datasize-winSamples
            
            winStart = pos;
            winEnd = pos+winSamples;
            
            block = signals(winStart:winEnd,c);
            
            blockVarRange = max(block)-min(block);
            
            score = blockVarRange<(vtTrueRatio*allVarRange) && (blockVarRange<maxVR);
            
            if (std(block)>stdLimit)
                score = -10;
            end
            
            if (score~=0)
               titAdd =' (BP influence)';
            end
        
            cinv = sum(invalids(winStart:winEnd,c))/(winEnd-winStart);
            if (cinv>1) 
              cinv = 1;
            end
            score = score*(1-cinv);
            
            finalResult(winStart:winEnd) = finalResult(winStart:winEnd)+score;
            
        end
            
            
        end
        
    end
end


end





result = max(finalResult)>0;

if doPictures

    plot(finalResult);
    
    str = ' False alarm';
    bckColor = [0.8 0.8 0.9];

    if (result)
        str =' True alarm';
         bckColor = [0.9 0.8 0.8];
    end
    area(finalResult,'FaceColor',bckColor,'edgecolor',bckColor);
    title(['Ventricular tachycardia test : ',str,titAdd]);
end
% 
% str = ' False alarm';
% 
% bckColor = [0.8 0.8 0.9];
% 
% if (result)
%     str =' True alarm';
%      bckColor = [0.9 0.8 0.8];
% end



% area(finalResult,'FaceColor',bckColor,'edgecolor',bckColor);
% title(['Ventricular tachycardia test : ',str,titAdd]);


end

function result = ventIsRegularActivity(RRs, invalid, desc, maxLF)

result = false;

if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35; %nejmen BPM, kter je povaovan za vyhovujc
bpmHighLimit = 95; %nejvy BPM, povaovan za vyhovujc. 

sumLimit=11; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.1; %kolik mus bt maximln stdev

LFok = true; %Kontrola na dlku LF oblasti. Uplanuje se jen pi testovn ECG kanl
if (isECGChannel(desc))
    LFok = maxLF<2*mean(RRs);
end

result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit) && (sum(invalid)==0 && LFok);

if timeSum>12 && length(RRs)>10 && stdev<0.03 %psnj kombinace
    result = true;
end

% if timeSum>12 && length(RRs)>10 && bpm>140 && stdev<0.2 %takhle rychl u stejn VT asi bt neme
%     result = true;
% end


end
end
