function result = testVentTachycardia( chanResults,signals,invalids, description )

result = false;

resultArray = zeros(size(chanResults,2),2500);

finalResult = zeros(2500,1);

titAdd = ' (regular process)';

% prohledme kanly, zda nhodou njak z nich nen peci jen zdrav. V tom
% ppad se to cel zru. Volan funkce je mrnj varianta
% isRegularActivity

% totalLF = 0;

for c=1:size(chanResults,2) 
    if ventIsRegularActivity(chanResults(c).rr,invalids(:,c),description(c),chanResults(c).lfMaxLength)
        result = true;
        finalResult = ones(2500,1).*(-1)+finalResult;
        titAdd = ' (isReg accelerator)';
    end
    

%        if (~isnan(chanResults(c).lfMaxLength))
%          totalLF = totalLF+chanResults(c).lfMaxLength;
%        end

end

%kontroln souet MAXLF. Toto je hodn hooopy. Bastl jako hrom.
% LFlimit = 16;
% if totalLF>LFlimit
%     finalResult = ones(2500,1);
%     titAdd = ' (LF limit accelerator)';
%     result = true;
% end


if (result==false) %provdm to pouze tehdy, pokud nen njak kanl zdrav
%smyka prhledvacho okna s dlkou asystSamples

minQRScount=4; %potebuji nejmn 4 QRS koplexy skupiny 2
limitBPM=95;

for c=1:size(chanResults,2) %Iteruji pes vechny kanly
    
    if c<=2 %Pouze pro ECG kanly
    for q=1:length(chanResults(c).qrs)-minQRScount %iteruji pes vechny QRS danho kanlu. 
        if (chanResults(c).group(q)==0) %nejedn se o QRS skupiny 2
            continue
        end
        
        groupQRSpos = chanResults(c).qrs(q:q+(minQRScount-1));
        
        %test, zda ti nsledujc QRS jsou taky ze skupiny 2
        if min(chanResults(c).group(q:q+(minQRScount-1)))==0
            continue   %pokud ne, jdu na dal QRS
        end
        
        rrG2 = diff(groupQRSpos)/250;
        
        bpm = getBPM(rrG2);

        winStart = groupQRSpos(1);
        winEnd = groupQRSpos(minQRScount);
        
        
        
        score = bpm>limitBPM;
        
        cinv = sum(invalids(winStart:winEnd,c))/(winEnd-winStart);
        if (cinv>1) 
              cinv = 1;
        end
        score = score*(1-cinv);

        finalResult(winStart:winEnd) =finalResult(winStart:winEnd)+ score; %finalResult(winStart:winEnd)+
        
    end
    else %pro ne ECG kanly
        if isBPChannel(description(c))
            
        winSize = 3; 
        winSamples = winSize*250; 
        winStep = 50; 
        
        vtTrueRatio = 0.7;
        
        maxVR = 50;
        
        allVarRange = max(signals(:,c))-min(signals(:,c));
        
        for pos = 1:winStep:2500-winSamples
            
            winStart = pos;
            winEnd = pos+winSamples;
            
            block = signals(winStart:winEnd,c);
            
            blockVarRange = max(block)-min(block);
            
            score = blockVarRange<(vtTrueRatio*allVarRange) && (blockVarRange<maxVR);
            
%             if (score==0)
%                 score = -1; %Zbabl een, aby to dlalo m false
%                 negativ
%             end
           
        
            cinv = sum(invalids(winStart:winEnd,c))/(winEnd-winStart);
            if (cinv>1) 
              cinv = 1;
            end
            score = score*(1-cinv);
            
            finalResult(winStart:winEnd) = finalResult(winStart:winEnd)+score;
            
        end
            
            
        end
        
    end
end


end




result = max(finalResult)>0;

if doPictures

    str = ' False alarm';
    bckColor = [0.8 0.8 0.9];

    if (result)
        str =' True alarm';
         bckColor = [0.9 0.8 0.8];
    end
    area(finalResult,'FaceColor',bckColor,'edgecolor',bckColor);
    title(['Ventricular tachycardia test : ',str,titAdd]);
end

end

function result = ventIsRegularActivity(RRs, invalid, desc, maxLF)

result = false;

if (length(RRs)>2)

bpm = getBPM(RRs);

stdev = std(RRs);

timeSum = sum(RRs);


bpmLowLimit = 35; %nejmen BPM, kter je povaovan za vyhovujc
bpmHighLimit = 95; %nejvy BPM, povaovan za vyhovujc. 

sumLimit=7; % kolik asu mus bt pokryto QRS znakami

stdevLimit = 0.1; %kolik mus bt maximln stdev

LFok = true; %Kontrola na dlku LF oblasti. Uplanuje se jen pi testovn ECG kanl
if (isECGChannel(desc))
    LFok = maxLF<2*mean(RRs);
end

result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && (stdev<stdevLimit) && (sum(invalid)==0 && LFok);

if timeSum>8 && length(RRs)>9 && stdev<0.01
    result = true;
end

end

end

