function result = testAsystole( chanResults,signals,invalids )
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

result = false;

dataSize = 3500;


asystLimit = 3.2; %kolik sekund mus bt prostor, aby byla asystola. Pvodn je 4 sec, ale to maj blb nap pro a442s

asystSamples = floor(asystLimit*250);

resultArray = zeros(size(chanResults,2),dataSize);

finalResult = zeros(dataSize,1);

titAdd = '';

%zkrcen een pro ppady, kdy je to jednoznan ok
accelerated = false;
for c=1:size(chanResults,2) 
    if asystIsRegularActivity(chanResults(c).rr,invalids(:,c))
        accelerated = true;
        result = false;
        finalResult = ones(dataSize,1).*(-1)+finalResult;
        titAdd = ' (RR accelerator)';
    end
end

%smyka prhledvacho okna s dlkou asystSamples
if not(accelerated)
for pos=1:dataSize-asystSamples
    
    winStart=pos;
    winEnd = pos+asystSamples;
    
    %smyka, kter prohled vechny kanly v danm okn a spot vechny
    %QRS
    
    for c=1:size(chanResults,2)
        
        if (length(chanResults(c).qrs)>0)
        
        isolatedQRS = (chanResults(c).qrs>winStart).*chanResults(c).qrs;
        isolatedQRS = (isolatedQRS<winEnd).*isolatedQRS;
        separatedQRS = nonzeros(isolatedQRS);
        QRScount = length(separatedQRS);
        
        else
        QRScount = 0;
        end
        
        score = 1; % -1= false
        
        if QRScount>0
            score = -1;
        end
        
        %vynsobm vrohodnost kanlu, co je Cinvalid
        
        cinv = sum(invalids(winStart:winEnd,c))/asystSamples;
        
        if (cinv>1) 
            cinv = 1;
        end
        
        score = score*(1-cinv);
        
        resultArray(c,pos)=score;
        
        finalResult(pos) = finalResult(pos)+score;
        
    end 
    
    
    
    
end
end

% x = 1:2500;



result = max(finalResult)>0;

if doPictures

    str = ' False alarm';
    bckColor = [0.8 0.8 0.9];

    if (result)
        str =' True alarm';
        bckColor = [0.9 0.8 0.8];
    end

    area(finalResult,'FaceColor',bckColor,'edgecolor',bckColor);
    title(['Asystole test : ',str,titAdd]);

    
end
end

function result = asystIsRegularActivity(RRs, invalid)

result = false;

rrc = length(RRs);

if (rrc>5) %4 pro 2500

bpm = getBPM(RRs);

stdev = std(RRs);

minRRs = 11; %10 pro 2500
minMed = 0.6;

med = median(RRs);

timeSum = sum(RRs);


bpmLowLimit = 45; %nejmen BPM, kter je povaovan za normln
bpmHighLimit = 250; %nejvy BPM, povaovan za normln. Tady je extremne vysoke, ale uleh to ivot

sumLimit=11.5; % kolik asu mus bt pokryto QRS znakami

maxlimit = 3; %nejvt povolen dra = RR

stdevLimit = 0.2; %kolik me bt maximln stdev


result = (bpm>bpmLowLimit) && (bpm<bpmHighLimit) && (timeSum>sumLimit) && ((stdev<stdevLimit)|| (med>minMed && rrc>minRRs))  && (sum(invalid)==0) && max(RRs)<maxlimit;

end

end
