function corrMatrix = getQRSCorrMatrix( signal, acceptedX, corrRadius)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here


numQRS = length(acceptedX);

corrMatrix = zeros(numQRS, numQRS);
% corrRadius = 20;

for row = 1:numQRS
    
    posL = acceptedX(row)-corrRadius;
    posR = posL+2*corrRadius;
    
    if (posL<1) 
        continue;
    end
    
    if (posR>length(signal))
        continue;
    end
    
    protoBlock = signal(posL:posR);
    
    for col = 1:numQRS
        
        if col==row
            corrMatrix(col,row) = 0;
            continue;
        end
        
    posL = acceptedX(col)-corrRadius;
    posR = posL+2*corrRadius;
    
    if (posL<1) 
        continue;
    end
    
    if (posR>length(signal))
        continue;
    end
        
        testBlock = signal(posL:posR);
        
        c = corrcoef(testBlock, protoBlock);
        c = c(1,2);
        
        corrMatrix(col, row) = c;
    end
end

end

