function chanResult = getECGresults_208(signal, invalid, alarm_type)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

dataSize = size(signal,1)-1;

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;

fs = 250;

if strcmp(alarm_type,'Ventricular_Tachycardia')
dataLF = hobalka(signal.*(1-invalid),250,1,8).*(1-invalid);
dataMF = hobalka(signal.*(1-invalid),250,5,25).*(1-invalid);
dataHF = 0.05.*hobalka(signal.*(1-invalid),250,50,70).*(1-invalid);
else
dataLF = hobalka(signal.*(1-invalid),250,1,10).*(1-invalid);
dataMF = hobalka(signal.*(1-invalid),250,5,25).*(1-invalid);
dataHF = hobalka(signal.*(1-invalid),250,50,70).*(1-invalid);
end



if strcmp(alarm_type,'Ventricular_Tachycardia')
minPeakDistance = 0.11* 250;

statRawSamples = 0.12 * 250;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.375 * 250; % //--dlouhodob oblast 0.5

statRawKVR = 0.3 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti
kHFminRation = 0.3;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka

rMin = 0.015; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF

dataR = max(dataMF-dataHF,0);

else
minPeakDistance = 0.11 * 250;

statRawSamples = 0.12 * 250;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.5 * 250; % //--dlouhodob oblast 0.5*250

statRawKVR = 0.5 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti 0.5
kHFminRation = 1;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka

rMin = 0.03; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF 0.03

dataR = max(dataMF-dataHF,0);
end







if doPictures 
 area(invalid*max(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 area(invalid*min(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 p=plot(signal);
set(p,'Color',[0.44 0.62 0.81])
 plot(dataLF,'r:');
 %plot(dataHF,'b-');
 plot(dataR,'k-');
end



[peaks,locs] = findpeaks(dataR);



% vyberu jen ty sprvn peaky
lastAcceptedPos = -minPeakDistance;

acceptedX = [];
acceptedY = [];

acceptedNum=1;

if strcmp(alarm_type,'Ventricular_Tachycardia')
statPerc95 = prctile(dataR.*(1-invalid),80);
else    
statPerc95 = prctile(dataR.*(1-invalid),85);
end

for i=1:size(locs,1)
    
    accept = true;
    
    testedPos = locs(i); %index prv testovan pozice
    
    if invalid(testedPos)==1 continue % pokud extrem le v invalid oblasti, tak ho neem //oprava!!!!!
    end
    
    if (testedPos<3) || (testedPos>length(signal)-3)  %ignoruji peaky, kter by byly pmo na kraji. To smrd.
        continue
    end
    
    
    
    statRawStart = max(locs(i)-floor(statRawSamples/2),1);
    statRawEnd = min (locs(i)+floor(statRawSamples/2),size(signal,1));
    
    statRawLongStart = max(locs(i)- floor(statRawLongSamples/2),1);
    statRawLongEnd = min (locs(i)+ floor(statRawLongSamples/2),size(signal,1));
    
    statRawBlockShort = dataR(statRawStart:statRawEnd);
    statRawBlockLong = dataR(statRawLongStart:statRawLongEnd);
    
    shortBlockVR =  max(statRawBlockShort)-min(statRawBlockShort);
    longBlockVR = max(statRawBlockLong)-min(statRawBlockLong);
    
    accept = accept && (testedPos>lastAcceptedPos+minPeakDistance); %oeten proti pli blkm peakm
    accept = accept && (dataR(testedPos)>= kHFminRation * dataHF(testedPos)); %oeten proti rychlm kmitm
    accept = accept && (dataR(testedPos)>=rMin); %oeten proti pli slabm peakm
    accept =accept && (dataR(testedPos) > statPerc95); %kontrola na velikost v rmci statistiky vyetovanch 10 sekund
    
    accept = accept && (shortBlockVR>longBlockVR*statRawKVR);
    
    accept = accept && (max(statRawBlockShort) == max (statRawBlockLong));
     
    %kontrola, e to nesoused s nevalidn oblast
    accept = accept && (dataR(testedPos+2)>0) && (dataR(testedPos-2)>0);
    
    if (accept)
        
        acceptedX(acceptedNum) = testedPos;
        acceptedY(acceptedNum) = peaks(i);

        %toto se bude muset jet pozdji opravit
        chanResult.group(acceptedNum) = dataLF(testedPos)>dataR(testedPos);
        
        lastAcceptedPos = testedPos;
        
        acceptedNum = acceptedNum+1;
        
    end
end






%odstrann ppadnch T vln. lo by to pes find==0

numGroup2=find(chanResult.group==1);

if (acceptedNum>10 && size(numGroup2,2)>5)
numRT = 1;

for i=2:acceptedNum-1 

    if chanResult.group(i)==0 || chanResult.group(i-1)==1
        continue;
    end
    %sem projdou jen kombinace 0-1
    rtDists(numRT) = (acceptedX(i)-acceptedX(i-1))/fs;
    numsToRemove(numRT) = i;
    numRT = numRT+1;
end

% exist('testresults','var')
if exist ('rtDists','var') && size(rtDists,2)>5

meanRT = mean(rtDists);
stDevRT = std(rtDists);

minRT = min(rtDists);
maxRT = max(rtDists);

limitSTD = 0.03;

if meanRT<0.55 && meanRT>0.25 && minRT>0.15 && maxRT<0.6 && stDevRT<limitSTD
    
   if doPictures 
%  pozice_dels = find(chanResult.group==1);
 plot(acceptedX(numsToRemove),acceptedY(numsToRemove),'ko', 'MarkerFaceColor',[1 0.3 0.3],'MarkerSize',8);
   end
    acceptedX(numsToRemove)=[];
    acceptedY(numsToRemove)=[];
    chanResult.group(numsToRemove)=[];
end

end
end


% corr matrix
% 
numQRS = length(acceptedX);

corrMatrix = getQRSCorrMatrix_208(signal, acceptedX,20);

% 
% corrMatrix = zeros(numQRS, numQRS);
% corrRadius = 20;
% 
% for row = 1:numQRS
%     
%     posL = acceptedX(row)-corrRadius;
%     posR = posL+2*corrRadius;
%     
%     if (posL<1) 
%         continue;
%     end
%     
%     if (posR>length(signal))
%         continue;
%     end
%     
%     protoBlock = signal(posL:posR);
%     
%     for col = 1:numQRS
%         
%         if col==row
%             corrMatrix(col,row) = 0;
%             continue;
%         end
%         
%     posL = acceptedX(col)-corrRadius;
%     posR = posL+2*corrRadius;
%     
%     if (posL<1) 
%         continue;
%     end
%     
%     if (posR>length(signal))
%         continue;
%     end
%         
%         testBlock = signal(posL:posR);
%         
%         corrMatrix(col, row) = corr(testBlock, protoBlock);
%     end
% end



if doPictures

corrAVG = zeros(numQRS,1);
corrMAX = zeros(numQRS,1);
corrMED =  zeros(numQRS,1);

numc9vals = zeros(numQRS,1);

for row = 1:numQRS
    
    corrAVG(row) = mean(corrMatrix(row,:));
    corrMAX(row) = max((corrMatrix(row,:)));
    corrMED(row) = median((corrMatrix(row,:)));
    
    numc9 = 0;
    
    for col = 1:numQRS
        if corrMatrix(row, col)>0.9
            numc9 = numc9+1;
        end
    end
    
    numc9vals(row) = numc9;
    
end

corrMeanG0 = mean(corrMatrix(corrMatrix~=0));
corrP10 = prctile(corrMatrix(corrMatrix~=0),10);
corrMed = prctile(corrMatrix(corrMatrix~=0),50);
corrSTD = std(corrMatrix(corrMatrix~=0));
corrMIN0 = min(corrMatrix(corrMatrix~=0));


 pozice_red = find(chanResult.group==1);
 pozice_grn = find(chanResult.group==0);
 
 ms = min(signal)*0.8;
 
 for row =1:numQRS
     if (corrMAX(row)<0.70)
     plot(acceptedX(row),acceptedY(row),'o','Markersize',15, 'MarkerFaceColor',[0 0 0]);   
     text(acceptedX(row),ms,num2str(corrMAX(row)));
     end
     
     if (corrMAX(row)<0.70)
     %plot(acceptedX(row),acceptedY(row),'o','Markersize',15, 'MarkerFaceColor',[0 0 0]);    
     end
 end
 
 lf=50;
 my = max(signal)*1.2;
 str = strcat('QRS C.mat: P10:',num2str(corrP10),' | AVG:',num2str(corrMeanG0),'',num2str(corrSTD),' | MED:',num2str(corrMed),' | MIN:',num2str(corrMIN0));
 text(50,my,str);

 ymax = max(signal);
 vry = max(signal)-min(signal);
 
 vs = vry/numQRS;
 xs = 15;
 
 for col=1:numQRS
     for row =1:numQRS
        
        corr = corrMatrix(col,row);
        
        bckColor = [0.0 0.0 0.0];
        
        if corr>0
             bckColor = [0.0 corr 0.0];
        end
        
        if corr<0
             bckColor = [-corr 0.0 0];
        end
        
        x = col*xs-450;
        y = ymax-row*vs;
        
        rectangle ('Position', [x,y,xs,vs],'FaceColor',bckColor,'EdgeColor','None');
     end   
 end
 %annotation('textbox', [0.1,0.1,0.2,0.2],'BackgroundColor',bckColor,'EdgeColor',bckColor);

 
 plot(acceptedX(pozice_red),acceptedY(pozice_red),'kv', 'MarkerFaceColor',[1 0 0],'MarkerSize',10);
 plot(acceptedX(pozice_grn),acceptedY(pozice_grn),'kv', 'MarkerFaceColor',[0 0.8 0],'MarkerSize',10);
 
 
 
 line([1 dataSize], [statPerc95 statPerc95]);
end

chanResult.qrs = acceptedX;
chanResult.rr = diff(chanResult.qrs)/250;



% nalezen nejdelho LF bloku
lfStart=1;
lfEnd=1;
maxLFlength=0;
maxLFstart=0;
maxLFend = 0;

for i=1:length(dataLF)
    if ((dataLF(i)<dataR(i)) || (invalid(i)==1))
        
        lfEnd = i;
        
        lfLength = lfEnd-lfStart;
        
        if (lfLength>maxLFlength)
            maxLFstart = lfStart;
            maxLFend = lfEnd;
            maxLFlength = lfLength;
        end
        
        lfStart=i;
        continue
    end
    lfEnd = i;
end

if ((dataLF(end)>dataR(end)) || (lfEnd>0))
      lfLength = lfEnd-lfStart;
        if (lfLength>maxLFlength)
        maxLFstart = lfStart;
        maxLFend = lfEnd;
        maxLFlength = lfLength;
        end
end

maxLFlength = maxLFlength/250;

chanResult.lfMaxLength=maxLFlength;

% oprava patnch skupin

% smoothedSignal = smooth(signal, 5);
if strcmp(alarm_type,'Ventricular_Tachycardia')
% f = 12; %z 20
% [b,a] = butter(3, 2*f/fs, 'low'); 
% smoothedSignal = filtfilt(b,a,signal); 

offset = 15;

my = min(signal)*1.5;
mx = max(signal);

% corrs = zeros(length(chanResult.qrs));

 corrThreshold = 0.70;

%  corrThresholdNeg = 0.99;
 
for q=1:length(chanResult.qrs)-1
 
    winStart = chanResult.qrs(q)+offset;
    winEnd = chanResult.qrs(q+1)-offset;
    
    rrSamples = winEnd-winStart;
    
    dataBlock = signal(winStart:winEnd);
    
    
    sinusWindowPos = sinHill(rrSamples+1);
%     sinusWindowNeg = -sinusWindowPos;
    
    correlPos = corrcoef(dataBlock,sinusWindowPos);
    corrsPos = correlPos(2,1);
   
%     correlNeg = corrcoef(dataBlock,sinusWindowNeg);
%     corrsNeg = correlNeg(2,1);
    
    
    change = -1;
    
    if corrsPos>corrThreshold % || corrsNeg>corrThresholdNeg
    
    change = 0;
    chanResult.group(q+1) = 1;
    mcolor = [1 0.5 0];
    end
    
    
    
%         if  length(pks)<1 && chanResult.group(q)==0
%         chanResult.group(q) = 1;
%         change = 1;
%         mcolor = [1 0.5 0];
%         end
    
    if (doPictures && change>=0)
         
        x = chanResult.qrs(q+1);
        y =signal(x);
%         text(x,y,num2str(corrs));
        plot(x,y,'o', 'MarkerFaceColor',mcolor,'MarkerSize',8);
        
    end
    
end
end



if doPictures
if (maxLFlength>0)
 colorRed = [0.75 0.0 0.0];
 rectangle('position',[maxLFstart -0.05 (maxLFend-maxLFstart) 0.03],'edgecolor',colorRed,'LineWidth',1,'FaceColor',colorRed);
end

 %vpis text
 lf=dataSize-10;
 my = max(signal)*0.3;
 %test zdravho signlu
 strAct = 'Suspicious activity';
 clr = [0.8 0.8 0.8];
 if (isRegularActivity(chanResult.rr, invalid, alarm_type))
     strAct = 'PERFECT activity';
     clr = [0.6 0.9 0]
 end
 cinv = sum(invalid)/dataSize; %koeficient invalidity - 0=zdrav signl, 1=zcela nepouiteln signl.
 strInfo = ['N QRS= ',num2str(length(chanResult.qrs)),10,'RR mean= ',num2str(mean(chanResult.rr)),10,'RR median= ',num2str(median(chanResult.rr)),10,'RR std= ',num2str(std(chanResult.rr)),10,'MAX LF length= ',num2str(chanResult.lfMaxLength),10,'C_I_N_V_A_L_I_D = ',num2str(cinv),10,10,strAct,10,'BPM_A_V_G = ',num2str(getBPM(chanResult.rr))];
 text(lf,my,strInfo,'BackgroundColor',clr);
end


end

