function chanResult = getECGresults(signal, invalid, alarm_type)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

dataSize = 3500;

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;

fs = 250;

if strcmp(alarm_type,'Ventricular_Tachycardia')
dataLF = hobalka(signal.*(1-invalid),250,1,8).*(1-invalid);
dataMF = hobalka(signal.*(1-invalid),250,5,25).*(1-invalid);
dataHF = 0.05.*hobalka(signal.*(1-invalid),250,50,70).*(1-invalid);
else
dataLF = hobalka(signal.*(1-invalid),250,1,10).*(1-invalid);
dataMF = hobalka(signal.*(1-invalid),250,5,25).*(1-invalid);
dataHF = hobalka(signal.*(1-invalid),250,50,70).*(1-invalid);
end



if strcmp(alarm_type,'Ventricular_Tachycardia')
minPeakDistance = 0.11* 250;

statRawSamples = 0.12 * 250;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.375 * 250; % //--dlouhodob oblast 0.5

statRawKVR = 0.3 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti
kHFminRation = 0.3;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka

rMin = 0.015; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF

dataR = max(1.*dataMF-dataHF,0);

else
minPeakDistance = 0.11 * 250;

statRawSamples = 0.12 * 250;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.5 * 250; % //--dlouhodob oblast

statRawKVR = 0.5 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti
kHFminRation = 1;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka

rMin = 0.03; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF

dataR = max(dataMF-dataHF,0);
end







if doPictures 
 area(invalid*max(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 area(invalid*min(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 p=plot(signal);
set(p,'Color',[0.44 0.62 0.81])
 plot(dataLF,'r:');
 %plot(dataHF,'b-');
 plot(dataR,'k-');
end



[peaks,locs] = findpeaks(dataR);



% vyberu jen ty sprvn peaky
lastAcceptedPos = -minPeakDistance;

acceptedX = [];
acceptedY = [];

acceptedNum=1;

if strcmp(alarm_type,'Ventricular_Tachycardia')
statPerc95 = prctile(dataR.*(1-invalid),80);
else    
statPerc95 = prctile(dataR.*(1-invalid),85);
end

for i=1:size(locs,1)
    
    accept = true;
    
    testedPos = locs(i); %index prv testovan pozice
    
    if invalid(testedPos)==1 continue % pokud extrem le v invalid oblasti, tak ho neem //oprava!!!!!
    end
    
    if (testedPos<3) || (testedPos>length(signal)-3)  %ignoruji peaky, kter by byly pmo na kraji. To smrd.
        continue
    end
    
    
    
    statRawStart = max(locs(i)-floor(statRawSamples/2),1);
    statRawEnd = min (locs(i)+floor(statRawSamples/2),size(signal,1));
    
    statRawLongStart = max(locs(i)- floor(statRawLongSamples/2),1);
    statRawLongEnd = min (locs(i)+ floor(statRawLongSamples/2),size(signal,1));
    
    statRawBlockShort = dataR(statRawStart:statRawEnd);
    statRawBlockLong = dataR(statRawLongStart:statRawLongEnd);
    
    shortBlockVR =  max(statRawBlockShort)-min(statRawBlockShort);
    longBlockVR = max(statRawBlockLong)-min(statRawBlockLong);
    
    accept = accept && (testedPos>lastAcceptedPos+minPeakDistance); %oeten proti pli blkm peakm
    accept = accept && (dataR(testedPos)>= kHFminRation * dataHF(testedPos)); %oeten proti rychlm kmitm
    accept = accept && (dataR(testedPos)>=rMin); %oeten proti pli slabm peakm
    accept =accept && (dataR(testedPos) > statPerc95); %kontrola na velikost v rmci statistiky vyetovanch 10 sekund
    
    accept = accept && (shortBlockVR>longBlockVR*statRawKVR);
    
    accept = accept && (max(statRawBlockShort) == max (statRawBlockLong));
     
    %kontrola, e to nesoused s nevalidn oblast
    accept = accept && (dataR(testedPos+2)>0) && (dataR(testedPos-2)>0);
    
    if (accept)
        
        acceptedX(acceptedNum) = testedPos;
        acceptedY(acceptedNum) = peaks(i);

        %toto se bude muset jet pozdji opravit
        chanResult.group(acceptedNum) = dataLF(testedPos)>dataR(testedPos);
        
        lastAcceptedPos = testedPos;
        
        acceptedNum = acceptedNum+1;
        
    end
end






%odstrann ppadnch T vln. lo by to pes find==0

numGroup2=find(chanResult.group==1);

if (acceptedNum>10 && size(numGroup2,2)>5)
numRT = 1;

for i=2:acceptedNum-1 

    if chanResult.group(i)==0 || chanResult.group(i-1)==1
        continue;
    end
    %sem projdou jen kombinace 0-1
    rtDists(numRT) = (acceptedX(i)-acceptedX(i-1))/fs;
    numsToRemove(numRT) = i;
    numRT = numRT+1;
end

% exist('testresults','var')
if exist ('rtDists','var') && size(rtDists,2)>5

meanRT = mean(rtDists);
stDevRT = std(rtDists);

minRT = min(rtDists);
maxRT = max(rtDists);

limitSTD = 0.03;

if meanRT<0.55 && meanRT>0.25 && minRT>0.15 && maxRT<0.6 && stDevRT<limitSTD
    
   if doPictures 
%  pozice_dels = find(chanResult.group==1);
 plot(acceptedX(numsToRemove),acceptedY(numsToRemove),'ko', 'MarkerFaceColor',[1 0.3 0.3],'MarkerSize',8);
   end
    acceptedX(numsToRemove)=[];
    acceptedY(numsToRemove)=[];
    chanResult.group(numsToRemove)=[];
end

end
end

if doPictures 
 pozice_red = find(chanResult.group==1);
 pozice_grn = find(chanResult.group==0);
 plot(acceptedX(pozice_red),acceptedY(pozice_red),'kv', 'MarkerFaceColor',[1 0 0],'MarkerSize',10);
 plot(acceptedX(pozice_grn),acceptedY(pozice_grn),'kv', 'MarkerFaceColor',[0 0.8 0],'MarkerSize',10);
 line([1 dataSize], [statPerc95 statPerc95]);
end

chanResult.qrs = acceptedX;
chanResult.rr = diff(chanResult.qrs)/250;



% nalezen nejdelho LF bloku
lfStart=1;
lfEnd=1;
maxLFlength=0;
maxLFstart=0;
maxLFend = 0;

for i=1:length(dataLF)
    if ((dataLF(i)<dataR(i)) || (invalid(i)==1))
        
        lfEnd = i;
        
        lfLength = lfEnd-lfStart;
        
        if (lfLength>maxLFlength)
            maxLFstart = lfStart;
            maxLFend = lfEnd;
            maxLFlength = lfLength;
        end
        
        lfStart=i;
        continue
    end
    lfEnd = i;
end

if ((dataLF(end)>dataR(end)) || (lfEnd>0))
      lfLength = lfEnd-lfStart;
        if (lfLength>maxLFlength)
        maxLFstart = lfStart;
        maxLFend = lfEnd;
        maxLFlength = lfLength;
        end
end

maxLFlength = maxLFlength/250;

chanResult.lfMaxLength=maxLFlength;

if doPictures
if (maxLFlength>0)
 colorRed = [0.75 0.0 0.0]
 rectangle('position',[maxLFstart -0.05 (maxLFend-maxLFstart) 0.03],'edgecolor',colorRed,'LineWidth',1,'FaceColor',colorRed)
end
 %vpis text
 lf=4010;
 my = max(signal)*0.3;
 %test zdravho signlu
 strAct = 'Suspicious activity';
 clr = [0.8 0.8 0.8];
 if (isRegularActivity(chanResult.rr, invalid))
     strAct = 'PERFECT activity';
     clr = [0.6 0.9 0]
 end
 cinv = sum(invalid)/dataSize; %koeficient invalidity - 0=zdrav signl, 1=zcela nepouiteln signl.
 strInfo = ['N QRS= ',num2str(length(chanResult.qrs)),10,'RR mean= ',num2str(mean(chanResult.rr)),10,'RR median= ',num2str(median(chanResult.rr)),10,'RR std= ',num2str(std(chanResult.rr)),10,'MAX LF length= ',num2str(chanResult.lfMaxLength),10,'C_I_N_V_A_L_I_D = ',num2str(cinv),10,10,strAct,10,'BPM_A_V_G = ',num2str(getBPM(chanResult.rr))];
 text(lf,my,strInfo,'BackgroundColor',clr);
end


end

