function chanResult = getECGresults(signal, invalid)
%UNTITLED2 Summary of this function goes here
%   Detailed explanation goes here

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;


dataLF = hobalka(signal.*(1-invalid),250,1,10).*(1-invalid);
dataMF = hobalka(signal.*(1-invalid),250,5,25).*(1-invalid);
dataHF = hobalka(signal.*(1-invalid),250,50,70).*(1-invalid);

minPeakDistance = 0.11 * 250;
% p75samples = 0.5 * 250;

statRawSamples = 0.12 * 250;% //--velikost okna pro posuzovn statistiky surovch dat - krtkodob oblast
statRawLongSamples = 0.5 * 250; % //--dlouhodob oblast

statRawKVR = 0.5 ;% //-- nejmen pomr mezi VR krtk a dlouh oblasti
kHFminRation = 1;% //--kolikrt mus bt MF sloka u ECG vt ne HF sloka, aby byl peak pijat jako potenciln znaka


rMin = 0.03; %//--nejmen vka peaku, detekovanho na ECG oblce v rozdlu R=MF-LF


dataR = max(dataMF-dataHF,0);




if doPictures 
 area(invalid*max(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 area(invalid*min(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 p=plot(signal);
 set(p,'Color',[0.44 0.62 0.81])
 plot(dataLF,'r:');
 %plot(dataHF,'b-');
 plot(dataR,'k-');
end



[peaks,locs] = findpeaks(dataR);



% vyberu jen ty sprvn peaky
lastAcceptedPos = -minPeakDistance;

acceptedX = [];
acceptedY = [];

acceptedNum=1;

statPerc95 = prctile(dataR.*(1-invalid),85);

for i=1:size(locs,1)
    
    accept = true;
    
    testedPos = locs(i); %index prv testovan pozice
    
    if invalid(i)==1 continue % pokud extrem le v invalid oblasti, tak ho neem
    end
    
    if (testedPos<3) || (testedPos>length(signal)-3)  %ignoruji peaky, kter by byly pmo na kraji. To smrd.
        continue
    end
    
    
    
    statRawStart = max(locs(i)-floor(statRawSamples/2),1);
    statRawEnd = min (locs(i)+floor(statRawSamples/2),size(signal,1));
    
    statRawLongStart = max(locs(i)- floor(statRawLongSamples/2),1);
    statRawLongEnd = min (locs(i)+ floor(statRawLongSamples/2),size(signal,1));
    
    statRawBlockShort = dataR(statRawStart:statRawEnd);
    statRawBlockLong = dataR(statRawLongStart:statRawLongEnd);
    
    shortBlockVR =  max(statRawBlockShort)-min(statRawBlockShort);
    longBlockVR = max(statRawBlockLong)-min(statRawBlockLong);
    
    accept = accept && (testedPos>lastAcceptedPos+minPeakDistance); %oeten proti pli blkm peakm
    accept = accept && (dataR(testedPos)>= kHFminRation * dataHF(testedPos)); %oeten proti rychlm kmitm
    accept = accept && (dataR(testedPos)>=rMin); %oeten proti pli slabm peakm
    accept =accept && (dataR(testedPos) > statPerc95); %kontrola na velikost v rmci statistiky vyetovanch 10 sekund
    
    accept = accept && (shortBlockVR>longBlockVR*statRawKVR);
    
    accept = accept && (max(statRawBlockShort) == max (statRawBlockLong));
     
    %kontrola, e to nesoused s nevalidn oblast
    accept = accept && (dataR(testedPos+2)>0) && (dataR(testedPos-2)>0);
    
    if (accept)
        
        acceptedX(acceptedNum) = testedPos;
        acceptedY(acceptedNum) = peaks(i);

        chanResult.group(acceptedNum) = dataLF(testedPos)>dataR(testedPos);
        
        lastAcceptedPos = testedPos;
        
        acceptedNum = acceptedNum+1;
        
    end
end



if doPictures 
 pozice_red = find(chanResult.group==1);
 pozice_grn = find(chanResult.group==0);
 plot(acceptedX(pozice_red),acceptedY(pozice_red),'kv', 'MarkerFaceColor',[1 0 0],'MarkerSize',10);
 plot(acceptedX(pozice_grn),acceptedY(pozice_grn),'kv', 'MarkerFaceColor',[0 0.8 0],'MarkerSize',10);
 line([1 2500], [statPerc95 statPerc95]);
end


chanResult.qrs = acceptedX;
chanResult.rr = diff(chanResult.qrs)/250;



% nalezen nejdelho LF bloku
lfStart=1;
lfEnd=1;
maxLFlength=0;
maxLFstart=0;
maxLFend = 0;

for i=1:length(dataLF)
    if ((dataLF(i)<dataR(i)) || (invalid(i)==1))
        
        lfEnd = i;
        
        lfLength = lfEnd-lfStart;
        
        if (lfLength>maxLFlength)
            maxLFstart = lfStart;
            maxLFend = lfEnd;
            maxLFlength = lfLength;
        end
        
        lfStart=i;
        continue
    end
    lfEnd = i;
end

if ((dataLF(end)>dataR(end)) || (lfEnd>0))
      lfLength = lfEnd-lfStart;
        if (lfLength>maxLFlength)
        maxLFstart = lfStart;
        maxLFend = lfEnd;
        maxLFlength = lfLength;
        end
end

maxLFlength = maxLFlength/250;

chanResult.lfMaxLength=maxLFlength;

if doPictures
if (maxLFlength>0)
 colorRed = [0.75 0.0 0.0]
 rectangle('position',[maxLFstart -0.05 (maxLFend-maxLFstart) 0.03],'edgecolor',colorRed,'LineWidth',1,'FaceColor',colorRed)
end
 %vpis text
 lf=3010;
 my = max(signal)*0.3;
 %test zdravho signlu
 strAct = 'Suspicious activity';
 clr = [0.8 0.8 0.8];
 if (isRegularActivity(chanResult.rr, invalid))
     strAct = 'PERFECT activity';
     clr = [0.6 0.9 0]
 end
 cinv = sum(invalid)/2500; %koeficient invalidity - 0=zdrav signl, 1=zcela nepouiteln signl.
 strInfo = ['N QRS= ',num2str(length(chanResult.qrs)),10,'RR mean= ',num2str(mean(chanResult.rr)),10,'RR median= ',num2str(median(chanResult.rr)),10,'RR std= ',num2str(std(chanResult.rr)),10,'MAX LF length= ',num2str(chanResult.lfMaxLength),10,'C_I_N_V_A_L_I_D = ',num2str(cinv),10,10,strAct,10,'BPM_A_V_G = ',num2str(getBPM(chanResult.rr))];
 text(lf,my,strInfo,'BackgroundColor',clr);
end


end

