function chanResult = getABPresults_remake(signal, invalid)

dataSize = 3500;

fs = 250;

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;

invalid = invalid';

if size(signal,2) == 1
    signal = signal';
end

% filter

 f = 20;
 [b,a] = butter(3, 2*f/fs, 'low'); 
 signal = filtfilt(b,a,signal); 

% distance and ratio
min_samp_to_next = fix(fs*0.11);

winSize = 0.15*250;
winStep = 5;
limitVarRange = 5;


rawVRsignal = zeros(dataSize,1);

for pos = 1:winStep:dataSize-winSize
    
    winStart = floor(pos);
    winEnd = floor(pos+winSize);
    
    block = signal(winStart:winEnd);
    varRange = max(block)-min(block);

    halfPos = floor(winSize/2);
    
    leftAVG = mean(block(1:halfPos));
    rightAVG = mean(block(halfPos:end));
    
    if (rightAVG>leftAVG) && (varRange>=limitVarRange)
        
        rawVRsignal(winStart:winEnd) = varRange;
    end
end

f = 3;
[b,a] = butter(3, 2*f/fs, 'low'); 
smoothVR = filtfilt(b,a,rawVRsignal); 

% 
% if doPictures
%     plot(smoothVR);
% end

markList = []

if max(smoothVR)>5
[vals,locs] = findpeaks(smoothVR,'MinPeakHeight',5,'MinPeakDistance',min_samp_to_next);



areaDomSize = 50;

perc = prctile(smoothVR,50);

for m=1:length(locs)
    
adl = locs(m)-areaDomSize/2;
adr = locs(m)+areaDomSize/2;

if adl<1
    adl = 1;
end
    
if adr>dataSize
    adr = dataSize
end
    
bm = smoothVR(adl:adr);

maxValue = smoothVR(locs(m));

if max(bm)<=maxValue && maxValue>perc
    markList(length(markList)+1)=locs(m);
end

end
end

chanResult.qrs = markList;
chanResult.rr = diff(chanResult.qrs)/fs;

% dl u je jen plot


if doPictures 
 area(invalid*max(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 area(invalid*min(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 
 p=plot(signal);
 set(p,'Color',[0.1 0.62 0.81])
 
 t = 1:length(signal);
 plot(t(markList),signal(markList),'kv', 'MarkerFaceColor',[0 0.8 0],'MarkerSize',10);
 
 %vpis text
 lf=4010;
 my = max(signal)*0.3;
 
 %test zdravho signlu
 strAct = 'Suspicious (ABP V2)';
 clr = [0.8 0.8 0.8];
 
 if (isRegularActivity(chanResult.rr, invalid))
     strAct = 'PERFECT (ABP V2)';
     clr = [0.6 0.9 0];
 end
 
 cinv = sum(invalid)/dataSize; %koeficient invalidity - 0=zdrav signl, 1=zcela nepouiteln signl.
 strInfo = ['N QRS= ',num2str(length(chanResult.qrs)),10,'RR mean= ',num2str(mean(chanResult.rr)),10,'RR median= ',num2str(median(chanResult.rr)),10,'RR std= ',num2str(std(chanResult.rr)),10,'MAX LF length= ',num2str(chanResult.lfMaxLength),10,'C_I_N_V_A_L_I_D = ',num2str(cinv),10,10,strAct,10,'BPM_A_V_G = ',num2str(getBPM(chanResult.rr))];
 text(lf,my,strInfo,'BackgroundColor',clr);
end



%     figure
%     plot(signal)
%     hold on
%     t = 1:length(signal);
%     plot(t(minima),signal(minima),'ro')
%     plot(t(minima2),signal(minima2),'go')
%     plot(t(minima3),signal(minima3),'k*')













