function chanResult = getABPresults(signal, invalid)

fs = 250;

chanResult.qrs=[];
chanResult.group=[];
chanResult.rr=[];
chanResult.lfMaxLength=0;

invalid = invalid';

if size(signal,2) == 1
    signal = signal';
end

% filter

 f = 20;
 [b,a] = butter(3, 2*f/fs, 'low'); 
 signal = filtfilt(b,a,signal); 

% 
% f = [0.05 10];
% order = 2;
% ftype = 'bandpass';
% % 
% [b,a] = butter(order, 2*f/fs, ftype); 
% signal = filtfilt(b,a,signal); 
% plot(iir_x(1:delka), 'g')


% find all minims
signal_d = diff(signal);
minima = find(([signal_d 0]>0)&([0 signal_d]<=0));

% distance and ratio
minima2 = [];
minima_out = [];
min_samp_to_next = fix(fs*0.11);

for i = 1:length(minima)
    if invalid(minima(i))    % oeten invalid oblast - pokud jsu v n, tak toto minimum neem
        continue
    end
    
    if i<length(minima)
    samp_to_next = minima(i+1)-minima(i);
    y1 = fix(signal(minima(i))*100)/100;
    y2 = fix(signal(minima(i+1))*100)/100;
        if y1 == 0 && y2 == 0
            minima_ratio = 1;
        else
            minima_ratio = abs(y2/y1);
        end
    
    else
        samp_to_next = min_samp_to_next;
        minima_ratio = 10;
    end
    
    p1 = samp_to_next <= min_samp_to_next;
    p2 = (minima_ratio>0.8) && (minima_ratio<1.2);
        
    if p1 == 1 && p2 == 1
        continue
    end
    
    minima2 = [minima2 minima(i)];
    
    
%     if (samp_to_next <= min_samp_to_next) && (minima_ratio>0.8) && (minima_ratio<1.2)
%         
%     else
%         minima2 = [minima2 minima(i)];
%     end
    
end

% slope
minima3 = [];
dR = fix(fs*0.1);
dL = fix(2*dR);

for i = 1:length(minima2)
    
    leftEnd = minima2(i)-dL; 
    rightEnd = minima2(i)+dR;
    
    if leftEnd<=0 || rightEnd>2500 %kontrola, zda lev a prav okraj jsou v rozsahu pole 1:2500
        continue;
    end
    
    L = signal(leftEnd:minima2(i));
    R = signal(minima2(i):rightEnd);
    
    reg = polyfit(1:length(L),L,1);
    r_a = polyval(reg,1:length(L));
    
    reg = polyfit(1:length(R),R,1);
    r_b = polyval(reg,1:length(R));
    
    s_a = r_a(2)-r_a(1);
    s_b = r_b(2)-r_b(1);
    
    if s_a < 0 && s_b > 2*abs(s_a) && (max(R)-min(R)>0.1)
        minima3 = [minima3 minima2(i)];
    end
    
end

chanResult.qrs = minima3;
chanResult.rr = diff(chanResult.qrs)/fs;

% dl u je jen plot


if doPictures 
 area(invalid*max(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 area(invalid*min(signal),'FaceColor',[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9]);
 
 p=plot(signal);
 set(p,'Color',[0.44 0.62 0.81])
 
 t = 1:length(signal);
 plot(t(minima3),signal(minima3),'kv', 'MarkerFaceColor',[0 0.8 0],'MarkerSize',10);
 
 %vpis text
 lf=3010;
 my = max(signal)*0.3;
 
 %test zdravho signlu
 strAct = 'Suspicious activity';
 clr = [0.8 0.8 0.8];
 
 if (isRegularActivity(chanResult.rr, invalid))
     strAct = 'PERFECT activity';
     clr = [0.6 0.9 0];
 end
 
 cinv = sum(invalid)/2500; %koeficient invalidity - 0=zdrav signl, 1=zcela nepouiteln signl.
 strInfo = ['N QRS= ',num2str(length(chanResult.qrs)),10,'RR mean= ',num2str(mean(chanResult.rr)),10,'RR median= ',num2str(median(chanResult.rr)),10,'RR std= ',num2str(std(chanResult.rr)),10,'MAX LF length= ',num2str(chanResult.lfMaxLength),10,'C_I_N_V_A_L_I_D = ',num2str(cinv),10,10,strAct,10,'BPM_A_V_G = ',num2str(getBPM(chanResult.rr))];
 text(lf,my,strInfo,'BackgroundColor',clr);
end



%     figure
%     plot(signal)
%     hold on
%     t = 1:length(signal);
%     plot(t(minima),signal(minima),'ro')
%     plot(t(minima2),signal(minima2),'go')
%     plot(t(minima3),signal(minima3),'k*')













