function alarmResult=challenge(recordName,alarm_type)
%
%  alarmResult=challenge(recordName,alarm_type)
%
% Sample entry for the 2015 PhysioNet/CinC Challenge.
%
% Inputs:
%   recordName
%       String specifying the record name to process
%   alarmType
%       String specifying the alarm type. Alarm types are:
%             Asystole, Bradycardia, Tachycardia,
%             Ventricular_Tachycardia, Ventricular_Flutter_Fib
%
%
% Outputs:
%   alarmResult
%       Integer value where 0 = false alarm and 1 is a true
%       alarm. 
%
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% Dependencies:
%
%       1) This function does not requires that you have the WFDB
%       App Toolbox installed. 
%       A matlab function 'rdmat' can read the data instead of using WFDB
%       Toolbox.
%
%       2) The CHALLENGE function requires that you have downloaded the challenge
%       data 'set-p' in a subdirectory of the current directory. The subdirectory
%       should be called '/challenge/2015/set-p/' . The 'set-p' dataset can
%       be downloaded from PhysioNet at:
%           http://physionet.org/physiobank/database/challenge/2015/
%          
%         This dataset is used by the generateValidationSet.m script to
%         create the annotations on your traing set that will be used to 
%         verify that your entry works properly in the PhysioNet testing 
%         environment. 
%
% Version 0.5
%
%
% Written by Qiao Li, November 10, 2014.
% Last Modified: Ikaro Silva February 11, 2015
%
%
%
% %Example using training data- 
% alarmResult=challenge('./challenge/set-p/100','Asystole')
%

% Name of file containing answers
answers = 'answers.txt';

%Get all ECG, blood pressure and photoplethysmogram signals
[~,signal,Fs,siginfo]=rdmat(recordName);
alarmResult=1;
description=squeeze(struct2cell(siginfo));
description=description(4,:);

% naten validity alarmu - pouze pro test!!!!!
fileHeader = textread([recordName,'.hea'], '%s', 'delimiter', '\n','whitespace', '');
truePos= strfind(fileHeader{length(fileHeader)},'True');
alarmValid = false;
alarmValid = (length(truePos)>0);

startSample = 71500; %zatek vyetovan oblasti pvodn 72500, co je 4:50 sec
if strcmp(alarm_type,'Ventricular_Tachycardia')
startSample = 72500;
end


endSample = 75000; %konec vyetovan oblasti

% define invalids
% -------------------------------------------------------------------------------------

if strcmp(alarm_type,'Ventricular_Flutter_Fib')
invalids = detectInvalidAreas_208(signal,description,startSample,alarm_type);
end

if strcmp(alarm_type,'Asystole') || strcmp(alarm_type,'Bradycardia') || strcmp(alarm_type,'Tachycardia')
invalids = detectInvalidAreas_207(signal,description);
end

if strcmp(alarm_type,'Ventricular_Tachycardia')
invalids = detectInvalidAreas_105(signal,description);
end


% vygenerovn QRS znaek, piazen do skupin , RR interval a pole s
% nejdelmy LF bloky

longestLFblock = zeros(4);

% deifince structu. To je anarchie, ne programovn, toto!!!!!!!!!
% chanResult.qrs=[];
% chanResult.group=[];
% chanResult.rr=[];
% chanResult.lfMaxLength=0;



numChannels = size(signal,2);


%Odstranm NaNy
signal(isnan(signal))=0;

if doPictures
    hFig = figure('name','Detekce QRS v kanlech');
    set(hFig, 'Position', [300 300 1600 1000],'Visible','off');
end

for s=1:numChannels
%    vyem nzev kanlu a urm, do kter kategorie spad
   if (isECGChannel(description(s)))
    if doPictures
        subplot(numChannels+1,1,s)
        hold on;
        title(['Channel ',description{s},' results']);
    end
    
    singleSignal = signal(startSample:endSample,s);
   
    if strcmp(alarm_type,'Asystole') || strcmp(alarm_type,'Bradycardia') || strcmp(alarm_type,'Tachycardia')
     chanResults(s) = getECGresults_207 (singleSignal, invalids(startSample:endSample,s),alarm_type);
    end
    
     if strcmp(alarm_type,'Ventricular_Tachycardia')
     chanResults(s) = getECGresults_105 (singleSignal, invalids(startSample:endSample,s));
    end
    
    if strcmp(alarm_type,'Ventricular_Flutter_Fib')
     chanResults(s) = getECGresults_208 (singleSignal, invalids(startSample:endSample,s),alarm_type);
    end
    
   end
   
   %    vyem nzev kanlu a urm, do kter kategorie spad
   if (isBPChannel(description(s)))
    if doPictures
        subplot(numChannels+1,1,s)
        hold on;
        title(['Channel ',description{s},' results']);
    end
    singleSignal = signal(startSample:endSample,s);
    
    if strcmp(alarm_type,'Asystole')
     chanResults(s) = getABPresults_207(singleSignal, invalids(startSample:endSample,s)); %asystola m lep skore pi star QRS ABP detekci
    end
    
     if strcmp(alarm_type,'Ventricular_Flutter_Fib')
        chanResults(s) = getABPresults_remake_208(singleSignal, invalids(startSample:endSample,s));    %nicmn ta novj je lep pro ostatn kanly  
     end
    
    if strcmp(alarm_type,'Ventricular_Tachycardia')
     chanResults(s) = getABPresults_105(singleSignal, invalids(startSample:endSample,s));    %nicmn ta novj je lep pro ostatn kanly
    end
     
    if strcmp(alarm_type,'Bradycardia') || strcmp(alarm_type,'Tachycardia')
     chanResults(s) = getABPresults_remake_207(singleSignal, invalids(startSample:endSample,s));    %nicmn ta novj je lep pro ostatn kanly
    end
    
   end

   %    vyem nzev kanlu a urm, do kter kategorie spad
   if (isPLETHChannel(description(s)))
    if doPictures
        subplot(numChannels+1,1,s)
        hold on;
        title(['Channel ',description{s},' results']);
    end
    
    singleSignal = signal(startSample:endSample,s);
  
     if strcmp(alarm_type,'Ventricular_Flutter_Fib')
        chanResults(s) = getABPresults_208 (singleSignal, invalids(startSample:endSample,s));
     end
     
    if strcmp(alarm_type,'Ventricular_Tachycardia')
     chanResults(s) = getABPresults_105 (singleSignal, invalids(startSample:endSample,s));
    end
     
     if strcmp(alarm_type,'Asystole') || strcmp(alarm_type,'Bradycardia') || strcmp(alarm_type,'Tachycardia')
        chanResults(s) = getABPresults_207 (singleSignal, invalids(startSample:endSample,s));
     end
    
   end
%    
%    if (isRESPChannel(description(s)))
%        chanResults(s).qrs=[];
%        chanResults(s).rr=[];
%        invalids(:,s) = 1;
%        subplot(numChannels+1,1,s)
%        title(['Channel ',description{s},' is not used']);
%    end
   
end

if doPictures
 subplot(numChannels+1,1,numChannels+1)
 hold on;
end


for s=1:numChannels
    
   if (s<=length(chanResults))
    
     if strcmp(alarm_type,'Ventricular_Flutter_Fib') && isRegularActivity_208(chanResults(s).rr, invalids(startSample:endSample,s),alarm_type)
         alarmResult=0;
     end
       
    if  (strcmp(alarm_type,'Asystole') || strcmp(alarm_type,'Bradycardia') || strcmp(alarm_type,'Tachycardia')) && isRegularActivity_207(chanResults(s).rr, invalids(startSample:endSample,s)) %mon by lo pout 207 pro vechno...
        alarmResult=0;
    end
    
    if strcmp(alarm_type,'Ventricular_Tachycardia') && isRegularActivity_105(chanResults(s).rr, invalids(startSample:endSample,s))
       alarmResult=0;
    end
    
   end
end



if alarmResult==1 %protoe pokud to je zdrav signl zjitn dkem cca 166, tak alarmResult=0 a nem smysl alarmy dle testovat
switch alarm_type
    case 'Asystole'
          alarmResult = testAsystole_207(chanResults,signal(startSample:endSample,:), invalids(startSample:endSample,:));
    case 'Bradycardia'
        alarmResult = testBrady_207(chanResults,signal(startSample:endSample,:), invalids(startSample:endSample,:));      
    case 'Tachycardia'
        alarmResult = testTachy_207(chanResults,signal(startSample:endSample,:), invalids(startSample:endSample,:));     
    case 'Ventricular_Tachycardia'
        alarmResult = testVentTachycardia_105(chanResults,signal(startSample:endSample,:), invalids(startSample:endSample,:),description);      
    case 'Ventricular_Flutter_Fib'
        alarmResult = testVentFlutterFib_208(chanResults,signal(startSample:endSample,:), invalids(startSample:endSample,:),description);
    otherwise
        error(['Unknown alarm type: ' alarm_type])
end
end

bckColor = [0.6 0.9 0];

alarmtxt = ' False';
 if alarmResult
    alarmtxt=' True';
 end

if alarmResult~=alarmValid
    bckColor = [1.0 0.1 0];
    
    if (alarmValid)
    bckColor = [1.0 0.5 0];
    
    end
else
    if (alarmValid)
    bckColor = [0.6 0.9 0.4];
    end
end

alarmText = ' False ';
suffix ='';

if alarmValid
    alarmText = ' TRUE ';
    suffix = '_true';
end


if doPictures
    annotation('textbox', [0.13,0.96,0.775,0.035], 'String',['File: ',recordName,'   ','Tested alarm: ',alarm_type,'      Train validity: ',alarmText,' |  Result:',alarmtxt ],'BackgroundColor',bckColor,'EdgeColor',bckColor);
    hold off
    hgexport(hFig, [recordName,suffix,'.png'], hgexport('factorystyle'), 'Format', 'png');
    close(hFig);
end

% zznam do txt
if false
    fid = fopen('locres210.txt','at');
    str = [recordName,';',alarm_type,';',alarmText,';','-',';',alarmtxt,';'];
    
    fprintf(fid,'%s', str);
     
    
    
    for s=1:length(chanResults)
     avgBPM = getBPM(chanResults(s).rr);
     fprintf(fid,'%s;%d;%1.4f;%2.1f;%3.1f;', description{s},length(chanResults(s).qrs),std(chanResults(s).rr),sum(chanResults(s).rr),avgBPM);
    end;
    
    fprintf(fid,'%s\n', ' ');
    
    fclose(fid);
end

% Write result to answers.txt
fid = fopen(answers, 'a');
if (fid == -1)
    error('Could not open answer file');
end

% Get base name of record (without directories)
i = strfind(recordName, filesep);
if (~isempty(i))
    basename = recordName(i(end)+1 : end);
else
    basename = recordName;
end

fprintf(fid, '%s,%d\n', basename, alarmResult);
fclose(fid);

end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end
end
