function [ECG_segmen]= segECG(senal,fs,algoritmoR,indicador,alarm_type,picoR)

%..........................................................................
% Help
% The function segment (segECG.mat), makes an estimate of the fiducial points 
% of the waves of the ECG signal. The points are: Wave P (beginning and end). 
% QRS complex (Start Q, R peak, Final S). Onda T (start and end). The fiducial 
% marks calculated are stored in an object of type struct and contains the number 
% of the sample where any point is located. The function of segment contains three 
% parameters which are: the signal, the sampling frequency and the algorithm used 
% to estimate the peak R.
% Algorithms for R peak detection, can be classified as follows:
% 0: QRS_AF1 = amplitude and first derivative 1
% 1: QRS_AF2 = amplitude and first derivative 2
% 2: QRS_AF3 = amplitude and first derivative 3
% 3: QRS_FD1 = only first derivative 1
% 4: QRS_FD2 = only first derivative 2
% 5: QRS_FSD1 = first and second derivative 1
% 6: QRS_FSD2 = first and second derivative 2
% 7: QRS_DIFI1 = with digital filters 1
% 8: QRS_DIFI2 = with digital filters 2
% 9: QRS_HILBERT = uses the Hilbert transform
% 10: QRS_WT = Wavelet transform used
% 11: QRS_HIBRIDO = used the Hybrid Algorithm
% Developed function by JL RODRIGUEZ 06.
%..........................................................................

if nargin<6
    picoR = QRS(senal,fs,algoritmoR,alarm_type);
    %Last_R_peak = max(picoR);
end
if length(picoR)==2
    picoR = picoR;
else
    if indicador == 1
        picoR = picoR(2:length(picoR)-1);
    else
        picoR = picoR(1:length(picoR)-1);
    end
end
ecg     = senal;
ecg     = ecg-mean(ecg);
ecg     = ecg/abs(max(ecg));
% Continuous 1-D wavelet coefficients (scales decomposition)
%..........................................................................
c1      = cwt(ecg,[2 4 8 16],'gaus1');
signal  = c1(2,:);
signal4 = c1(4,:);
% Detecting fiducial QRS peaks
%..........................................................................
[pqrs , iqrs , fqrs] = dec_qrs2( signal, picoR ,fs);
% Detecting fiducial P wave peaks
%..........................................................................
[ip , fp ]           = dec_p(signal4, iqrs , fs );
% Detecting fiducual T wave peaks
%..........................................................................
[it , ft ]           = dec_t( ecg , signal4, fqrs , fs );
ECG_segmen.Pon   = ip;
ECG_segmen.Poff  = fp;
ECG_segmen.Qon   = iqrs;
ECG_segmen.Rpeak = pqrs;
ECG_segmen.Soff  = fqrs;
ECG_segmen.Ton   = it;
ECG_segmen.Toff  = ft;
end

