% This function is based on the original function challenge.m with the same 
% input and output variables.The name has been changed to identify it as our 
% own function.
function alarmResult = challenge(record_name,alarm_type)
    close all;
    %......................................................................
    % Variables and Thresholds
    %......................................................................
    answers             = 'answers.txt';
    umbral_Asystole     = 4;
    umbral_Bradycardia  = 40;
    consec_beats        = 5;
    umbral_Tachycardia  = 140;
    consec_beats_t      = 15;
    umbral_VT           = 100;
    alarmResult         = 1;
    %......................................................................
    % Load signals and description
    %......................................................................
    [~,signal,Fs,siginfo]   =   rdmat(record_name);
    description             =   squeeze(struct2cell(siginfo));
    description             =   description(4,:);
    t                       =   (0:size(signal,1)-1)/Fs;
    %......................................................................
    % Alarm Type analysis
    %......................................................................
    if strcmp(alarm_type,'Ventricular_Tachycardia') == 1
        senalecg   = signal(:,1);
        [senalecg] = Preprocess(senalecg);
        %..................................................................
        % Solution using QRS Morphology and Delineated
        %..................................................................
        if mean(abs(senalecg)) ~= 0
        [ECG_segmen]            = segECG(senalecg,Fs,11,1,alarm_type);
        [NewpicosRI]            = AjustePicoR(ECG_segmen.Rpeak,senalecg,Fs);
        ECG_segmen.Rpeak        = NewpicosRI; 
        record                  = visualization(ECG_segmen,senalecg,Fs);
        [Fcardiaca RR]          = FreCardppg(ECG_segmen.Rpeak,t);
        else
            ECG_segmen = [];
            Fcardiaca  = [];
            record     = [];
        end
        %..................................................................
    elseif strcmp(alarm_type,'Ventricular_Flutter_Fib') == 1
        senalecg   = signal(:,1);
        [senalecg] = Preprocess(senalecg);
        %..................................................................
        % Solucin: Mediana de la Varianza en el tiempo de la trama patolgica 
        %..................................................................
        mua     = 0.2433; % Median of Varince
        [y1]    = Test_Flutter(senalecg,t);
        [a b c] = find(y1 >= mua & y1 <= 0.25);
        %..................................................................
    else
        [DataRpeak] = Detection_Rpeak(description,signal,Fs,alarm_type);
       
        [picoRII picoRppg] = Detection_HeartRate(DataRpeak);
        if length(picoRII) > 1 && length(picoRppg) > 1
            [FcardiacaII Fcardiacappg RRII RRPPG] = FreCard(picoRII,picoRppg,t);
        elseif length(picoRII) > 1 && (length(picoRppg) == 1 || isempty(picoRppg))
            RRPPG                = [];
            Fcardiacappg         = [];
            [FcardiacaII RRII]   = FreCardppg(picoRII,t);
        elseif length(picoRII)   == 1 && length(picoRppg) ~= 1 
            RRII                 = [];
            FcardiacaII          = [];
            [Fcardiacappg RRPPG] = FreCardppg(picoRppg,t);
        elseif length(picoRII)   == 1 && length(picoRppg) == 1
            RRII  = [];
            RRPPG = []; 
        end 
    end
    %......................................................................
    % Alarm Evaluation
    %......................................................................
    switch alarm_type
                case 'Asystole' % No QRS for at least 4 seconds
                    [a b c] = find(RRII >= umbral_Asystole);  [a1 b1 c1] = find(RRPPG >= umbral_Asystole);
                    if sum(a) >= 1 && sum(a1) >= 1
                        alarmResult = 1;
                    else
                        alarmResult = 0;
                    end
                case 'Bradycardia' % Heart rate lower than 40 bpm for 5 consecutive beats
                    ceros1 = find(FcardiacaII <= 5);
                    if ceros1 >= 1
                        HrateII = [];
                    else
                        [HrateII]  = Test_Brady(FcardiacaII,consec_beats,umbral_Bradycardia);
                    end
                    ceros = find(Fcardiacappg == 0);
                    if ceros >= 1
                        HratePPG = [];
                    else
                        [HratePPG] = Test_Brady(Fcardiacappg,consec_beats,umbral_Bradycardia);
                    end
                    [a b c] = find(HrateII == 1); [a1 b1 c1] = find(HratePPG == 1); 
                    if sum(a) >= 1 && sum(a1) >= 1
                        alarmResult = 1;
                    else
                        alarmResult = 0;
                    end
                 case  'Tachycardia' % Heart rate higher than 140 bpm for 17 consecutive beats
                    [HrateII]  = Test_Brady(FcardiacaII,consec_beats_t,umbral_Tachycardia);
                    
                    [a b c] = find(HrateII == 1); 
                    if sum(a) >= 1 
                        alarmResult = 1;
                    else
                        alarmResult = 0;
                    end  
                 case 'Ventricular_Tachycardia' % 5 or more ventricular beats with heart rate higher than 100 bpm
                    [vbeat] = Test_VT(Fcardiaca,umbral_VT,ECG_segmen,record);
                    a1 = find(vbeat == 1);
                    if length(a1) > 1
                        alarmResult = 1;
                    else
                        alarmResult = 0;
                    end    
                case 'Ventricular_Flutter_Fib' % Fibrillatory, flutter, or oscillatory waveform for at least 4 seconds
                    if length(a) > 1
                        alarmResult = 1;
                    else
                        alarmResult = 0;
                    end        
    end
    %......................................................................
    % Write result to answers.txt
    %......................................................................
     fid = fopen(answers, 'a');
     if (fid == -1)
        error('Could not open answer file');
     end
     fprintf(fid, '%s,%d\n', record_name, alarmResult);
     fclose(fid);
    %......................................................................
end