function picoR = QRS_HIBRIDO(senal,fs,alarm_type)
%..........................................................................
% HELP
% Estimation algorithm that performs fiducial mark of the peak R, using:
% -Bandpass filter
% -Filter spline
% -Energy from shannon
% -Normalization of shannon
% -Interpolation
% -Adaptive thresholding in amplitude and time
% -Refractory period
% The function has two parameters which are:
% Signal and the sampling frequency.
% tomado de JOSE LUIS RODRIGUEZ 2004 (MASTER THESIS)
% revisado por JL RODRIGUEZ S 2006
%..........................................................................

% Adjustment of the refractory period
if strcmp(alarm_type,'Bradycardia')==1
    Tref = round(0.6*fs);
elseif strcmp(alarm_type,'Ventricular_Flutter')==1
    Tref = round(0.1*fs);
else
    Tref = round(0.2*fs);
end
ecg   = senal;
picoR = 1; 

% Stage for signal preprocessing, i.e. remove the DC level and normalize
ecg   = ecg - mean(ecg); 
ecg   = ecg/max(abs(ecg)); 
senal = ecg;

% Bandpass filter coefficients of 5-15 Hz taken from Tomkins
aPB = [1 -2 1 zeros(1,10)];
bPB = [1 zeros(1,5) -2  zeros(1,5) 1];
aPA = [1 -1 zeros(1,31)];
bPA = [-1/32 zeros(1,15) 1 -1 zeros(1,14) 1/32];
senalPB    = filter(bPB,aPB,senal);
senalResul = filter(bPA,aPA,senalPB);
senalResul = senalResul/max(senalResul);

% Filter spline scaling 2^1
q_1w              = [2 -2];
SenalR            = filter(q_1w,[1],senalResul); 
SenalResulSpline1 = SenalR;

% This part is to approximate the samples are 0 filtered ECG signal to a 
% different value to avoid the discontinuity by the logarithm of 0, on the 
% energy of Shannon
N                                             = floor(0.08*fs);  
SenalResulSpline1(find(SenalResulSpline1==0)) = 0.000001;
Es(1:round(length(SenalResulSpline1)/N))      = 0;

% Energy Shannon bound 80mseg with overlapping windows is calculated with 
% 40msec. The window corresponding to the duration of a QRS complex approx. 
% for binding energy peaks spline filter.
k = 1;
for i = 1:N/2:length(SenalResulSpline1)-N
    Es(k) = (-1/N).*sum(((SenalResulSpline1(i:i+N)).^2).*(log((SenalResulSpline1(i:i+N)).^2)));
    k     = k+1;  
end

Es_P   = ( Es - mean(Es) )/ std(Es);
Es_int = InterLineal(Es_P,N/2);
Es_int = Es_int/max(Es_int);

% Start search R peak
%..........................................................................
% One search is performed in the first 500 samples of up to determine the 
% threshold value (approx. 2 or 3 beats)

Aj         = max(Es_int(1:500)); 
umbral     = 0.35*Aj;
k          = 1;
i          = (0.04*fs);
bandera_sb = 0;
picoR      = 0;
while i < length(Es_int) - 1
    if bandera_sb == 1
        umbral = umbral/2;
        while i < picoRultimo-(0.8*fs)
            if Es_int(i) > umbral
                [valor,pos]= max(Es_int(i:i+(0.4*fs)));
                picoR(k)= pos + i;
                k=k+1;
                i= i+(0.4*fs);
            else
                i= i+1;
            end
        end
        umbral= umbral*2;
        i= picoRultimo+(0.4*fs);
        bandera_sb= 0;
        picoR(k)=picoRultimo;
        k=k+1;
    end
    if i > length(Es_int)
        break
    end
    if Es_int(i) > umbral
        [valor,pos]= max(Es_int(i:i+1));
        picoR(k)= pos + i;
        if valor < 2*Aj
            Aj= (7/8)*Aj + (1/8)*valor;
            umbral= 0.35*Aj;
        end
        if k>=2
            RRact= picoR(k)-picoR(k-1);
        else
            RRact = floor(fs*0.8);
        end
        
        if k == 1
            RRAV1_v = [floor(fs*0.8)*ones(1,8)];
        end
        for j = 2:8
            RRAV1_v(j-1)= RRAV1_v(j);
        end
        RRAV1_v(8)= RRact;
        RRAV1= sum(RRAV1_v)/8;
        if RRact < 1.16*RRAV1 & RRact > 0.92*RRAV1
            if k == 1
                RRnorm = [floor(fs*0.8)*ones(1,8)];
            end
            for j = 2:8
                RRnorm(j-1)= RRnorm(j);
            end
            RRnorm(8)= RRact;
            RRAV2 = sum(RRnorm)/8;
        end
        if k >= 2
            if RRact > RRAV2*1.66
                bandera_sb =1;
                i= picoR(k-1) + round(0.6*fs);
                picoRultimo= picoR(k);
            else
                k= k+1;
                i= i+ Tref;
            end
        else
            k= k+1;
            i= i+ Tref;
        end
    else
        i= i+1;
    end
end
%..........................................................................