function picoR = QRS(senal,fs,algoritmo,alarm_type)

%..........................................................................
% The signal signal parameter is either real or synthetic.
% The parameter fs is the sampling frequency of the signal.

% The algorithm parameter, can be classified as follows:
% 0: QRS_AF1 = amplitude and first derivative 1
% 1: QRS_AF2 = amplitude and first derivative 2
% 2: QRS_AF3 = amplitude and first derivative 3
% 3: QRS_FD1 = only first derivative 1
% 4: QRS_FD2 = only first derivative 2
% 5: QRS_FSD1 = first and second derivative 1
% 6: QRS_FSD2 = first and second derivative 2
% 7: QRS_DIFI1 = with digital filters 1
% 8: QRS_DIFI2 = with digital filters 2
% 9: QRS_HILBERT = uses the Hilbert transform
% 10: QRS_WT = Wavelet transform used
% 11: QRS_HIBRIDO = used the Hybrid Algorithm
%..........................................................................

switch algoritmo
%     case 0,
%         picoR = QRS_AF1(senal,fs);
%     case 1,
%         picoR = QRS_AF2(senal,fs);
%     case 2,
%         picoR = QRS_AF3(senal,fs);
%     case 3,
%         picoR = QRS_FD1(senal,fs);
%     case 4,
%         picoR = QRS_FD2(senal,fs);
%     case 5,
%         picoR = QRS_FSD1(senal,fs);
%     case 6,
%         picoR = QRS_FSD2(senal,fs);
%     case 7,
%         picoR = QRS_DIFI1(senal,fs);
%     case 8,
%         picoR = QRS_DIFI2(senal,fs);
%     case 9,
%         picoR = QRS_HILBERT(senal,fs);
%     case 10,
%         picoR = QRS_WT(senal,fs);
    case 11,
        picoR = QRS_HIBRIDO(senal,fs,alarm_type);
end        