function [senalecg] = Preprocess(senalecg)
    %......................................................................
    % Function to preprocess ECG signal:
    % - Verifies the existence of NaN in the register
    % - Centralized ECG
    % - The signal is filtered as a predetermined threshold
    %......................................................................
     
    [a b]  = find(isnan(senalecg));
    for i1 = 1:length(a)
        if i1 == 1 && isnan(senalecg(i1,1))
            senalecg(a(i1,1),b(i1,1)) = 0;
        else
            senalecg(a(i1,1),b(i1,1)) = senalecg(a(i1,1)-1,b(i1,1));
        end
    end
    senalecg = senalecg - mean(senalecg);
    desv     = std(senalecg);
    absenal  = abs(senalecg);
    umbr     = (5*desv);
    [a b c]  = find(absenal >= umbr);
    if length(a) > 0
        if a(1) == 1
            a(1) = a(1)+1;
        end
    end
    senalecg(a,1) = senalecg(a-1,1);
end