function [NewpicosRI] = AjustePicoR(picosRI,ECGleadI,Fs)

%..........................................................................
% This performs an adjustment of the R peak position detected by a maximum 
% search methodology for windowing.
%..........................................................................

ventana = [];
tamano  = 0.032*Fs;
for k = 1:size(picosRI,2)
    if  (picosRI(1,k)-tamano) <= 0
        ventana = (1 : picosRI(1,k)+tamano);
    else
        ventana = (picosRI(1,k)-tamano : picosRI(1,k)+tamano);
    end
    [val ind]       = max(ECGleadI(ventana));
    NewpicosRI(1,k) = ventana(ind);
end
ampa  = NewpicosRI(1,1);
for j = 2: length(NewpicosRI)
    if ECGleadI(NewpicosRI(1,j)) < ECGleadI(NewpicosRI(1,j-1))/2
        % Not include
    else
        ampa = [ampa NewpicosRI(1,j)];
    end
end
NewpicosRI = ampa;   
end