if strcmp(alarm_type,'Ventricular_Flutter_Fib')
    
    % BPF
    fl=0.5;
    fu=50;
    Mbpf=101; Mbpf2=(Mbpf-1)/2;
    hBP=fir1(Mbpf-1,[fl fu]/(Fs/2),'bandpass');
    s=conv(hBP,signal(:,chan));
    s=s(Mbpf2+1:end-Mbpf2);
    s=s/max(abs(s));
    
    % Check for unusual cases
    if ~(sum(abs(signal(N_d-4*Fs+1:N_d,chan)))<2||sum(isnan(signal(N_d-4*Fs+1:N_d,chan)))||sum(s)==0||(sum(signal(:,chan)==0)/length(signal(:,chan))>0.05))
        
        % Investigate 2s before the alarm
        N0_d2=N_d-Fs*4+1;
        s=s(N0_d2:N_d,1);
        Ls=length(s);
        t=(0:Ls-1)/Fs;
        
        Nfft=4096;
        f=(0:Nfft-1)*Fs/Nfft;
        S=abs(fft(xcorr(s),Nfft))/Ls;
        Rxx=(max(S(f>4&f<7))>1.25)&&(max(S(f>4&f<7))>max(S(f<4)));

        % Look for beats
        s1=diff(s).^2;
        ecg_th=0.25*2.5*mean(s1);
        [pks1,pos1]=findpeaks(s1,'MINPEAKHEIGHT',ecg_th,'MINPEAKDISTANCE',50);
        fu=0;
        if ((length(pos1)>2)&&((mean(diff(pos1))/Fs)>0.45)&&(max(pks1)>5e-3)&&Rxx==0)
            f1=0; % beat is there
        else
            f1=1;
        end
       
        % FFT detector
%         S=abs(fft(s,Nfft))/length(s);
%         figure(2)
%         subplot(211),plot(t,s)
%         title('Time-domain signal.')
%         xlabel('t (s)')
%         subplot(212),plot(f,S)
%         title('Frequency-domain signal.')
%         xlabel('f (Hz)')
%         axis([0 50 0 0.2])
    else
        fu=1;
        f1=0;
    end
    
end
