if strcmp(alarm_type,'Asystole')
    
    % Reset alarms
    au=0;
    a1=0;
    
    % BPF
    %signal(:,1)=signal(:,1)/max(abs(signal(:,1)));    
    Mbpf=11; Mbpf2=(Mbpf-1)/2; 
    hBP=fir1(Mbpf-1,[5 30]/(Fs/2),'bandpass');
    s=conv(hBP,signal(:,chan));
    s=s(Mbpf2+1:end-Mbpf2);
    
    % Hilbert detector
    sf=diff(s(N_d-Fs*16+1:N_d,1)).^2;
    
    % Check for unusual cases
    if ~(sum(abs(signal(N_d-3*Fs+1:N_d,chan)))<2||sum(isnan(s))||sum(s)==0||(sum(signal(:,chan)==0)/length(signal(:,chan))>0.05)||mean(sf)>1e-1)
        
        % Compute signal's pdf (whole signal up to N0_d)
        dx=0.01;
        [ps1,fs1]=hist(s,min(s):dx:max(s));
        ps1=ps1/(length(N0_d)*dx);
        a1=1.9*std(s);
        ecgSQI1=sum(ps1(fs1>0&fs1<=a1))/sum(ps1(fs1>a1));
        
        if (ecgSQI1~=0&&ecgSQI1~=Inf&&ecgSQI1~=-Inf&&~isnan(ecgSQI1)&&ecgSQI1~=-NaN)
            
            % Investigate 5s before the alarm
            N0_d2=N_d-Fs*3+1;
            
            % Hilbert detector
            senv=diff(s(N0_d2:N_d,1));
            
            % LPF
            M=7;Md=(M-1)/2;
            senvf=conv(ones(1,M)/M,senv);
            senvf=senvf(Md+1:end-Md);
            
            % Get threshold
            ecg_th=2.5*std(senvf);
            
            % Blank higher peaks
            senvf(senvf>ecg_th)=ecg_th;
            
            % Find bps
            [pks2,pos2]=findpeaks(senvf,'MINPEAKHEIGHT',ecg_th*0.5,'MINPEAKDISTANCE',50);
            
            if (pks2<1e-2)
                a1=1;
            else
                if length(pos2)>1
                    if (max(chkz(senvf,mean(pks2)*0.125))>80)
                        a1=1;
                    else
                        ps=diff(pos2);
                        dx=1;
                        [ps1,fs1]=hist(ps,min(ps):dx:max(ps));
                        [~,pos3]=max(ps1);
                        b=fs1(pos3)/125;
                        a1=0;
                    end
                else
                    a1=1;
                end
            end
        else
            au=1;
        end
    else
        au=1;
    end
    
end
%keyboard
