if strcmp(alarm_type,'Asystole')
    
    % Reset alarms
    bu=0;
    b1=0;
    
    % HP filtering
    %signal(:,1)=signal(:,1)/max(abs(signal(:,1)));    
    s=diff(signal(1:N0_d,1));
    
    sf=diff(signal(N_d-Fs*16+1:N_d,1));
    %[pks0,pos0]=findpeaks(sf,'MINPEAKHEIGHT',0.2);
    
    % Check for unusual cases
    if ~(sum(abs(signal(N_d-3*Fs+1:N_d,1)))<2||sum(isnan(s))||sum(s)==0||(sum(signal(:,1)==0)/length(signal(:,1))>0.05)||mean(sf)>1e-1)
        
        % Compute signal's pdf (whole signal up to N0_d)
        dx=0.01;
        [ps1,fs1]=hist(s,min(s):dx:max(s));
        ps1=ps1/(length(N0_d)*dx);
        a1=1.9*std(s);
        ecgSQI1=sum(ps1(fs1>0&fs1<=a1))/sum(ps1(fs1>a1));
        
        if (ecgSQI1~=0&&ecgSQI1~=Inf&&ecgSQI1~=-Inf&&~isnan(ecgSQI1)&&ecgSQI1~=-NaN)
            
            % Investigate 5s before the alarm
            N0_d2=N_d-Fs*3+1;
            
            % HPF
            s=diff(signal(N0_d2:N_d,1));
            Ls=length(s);
            
            % Get envelope
            %shat=hilbert(s);
            %senv=abs(s.^2+1j*shat.^2);
            senv=s;
            
            % LPF
            M=7;Md=(M-1)/2;
            senvf=conv(ones(1,M)/M,senv);
            senvf=senvf(Md+1:end-Md);
            
            % Get threshold
            ecg_th=1.9*std(senvf);
            
            % Blank higher peaks
            senvf(senvf>ecg_th)=ecg_th;
            
            % Find bps
            [pks2,pos2]=findpeaks(senvf,'MINPEAKHEIGHT',ecg_th*0.5,'MINPEAKDISTANCE',50);
            
            if (pks2<1e-2)
                b1=1;
            else
                if length(pos2)>1
                    if (max(chkz(senvf,mean(pks2)*0.125))>80)
                        b1=1;
                    else
                        ps=diff(pos2);
                        dx=1;
                        [ps1,fs1]=hist(ps,min(ps):dx:max(ps));
                        [~,pos3]=max(ps1);
                        b=fs1(pos3)/125;
                        b1=0;
                    end
                else
                    b1=1;
                end
            end
        else
            bu=1;
        end
    else
        bu=1;
    end
    
end
%keyboard
