clear, clc, close all;
recordName='v131l';
[~,signal,Fs,siginfo]=rdmat(recordName);

% Investigate 16s before the alarm
N_d=Fs*5*60; % alarm position
N0_d2=N_d-Fs*10+1;
% Hilbert detector
signal=signal(N0_d2:N_d,1);

fs=Fs(1);
Nfft=2^13;
f=(0:Nfft-1)*fs/Nfft;
N=length(signal);
L=round(length(signal)/N)-1;
L=1;
ms=zeros(1,L);
M=2; % filter avg
str='rbgk';
for k=1:1
    for i=1:L
        s=signal(1+(i-1)*N:i*N,k);
        S=abs(fft(s,Nfft))/N;
        ms(i)=mean(S);
        figure(1)
        plot(f,S)
        axis([0 60 0 0.1])
        pause
    end
    %     figure(2)
    %     %subplot(3,1,k)
    %     time=5*60*fs-20*fs:5*60*fs;
    %     plot(time/fs,signal(time,k),str(k))
    %     hold on
    %     %plot((0:L-1)*N/fs,filter(ones(1,M),M,ms*100),'r')
    %     xlabel('Time')
end

