clear, close all
tic
type=4;
myAlarmType={'Asystole','Bradycardia','Tachycardia','Ventricular_Tachycardia','Ventricular_Flutter_Fib'};

% Open file
l=lower(myAlarmType{type});
if type<5
    fid=fopen(strcat(l(1),'False.txt'),'rt');
else
    fid=fopen('fFalse.txt','rt');
end
if (fid==-1)
    error('Can not open file !');
end

% Check false alarms
fn=fgets(fid);
fn=fn(1:end-5);
nF=0; rF=0;
disp('Processing false alarms ...')
while  ~isempty(fn)  
    %break
    new_rF=challenge(fn,myAlarmType{type});
    str=['%d:\t%d\t' fn '\n'];
    fprintf(str,nF+1,new_rF);
    rF=rF+new_rF;
    fn=fgets(fid);
    if ~isempty(fn)
        fn=fn(1:end-5);
        nF=nF+1;
    end
end
fclose(fid);

% Open file
l=lower(myAlarmType{type});
if type<5
    fid=fopen(strcat(l(1),'True.txt'),'rt');
else
    fid=fopen('fTrue.txt','rt');
end
if (fid==-1)
    error('Can not open file !');
end

% Check true alarms
fn=fgets(fid);
fn=fn(1:end-5);
nT=0; rT=0;
disp('Processing true alarms ...')
while  ~isempty(fn)
    %break
    new_rT=challenge(fn,myAlarmType{type});
    str=['%d:\t%d\t' fn '\n'];
    fprintf(str,nT+1,new_rT);
    rT=rT+new_rT;
    fn=fgets(fid);
    if ~isempty(fn)
        fn=fn(1:end-5);
        nT=nT+1;
    end
end
fclose(fid);

% Statistics
N=nF+nT; % Total files
TP=rT/nT*(1-nF/N);
FP=rF/nF*(1-nT/N);
FN=nT/N-TP;
TN=nF/N-rF/N;
Sensitivity= TP/(TP+FN);
Specificity=TN/(TN+FP);
disp('Results')
str=[myAlarmType{type},': \tTP: %1.3f\tFP: %1.3f \tFN: %1.3f\tTN: %1.3f \tSens: %1.3f \tSpec: %1.3f\n'];
fprintf(str,TP,FP,FN,TN,Sensitivity,Specificity)

toc

display(['Packaging your entry (excluding any subdirectories) to:' pwd filesep 'entry.zip'])
delete('entry.zip')
zip('entry.zip',{'*.m','*.txt','*.sh'});
