clear all;
close all
clc
tic

fid=fopen('answers.txt','r');
if(fid ~= -1)
    ANSWERS=textscan(fid,'%s %d','Delimiter',',','EmptyValue',0); %Set empty values to FALSE alarms by default
    fclose(fid);
else
    error('Could not open users answer.txt for scoring. Run the generateValidationSet.m script and try again.')
end

fid=fopen(['ALARMS'],'r');
if(fid ~= -1)
    GOLD=textscan(fid,'%s %s %d','Delimiter',',');
    fclose(fid);
else
    error('Could not open challenge/ALARMS for scoring. Exiting...')
end

N=length(GOLD{1});
%Result columnes are: true positives, false positive, false negative, true
%negatives
RECORDS=GOLD{1};
ALARMS=GOLD{2};
ALARM_TYPES=unique(ALARMS);
NTYPES=length(ALARM_TYPES);
results=zeros(NTYPES,4);
GOLD_TRUTH=GOLD{3};

A0_record=[];
A1_record=[];
B0_record=[];
B1_record=[];
T0_record=[];
T1_record=[];
VT0_record=[];
VT1_record=[];
VF0_record=[];
VF1_record=[];

for i=1:N
    switch ALARMS{i}
        case 'Asystole'
            if GOLD_TRUTH(i)==0
                A0_record = [A0_record;RECORDS(i),i];
            else
                A1_record = [A1_record;RECORDS(i),i];
            end
            
        case 'Bradycardia'
            if GOLD_TRUTH(i)==0
                B0_record = [B0_record;RECORDS(i),i];
            else
                B1_record = [B1_record;RECORDS(i),i];
            end
        case 'Tachycardia'
            if GOLD_TRUTH(i)==0
                T0_record = [T0_record;RECORDS(i),i];
            else
                T1_record = [T1_record;RECORDS(i),i];
            end
        case 'Ventricular_Tachycardia'
            if GOLD_TRUTH(i)==0
                VT0_record = [VT0_record;RECORDS(i),i];
            else
                VT1_record = [VT1_record;RECORDS(i),i];
            end
        case 'Ventricular_Flutter_Fib'
            if GOLD_TRUTH(i)==0
                VF0_record = [VF0_record;RECORDS(i),i];
            else
                VF1_record = [VF1_record;RECORDS(i),i];
            end
    end
end

cur_type1=VF0_record;
cur_type2=VF1_record;
cur_type=[cur_type1; cur_type2];
Acc=zeros(length(cur_type),1);
Index=[];

T_A=8;
T_A_be=60;
T_A_post=30;
Cons_tem_num=10;

Flag_A_True_ECG1=ones(length(cur_type),1);
Flag_A_True_ECG2=ones(length(cur_type),1);
Flag_A_True_ABP=ones(length(cur_type),1);
Flag_A_True_PPG=ones(length(cur_type),1);
Flag_A_True=ones(length(cur_type),1);
Flag_A_True_ECG1_post=zeros(length(cur_type),1);
Flag_A_True_ECG2_post=zeros(length(cur_type),1);
Flag_A_True_ABP_post=zeros(length(cur_type),1);
Flag_A_True_PPG_post=zeros(length(cur_type),1);

Flag_B_True_ECG1=ones(length(cur_type),1);
Flag_B_True_ECG2=ones(length(cur_type),1);
Flag_B_True_ABP=ones(length(cur_type),1);
Flag_B_True_PPG=ones(length(cur_type),1);
Flag_B_True=ones(length(cur_type),1);
Flag_B_True_ECG1_post=zeros(length(cur_type),1);
Flag_B_True_ECG2_post=zeros(length(cur_type),1);
Flag_B_True_ABP_post=zeros(length(cur_type),1);
Flag_B_True_PPG_post=zeros(length(cur_type),1);

Flag_T_True_ECG1=ones(length(cur_type),1);
Flag_T_True_ECG2=ones(length(cur_type),1);
Flag_T_True_ABP=ones(length(cur_type),1);
Flag_T_True_PPG=ones(length(cur_type),1);
Flag_T_True=ones(length(cur_type),1);

Flag_VT_True_ECG1=zeros(length(cur_type),1);
Flag_VT_True_ECG2=zeros(length(cur_type),1);
Flag_VT_True_ABP=ones(length(cur_type),1);
Flag_VT_True_PPG=ones(length(cur_type),1);
Flag_VT_True=zeros(length(cur_type),1);
Flag_VT_True_ECG1_post=ones(length(cur_type),1);
Flag_VT_True_ECG2_post=ones(length(cur_type),1);
Flag_VT_True_ABP_post=ones(length(cur_type),1);
Flag_VT_True_PPG_post=ones(length(cur_type),1);


Flag_VF_True_ECG1=ones(length(cur_type),1);
Flag_VF_True_ECG2=ones(length(cur_type),1);
Flag_VF_True_ABP=ones(length(cur_type),1);
Flag_VF_True_PPG=ones(length(cur_type),1);
Flag_VF_True=ones(length(cur_type),1);
Flag_VF_True_ECG1_post=zeros(length(cur_type),1);
Flag_VF_True_ECG2_post=zeros(length(cur_type),1);
Flag_VF_True_ABP_post=ones(length(cur_type),1);
Flag_VF_True_PPG_post=ones(length(cur_type),1);

ECG1_be_PxxLoca=zeros(length(cur_type),1);
ECG2_be_PxxLoca=zeros(length(cur_type),1);


%% 
debug=0;
for m=1:length(cur_type)
% for m=55:55
    [aa,signal,Fs,siginfo]=rdmat(RECORDS{cur_type{m,2}});
    alarmResult=1;
    description=squeeze(struct2cell(siginfo));
    description=description(4,:);   % description = 'II'    'V'    'PLETH'    'RESP'   
    
     switch ALARMS{cur_type{m,2}}
        case 'Asystole'
            Num_beat_min=25;            
        case 'Bradycardia'
            Num_beat_min=19;                        
        case 'Tachycardia'
            Num_beat_min=30;            
        case 'Ventricular_Tachycardia'
            Num_beat_min=30;
        case 'Ventricular_Flutter_Fib'
            Num_beat_min=15; 
     end
     Num_beat_min_post=10;    
    
    % Resample signal to 125Hz
    Fs=Fs(1);
    if Fs~=125
        signal=resample(signal,125,Fs);
        Fs=125;
    end
    
    Flag_post=0;
    if size(signal,1)/Fs>300
        Flag_post=1;
    end
    
    start=(300-T_A_be)*Fs+1;  %
    tail=300*Fs;    
    
    %% read and process signals
    % read and process ECG signal
    ECG1=signal(:,1);
    ECG2=signal(:,2);
    
    ECG1_be=ECG1(start:tail);
    ECG2_be=ECG2(start:tail);
    
    [ECG1_be Flag_Exist_ECG1] = DetectNan(ECG1_be,T_A_be,Fs);
    [ECG2_be Flag_Exist_ECG2] = DetectNan(ECG2_be,T_A_be,Fs);

    if Flag_Exist_ECG1
        ECG1_be_fil=filtering(ECG1_be,5,45,Fs,1);
        ECG1_be_fil=polar2p(ECG1_be_fil,Fs,5);
        if strcmp(ALARMS{cur_type{m,2}},'Tachycardia') 
            ECG1_R_peak_M1=FindPeak_T(ECG1_be_fil,Fs);
        elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
            ECG1_R_peak_M1=FindPeak_VT(ECG1_be_fil,Fs);
        elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
            ECG1_R_peak_M1=FindPeak_VF(ECG1_be_fil,Fs);
        else
            ECG1_R_peak_M1=FindPeak1(ECG1_be_fil,Fs);
        end
    else
        ECG1_be_fil=ECG1_be;
        ECG1_R_peak_M1=[];
    end
    
    if Flag_Exist_ECG2
        ECG2_be_fil=filtering(ECG2_be,5,45,Fs,1);
        ECG2_be_fil=polar2p(ECG2_be_fil,Fs,5);
        if strcmp(ALARMS{cur_type{m,2}},'Tachycardia') 
            ECG2_R_peak_M1=FindPeak_T(ECG2_be_fil,Fs);
        elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
            ECG2_R_peak_M1=FindPeak_VT(ECG2_be_fil,Fs);
        elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
            ECG2_R_peak_M1=FindPeak_VF(ECG2_be_fil,Fs);
        else
            ECG2_R_peak_M1=FindPeak1(ECG2_be_fil,Fs);
        end
    else
        ECG2_be_fil=ECG2_be;
        ECG2_R_peak_M1=[];
    end
    
    Flag_DetAcc_ECG1=0;
    Flag_DetAcc_ECG2=0;
    
    if Flag_Exist_ECG1
        if length(ECG1_R_peak_M1)>Num_beat_min
            Flag_DetAcc_ECG1=1;
        end
    end
    
    if Flag_Exist_ECG2
        if length(ECG2_R_peak_M1)>Num_beat_min
            Flag_DetAcc_ECG2=1;
        end
    end
    
    if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
        if Flag_DetAcc_ECG1 && Flag_Exist_ECG1
            [Flag_DetAcc_ECG1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base]=DetAcc_VT(ECG1_be_fil,ECG1_R_peak_M1,Cons_tem_num,T_A_be,T_A,Fs);
        end
        if Flag_DetAcc_ECG2 && Flag_Exist_ECG2
            [Flag_DetAcc_ECG2,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base]=DetAcc_VT(ECG2_be_fil,ECG2_R_peak_M1,Cons_tem_num,T_A_be,T_A,Fs);
        end
    elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
         if Flag_DetAcc_ECG1 && Flag_Exist_ECG1
            [Flag_DetAcc_ECG1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base]=DetAcc_VF(ECG1_be_fil,ECG1_R_peak_M1,Cons_tem_num,T_A_be,T_A,Fs);           
%             ECG1_be_VF_Pxx=pburg(ECG1_be(end-Fs*T_A+1:end),4,[1000]);
%             ECG1_be_PxxLoca(m)=find(ECG1_be_VF_Pxx==max(ECG1_be_VF_Pxx));
        end
        if Flag_DetAcc_ECG2 && Flag_Exist_ECG2
            [Flag_DetAcc_ECG2,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base]=DetAcc_VF(ECG2_be_fil,ECG2_R_peak_M1,Cons_tem_num,T_A_be,T_A,Fs);
%             ECG2_be_VF_Pxx=pburg(ECG2_be(end-Fs*T_A+1:end),4,[1000]);
%             ECG2_be_PxxLoca(m)=find(ECG2_be_VF_Pxx==max(ECG2_be_VF_Pxx));
        end
    elseif strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
        if Flag_DetAcc_ECG1 && Flag_Exist_ECG1
            [Flag_DetAcc_ECG1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base]=DetAcc_T_ECG(ECG1_be_fil,ECG1_R_peak_M1,Cons_tem_num,Fs);
        end
        if Flag_DetAcc_ECG2 && Flag_Exist_ECG2
            [Flag_DetAcc_ECG2,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base]=DetAcc_T_ECG(ECG2_be_fil,ECG2_R_peak_M1,Cons_tem_num,Fs);
        end
    else
        if Flag_DetAcc_ECG1 && Flag_Exist_ECG1
            [Flag_DetAcc_ECG1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base]=DetAcc(ECG1_be_fil,ECG1_R_peak_M1,Cons_tem_num,Fs);
        end
        if Flag_DetAcc_ECG2 && Flag_Exist_ECG2
            [Flag_DetAcc_ECG2,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base]=DetAcc(ECG2_be_fil,ECG2_R_peak_M1,Cons_tem_num,Fs);
        end
    end
    
    if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')        
        if Flag_DetAcc_ECG1 && Flag_DetAcc_ECG2
            if ECG1_HR_base/ECG2_HR_base > 3/2 || ECG1_HR_base/ECG2_HR_base < 2/3
                hr_diff=[abs(ECG1_HR_base-100) abs(ECG2_HR_base-100)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_ECG2=0;
                else
                    Flag_DetAcc_ECG1=0;
                end
            end
        end
    else
         if Flag_DetAcc_ECG1 && Flag_DetAcc_ECG2
            if ECG1_HR_base/ECG2_HR_base > 3/2 || ECG1_HR_base/ECG2_HR_base < 2/3
                hr_diff=[abs(ECG1_HR_base-75) abs(ECG2_HR_base-75)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_ECG2=0;
                else
                    Flag_DetAcc_ECG1=0;
                end
            end
        end 
    end
      
    switch ALARMS{cur_type{m,2}}
        case 'Asystole'
            if Flag_DetAcc_ECG1
                Flag_A_True_ECG1(m)=Determine_A(ECG1_be_fil,ECG1_R_peak_M1,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);
            end
            if Flag_DetAcc_ECG2
                Flag_A_True_ECG2(m)=Determine_A(ECG2_be_fil,ECG2_R_peak_M1,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
            end            
        case 'Bradycardia'
            if Flag_DetAcc_ECG1
                [Flag_B_True_ECG1(m),ECG1_B_HR]=Determine_B(ECG1_be_fil,ECG1_R_peak_M1,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);                
            end
            if Flag_DetAcc_ECG2
                [Flag_B_True_ECG2(m),ECG2_B_HR]=Determine_B(ECG2_be_fil,ECG2_R_peak_M1,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
            end            
        case 'Tachycardia'
            if Flag_DetAcc_ECG1
                Flag_T_True_ECG1(m)=Determine_T_ECG(ECG1_be_fil,ECG1_R_peak_M1,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);                
            end
            if Flag_DetAcc_ECG2
                Flag_T_True_ECG2(m)=Determine_T_ECG(ECG2_be_fil,ECG2_R_peak_M1,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
            end            
        case 'Ventricular_Tachycardia'
            ECG1_Corr0=0;
            ECG1_Corr=[];
            ECG1_Shape_change=[];
            ECG1_VT_HR=[];
            if Flag_DetAcc_ECG1
                [Flag_VT_True_ECG1(m),ECG1_Corr0,ECG1_Corr,ECG1_Shape_change,ECG1_VT_HR]=Determine_VT_ECG(ECG1_be_fil,ECG1_R_peak_M1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);                
            end
            ECG2_Corr0=0;
            ECG2_Corr=[];
            ECG2_Shape_change=[];
            ECG2_VT_HR=[];
            if Flag_DetAcc_ECG2
                [Flag_VT_True_ECG2(m),ECG2_Corr0,ECG2_Corr,ECG2_Shape_change,ECG2_VT_HR]=Determine_VT_ECG(ECG2_be_fil,ECG2_R_peak_M1,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
            end 
        case 'Ventricular_Flutter_Fib'
            ECG1_Corr0=0;
            if Flag_DetAcc_ECG1
                [Flag_VF_True_ECG1(m),ECG1_Corr0,ECG1_Shape_change,ECG1_VF_HR]=Determine_VF_ECG(ECG1_be_fil,ECG1_R_peak_M1,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);                
            end
            ECG2_Corr0=0;
            if Flag_DetAcc_ECG2
                [Flag_VF_True_ECG2(m),ECG2_Corr0,ECG2_Shape_change,ECG2_VF_HR]=Determine_VF_ECG(ECG2_be_fil,ECG2_R_peak_M1,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
            end 
    end
   
    data_be=[ECG1_be ECG2_be];
    data_be_fil=[ECG1_be_fil ECG2_be_fil];
    data_channel={'ECG1';'ECG2'};
    
        
    if Flag_post
        ECG1_post=ECG1(tail+1:end);
        ECG2_post=ECG2(tail+1:end);
        
        [ECG1_post Flag_Exist_ECG1_post] = DetectNan(ECG1_post,T_A_post,Fs);
        [ECG2_post Flag_Exist_ECG2_post] = DetectNan(ECG2_post,T_A_post,Fs);
   
         if Flag_Exist_ECG1_post
            ECG1_post_fil=filtering(ECG1_post,5,45,Fs,1);
            ECG1_post_fil=polar2p(ECG1_post_fil,Fs,5);
            if strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
                ECG1_R_peak_post=FindPeak_T(ECG1_post_fil,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
                ECG1_R_peak_post=FindPeak_VT(ECG1_post_fil,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
                ECG1_R_peak_post=FindPeak_VF(ECG1_post_fil,Fs);
            else
                ECG1_R_peak_post=FindPeak1(ECG1_post_fil,Fs);
            end
        else
            ECG1_post_fil=ECG1_post;
            ECG1_R_peak_post=[];
        end
        
        if Flag_Exist_ECG2_post
            ECG2_post_fil=filtering(ECG2_post,5,45,Fs,1);
            ECG2_post_fil=polar2p(ECG2_post_fil,Fs,5);
            if strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
                ECG2_R_peak_post=FindPeak_T(ECG2_post_fil,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
                ECG2_R_peak_post=FindPeak_VT(ECG2_post_fil,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
                ECG2_R_peak_post=FindPeak_VF(ECG2_post_fil,Fs);
            else
                ECG2_R_peak_post=FindPeak1(ECG2_post_fil,Fs);
            end
        else
            ECG2_post_fil=ECG2_post;
            ECG2_R_peak_post=[];
        end
        
        Flag_DetAcc_ECG1_post=0;
        Flag_DetAcc_ECG2_post=0;
        
        if Flag_Exist_ECG1_post
            if length(ECG1_R_peak_post)>Num_beat_min_post
                Flag_DetAcc_ECG1_post=1;
            end
        end
        
        if Flag_Exist_ECG2_post
            if length(ECG2_R_peak_post)>Num_beat_min_post
                Flag_DetAcc_ECG2_post=1;
            end
        end
        
        switch ALARMS{cur_type{m,2}}
            case 'Asystole'
                if Flag_DetAcc_ECG1_post && Flag_Exist_ECG1_post
                    [Flag_DetAcc_ECG1_post,ECG1_template_post,ECG1_HR_base_post,ECG1_Range_base_post,ECG1_Amp_base_post]=DetAcc_post(ECG1_post_fil,ECG1_R_peak_post,Cons_tem_num,Fs);
                end
                if Flag_DetAcc_ECG2_post && Flag_Exist_ECG2_post
                    [Flag_DetAcc_ECG2_post,ECG2_template_post,ECG2_HR_base_post,ECG2_Range_base_post,ECG2_Amp_base_post]=DetAcc_post(ECG2_post_fil,ECG2_R_peak_post,Cons_tem_num,Fs);
                end
                
                if Flag_DetAcc_ECG1_post && Flag_DetAcc_ECG1                    
                    Flag_A_True_ECG1_post(m)=Determine_A_post(ECG1_HR_base,ECG1_Range_base,ECG1_HR_base_post,ECG1_Range_base_post);              
                end
                if Flag_DetAcc_ECG2_post && Flag_DetAcc_ECG2                    
                    Flag_A_True_ECG2_post(m)=Determine_A_post(ECG2_HR_base,ECG2_Range_base,ECG2_HR_base_post,ECG2_Range_base_post);
                end
                
            case 'Bradycardia'
                if Flag_DetAcc_ECG1_post && Flag_Exist_ECG1_post
                    [Flag_DetAcc_ECG1_post,ECG1_template_post,ECG1_HR_base_post,ECG1_Range_base_post,ECG1_Amp_base_post]=DetAcc_post(ECG1_post_fil,ECG1_R_peak_post,Cons_tem_num,Fs);
                end
                if Flag_DetAcc_ECG2_post && Flag_Exist_ECG2_post
                    [Flag_DetAcc_ECG2_post,ECG2_template_post,ECG2_HR_base_post,ECG2_Range_base_post,ECG2_Amp_base_post]=DetAcc_post(ECG2_post_fil,ECG2_R_peak_post,Cons_tem_num,Fs);
                end
                
                if Flag_DetAcc_ECG1_post && Flag_DetAcc_ECG1
                    Flag_B_True_ECG1_post(m)=Determine_B_post(ECG1_post_fil,ECG1_R_peak_post,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,Fs);
                end
                if Flag_DetAcc_ECG2_post && Flag_DetAcc_ECG2
                    Flag_B_True_ECG2_post(m)=Determine_B_post(ECG2_post_fil,ECG2_R_peak_post,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,Fs);
                end
                
            case 'Tachycardia'
%                 if Flag_DetAcc_ECG1
%                     Flag_T_True_ECG1(m)=Determine_T_ECG(ECG1_be_fil,ECG1_R_peak_M1,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,T_A_be,T_A,Fs);
%                 end
%                 if Flag_DetAcc_ECG2
%                     Flag_T_True_ECG2(m)=Determine_T_ECG(ECG2_be_fil,ECG2_R_peak_M1,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,T_A_be,T_A,Fs);
%                 end
            case 'Ventricular_Tachycardia'
                if Flag_DetAcc_ECG1_post && Flag_Exist_ECG1_post
                    [Flag_DetAcc_ECG1_post,ECG1_template_post,ECG1_HR_base_post,ECG1_Range_base_post,ECG1_Amp_base_post]=DetAcc_VT_post(ECG1_post_fil,ECG1_R_peak_post,Cons_tem_num,Fs);
                end
                if Flag_DetAcc_ECG2_post && Flag_Exist_ECG2_post
                    [Flag_DetAcc_ECG2_post,ECG2_template_post,ECG2_HR_base_post,ECG2_Range_base_post,ECG2_Amp_base_post]=DetAcc_VT_post(ECG2_post_fil,ECG2_R_peak_post,Cons_tem_num,Fs);
                end
                ECG1_Corr0_post=0;
                if Flag_DetAcc_ECG1_post && Flag_DetAcc_ECG1
                    [Flag_VT_True_ECG1_post(m),ECG1_Corr0_post,ECG1_VT_HR_post]=Determine_VT_ECG_post(ECG1_post_fil,ECG1_R_peak_post,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,Fs);
                end
                ECG2_Corr0_post=0;
                if Flag_DetAcc_ECG2_post && Flag_DetAcc_ECG2
                    [Flag_VT_True_ECG2_post(m),ECG2_Corr0_post,ECG2_VT_HR_post]=Determine_VT_ECG_post(ECG2_post_fil,ECG2_R_peak_post,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,Fs);
                end
            case 'Ventricular_Flutter_Fib'
                if Flag_DetAcc_ECG1_post && Flag_Exist_ECG1_post
                    [Flag_DetAcc_ECG1_post,ECG1_template_post,ECG1_HR_base_post,ECG1_Range_base_post,ECG1_Amp_base_post]=DetAcc_VF_post(ECG1_post_fil,ECG1_R_peak_post,Cons_tem_num,Fs);
                end
                if Flag_DetAcc_ECG2_post && Flag_Exist_ECG2_post
                    [Flag_DetAcc_ECG2_post,ECG2_template_post,ECG2_HR_base_post,ECG2_Range_base_post,ECG2_Amp_base_post]=DetAcc_VF_post(ECG2_post_fil,ECG2_R_peak_post,Cons_tem_num,Fs);
                end
                ECG1_Corr0_post=0;
                if Flag_DetAcc_ECG1_post && Flag_DetAcc_ECG1
                    [Flag_VF_True_ECG1_post(m),ECG1_Corr0_post,ECG1_Shape_change_post,ECG1_VF_HR_post]=Determine_VF_ECG_post(ECG1_post_fil,ECG1_R_peak_post,ECG1_template,ECG1_HR_base,ECG1_Range_base,ECG1_Amp_base,Fs);
                end
                ECG2_Corr0_post=0;
                if Flag_DetAcc_ECG2_post && Flag_DetAcc_ECG2
                    [Flag_VF_True_ECG2_post(m),ECG2_Corr0_post,ECG2_Shape_change_post,ECG2_VF_HR_post]=Determine_VF_ECG_post(ECG2_post_fil,ECG2_R_peak_post,ECG2_template,ECG2_HR_base,ECG2_Range_base,ECG2_Amp_base,Fs);
                end
        end          
        
        data_post=[ECG1_post ECG2_post];
        data_post_fil=[ECG1_post_fil ECG2_post_fil];
    end
    
    % read and process ABP signal if exist
    ABP_ind=get_index(description,'ABP');
    if(~isempty(ABP_ind))
        ABP_be=signal(start:tail,ABP_ind);
        ABP_be_fil=filtering(ABP_be,5,35,Fs,1);
        ABP_foot=wabp(ABP_be_fil,0,1);
        
        if strcmp(ALARMS{cur_type{m,2}},'Bradycardia') || strcmp(ALARMS{cur_type{m,2}},'Tachycardia') || strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib') || strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
            abp=signal(:,ABP_ind);
            ann_abp=wabp(signal(:,ABP_ind),0,1);
            if length(ann_abp)>=3 % at least 3 abp beats detected
                [features] = abpfeature(signal(:,ABP_ind),ann_abp);
                [BEATQ R] = jSQI(features, ann_abp, signal(:,ABP_ind));
            end          
                     
            N_d=Fs*5*60; % alarm position
            N0_d=N_d-Fs*16+1; % 16s before the alarm
            % select the beats in the segment
            n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
            
            if length(ann_abp)>=3 && ~isempty(BEATQ)
                abpsqi=1-sum(sum(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:)))/numel(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:));
            else
                abpsqi=0;
            end
            
            if length(n_abp_beats)>=2
                hr_max_abp=60*Fs/min(diff(ann_abp(n_abp_beats)));
            else 
                hr_max_abp=0;
            end
            % calculate low heart rate of 5 consecutive beats for Bradycardia
            low_hr_abp=NaN;            
            if length(n_abp_beats>=5)
                for i=1:length(n_abp_beats)-4
                    low_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+4))-ann_abp(n_abp_beats(i)))/4);
                end
            end
            low_hr_abp=min(low_hr_abp);
            % calculate high heart reate of 17 consecutive beats for Tachycardia
            high_hr_abp=NaN;
            if length(n_abp_beats>=17)
                for i=1:length(n_abp_beats)-16
                    high_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+16))-ann_abp(n_abp_beats(i)))/16);
                end
            end
            high_hr_abp=max(high_hr_abp);
        end        
        
        Flag_DetAcc_ABP=0;
        if length(ABP_foot)>Num_beat_min
            Flag_DetAcc_ABP=1;
        end
        if Flag_DetAcc_ABP
            if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
                [Flag_DetAcc_ABP,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base]=DetAcc_VT(ABP_be_fil,ABP_foot,Cons_tem_num,T_A_be,T_A,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
                [Flag_DetAcc_ABP,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base]=DetAcc_VF(ABP_be_fil,ABP_foot,Cons_tem_num,T_A_be,T_A,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
                [Flag_DetAcc_ABP,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base]=DetAcc_T_Pulse(ABP_be_fil,ABP_foot,Cons_tem_num,Fs);
            else
                [Flag_DetAcc_ABP,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base]=DetAcc_pulse(ABP_be_fil,ABP_foot,Cons_tem_num,Fs);
            end
        end
        
        if Flag_DetAcc_ECG1 && Flag_DetAcc_ABP
            if ECG1_HR_base/ABP_HR_base > 3/2 || ECG1_HR_base/ABP_HR_base < 2/3
                hr_diff=[abs(ECG1_HR_base-75) abs(ABP_HR_base-75)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_ABP=0;
                end
            end
        end
        
        if Flag_DetAcc_ECG2 && Flag_DetAcc_ABP
            if ECG2_HR_base/ABP_HR_base > 3/2 || ECG2_HR_base/ABP_HR_base < 2/3
                hr_diff=[abs(ECG2_HR_base-75) abs(ABP_HR_base-75)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_ABP=0;
                end
            end
        end        
        
        if Flag_DetAcc_ABP
            switch ALARMS{cur_type{m,2}}
                case 'Asystole'
                    Flag_A_True_ABP(m)=Determine_A(ABP_be_fil,ABP_foot,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,Fs);
                case 'Bradycardia'
                    Flag_B_True_ABP(m)=Determine_B_Pulse(ABP_be_fil,ABP_foot,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,abpsqi,Fs);
                case 'Tachycardia'
                    Flag_T_True_ABP(m)=Determine_T_Pulse(ABP_be_fil,ABP_foot,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,Fs);
                case 'Ventricular_Tachycardia'
                    [Flag_VT_True_ABP(m),ABP_Corr0]=Determine_VT_Pulse(ABP_be_fil,ABP_foot,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,Fs);
                case 'Ventricular_Flutter_Fib'
                    [Flag_VF_True_ABP(m),ABP_Corr0]=Determine_VF_Pulse(ABP_be_fil,ABP_foot,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,Fs);
            end
        end
        
        data_be=[data_be ABP_be];
        data_be_fil=[data_be_fil ABP_be_fil];
        data_channel=[data_channel;'ABP'];
        
        if Flag_post
            ABP_post=signal(tail+1:end,ABP_ind);
            ABP_post_fil=filtering(ABP_post,5,35,Fs,1);
            ABP_foot_post=wabp(ABP_post_fil,0,1);

            Flag_DetAcc_ABP_post=0;
            if length(ABP_foot_post)>Num_beat_min_post
                Flag_DetAcc_ABP_post=1;
            end
            if Flag_DetAcc_ABP_post
               switch ALARMS{cur_type{m,2}}
                    case 'Asystole'
                        [Flag_DetAcc_ABP_post,ABP_template_post,ABP_HR_base_post,ABP_Range_base_post,ABP_Amp_base_post]=DetAcc_post(ABP_post_fil,ABP_foot_post,Cons_tem_num,Fs);
                        Flag_A_True_ABP_post(m)=Determine_A_post(ABP_HR_base,ABP_Range_base,ABP_HR_base_post,ABP_Range_base_post);
                        
                    case 'Bradycardia'
                        [Flag_DetAcc_ABP_post,ABP_template_post,ABP_HR_base_post,ABP_Range_base_post,ABP_Amp_base_post]=DetAcc_post(ABP_post_fil,ABP_foot_post,Cons_tem_num,Fs);
                        Flag_B_True_ABP_post(m)=Determine_B_post(ABP_post_fil,ABP_foot_post,ABP_HR_base,ABP_Range_base,ABP_Amp_base,Fs);
                        
                    case 'Tachycardia'
%                         Flag_T_True_ABP(m)=Determine_T_Pulse(ABP_be_fil,ABP_foot,ABP_HR_base,ABP_Range_base,ABP_Amp_base,T_A_be,T_A,Fs);
                    case 'Ventricular_Tachycardia'
                        [Flag_DetAcc_ABP_post,ABP_template_post,ABP_HR_base_post,ABP_Range_base_post,ABP_Amp_base_post]=DetAcc_VT_post(ABP_post_fil,ABP_foot_post,Cons_tem_num,Fs);
                        [Flag_VT_True_ABP_post(m),ABP_Corr0_post]=Determine_VT_Pulse_post(ABP_post_fil,ABP_foot_post,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base,Fs);
                    case 'Ventricular_Flutter_Fib'
                        [Flag_DetAcc_ABP_post,ABP_template_post,ABP_HR_base_post,ABP_Range_base_post,ABP_Amp_base_post]=DetAcc_VF_post(ABP_post_fil,ABP_foot_post,Cons_tem_num,Fs);
                        [Flag_VF_True_ABP_post(m),ABP_Corr0_post]=Determine_VF_Pulse_post(ABP_post_fil,ABP_foot_post,ABP_template,ABP_HR_base,ABP_Range_base,ABP_Amp_base,Fs);
                end
            end
            
            data_post=[data_post ABP_post];
            data_post_fil=[data_post_fil ABP_post_fil];
        end
    end
    
    % read and process PPG signal if exist
    PPG_ind=get_index(description,'PLETH');
    if (~isempty(PPG_ind))
        PPG_be=signal(start:tail,PPG_ind);
        PPG_be_fil=filtering(PPG_be,5,35,Fs,1);
        y=quantile(PPG_be_fil,[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,PPG_ind)
        PPG_foot=wabp(PPG_be_fil,0,(y(3)-y(1))/120);
        
        if strcmp(ALARMS{cur_type{m,2}},'Bradycardia')   || strcmp(ALARMS{cur_type{m,2}},'Tachycardia')  || strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')  ||  strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')      
            ppg=signal(:,PPG_ind);
            y=quantile(signal(:,PPG_ind),[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,ppg_ind)
            ann_ppg=wabp(signal(:,PPG_ind),0,(y(3)-y(1))/120);
            if ~isempty(ann_ppg)
                [psqi]=ppgSQI(signal(:,PPG_ind),ann_ppg);
            end
            N_d=Fs*5*60; % alarm position
            N0_d=N_d-Fs*16+1; % 16s before the alarm            
            n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d)); 
            
            if ~isempty(ann_ppg)
                ppgsqi=mean(psqi(intersect(n_ppg_beats,1:length(psqi))));  % intersect: get the intersection of two sets
            else
                ppgsqi=0;
            end  
            
            if length(n_ppg_beats)>=2
                hr_max_ppg=60*Fs/min(diff(ann_ppg(n_ppg_beats)));
            else
                hr_max_ppg=0;
            end
            % calculate low heart rate of 5 consecutive beats for Bradycardia
            low_hr_ppg=NaN;
            if length(n_ppg_beats>=5)
                for i=1:length(n_ppg_beats)-4
                    low_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+4))-ann_ppg(n_ppg_beats(i)))/4);
                end
            end
            low_hr_ppg=min(low_hr_ppg);           
             % calculate high heart reate of 17 consecutive beats for Tachycardia
            high_hr_ppg=NaN;            
            if length(n_ppg_beats>=17)
                for i=1:length(n_ppg_beats)-16
                    high_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+16))-ann_ppg(n_ppg_beats(i)))/16);
                end
            end
            high_hr_ppg=max(high_hr_ppg);           
        end       
        
        Flag_DetAcc_PPG=0;
        if length(PPG_foot)>Num_beat_min
            Flag_DetAcc_PPG=1;
        end
        if Flag_DetAcc_PPG
            if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
                [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_VT(PPG_be_fil,PPG_foot,Cons_tem_num,T_A_be,T_A,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
                [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_VF(PPG_be_fil,PPG_foot,Cons_tem_num,T_A_be,T_A,Fs);
            elseif strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
                [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_T_Pulse(PPG_be_fil,PPG_foot,Cons_tem_num,Fs);
            else
                [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_pulse(PPG_be_fil,PPG_foot,Cons_tem_num,Fs);
            end
        end
        
        if Flag_DetAcc_ECG1 && Flag_DetAcc_PPG
            if ECG1_HR_base/PPG_HR_base > 3/2 || ECG1_HR_base/PPG_HR_base < 2/3
                hr_diff=[abs(ECG1_HR_base-75) abs(PPG_HR_base-75)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_PPG=0;
                end
            end
        end
        
        if Flag_DetAcc_ECG2 && Flag_DetAcc_PPG
            if ECG2_HR_base/PPG_HR_base > 3/2 || ECG2_HR_base/PPG_HR_base < 2/3
                hr_diff=[abs(ECG2_HR_base-75) abs(PPG_HR_base-75)];
                if hr_diff(1)<hr_diff(2)
                    Flag_DetAcc_PPG=0;
                end
            end
        end        
        
        if Flag_DetAcc_PPG
            switch ALARMS{cur_type{m,2}}
                case 'Asystole'
                    Flag_A_True_PPG(m)=Determine_A(PPG_be_fil,PPG_foot,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,Fs);
                case 'Bradycardia'
                    Flag_B_True_PPG(m)=Determine_B_Pulse(PPG_be_fil,PPG_foot,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,ppgsqi,Fs);
                case 'Tachycardia'
                    Flag_T_True_PPG(m)=Determine_T_Pulse(PPG_be_fil,PPG_foot,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,Fs);
                case 'Ventricular_Tachycardia'
                    [Flag_VT_True_PPG(m),PPG_Corr0]=Determine_VT_Pulse(PPG_be_fil,PPG_foot,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,Fs);
                case 'Ventricular_Flutter_Fib'
                    [Flag_VF_True_PPG(m),PPG_Corr0]=Determine_VF_Pulse(PPG_be_fil,PPG_foot,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,Fs);
            end
        end
        
        data_be=[data_be PPG_be];
        data_be_fil=[data_be_fil PPG_be_fil];
        data_channel=[data_channel;'PPG'];
                
        if Flag_post
            PPG_post=signal(tail+1:end,PPG_ind);
            PPG_post_fil=filtering(PPG_post,5,35,Fs,1);
            y=quantile(PPG_post_fil,[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,PPG_ind)
            PPG_foot_post=wabp(PPG_post_fil,0,(y(3)-y(1))/120);
       
            
            Flag_DetAcc_PPG_post=0;
            if length(PPG_foot_post)>Num_beat_min_post
                Flag_DetAcc_PPG_post=1;
            end
            if Flag_DetAcc_PPG_post
%                 if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Tachycardia')
%                     [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_VT(PPG_be_fil,PPG_foot,Cons_tem_num,T_A_be,T_A,Fs);
%                 elseif strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib')
%                     [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_VF(PPG_be_fil,PPG_foot,Cons_tem_num,T_A_be,T_A,Fs);
%                 elseif strcmp(ALARMS{cur_type{m,2}},'Tachycardia')
%                     [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc_T_Pulse(PPG_be_fil,PPG_foot,Cons_tem_num,Fs);
%                 else
%                     [Flag_DetAcc_PPG,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base]=DetAcc(PPG_be_fil,PPG_foot,Cons_tem_num,Fs);
%                 end
%             end
                switch ALARMS{cur_type{m,2}}
                    case 'Asystole'
                        [Flag_DetAcc_PPG_post,PPG_template_post,PPG_HR_base_post,PPG_Range_base_post,PPG_Amp_base_post]=DetAcc_post(PPG_post_fil,PPG_foot_post,Cons_tem_num,Fs);
                        Flag_A_True_PPG_post(m)=Determine_A_post(PPG_HR_base,PPG_Range_base,PPG_HR_base_post,PPG_Range_base_post);
                    case 'Bradycardia'
                        [Flag_DetAcc_PPG_post,PPG_template_post,PPG_HR_base_post,PPG_Range_base_post,PPG_Amp_base_post]=DetAcc_post(PPG_post_fil,PPG_foot_post,Cons_tem_num,Fs);
                        Flag_B_True_PPG_post(m)=Determine_B_post(PPG_post_fil,PPG_foot_post,PPG_HR_base,PPG_Range_base,PPG_Amp_base,Fs);
                    case 'Tachycardia'
%                         Flag_T_True_PPG(m)=Determine_T_Pulse(PPG_be_fil,PPG_foot,PPG_HR_base,PPG_Range_base,PPG_Amp_base,T_A_be,T_A,Fs);
                    case 'Ventricular_Tachycardia'
                        [Flag_DetAcc_PPG_post,PPG_template_post,PPG_HR_base_post,PPG_Range_base_post,PPG_Amp_base_post]=DetAcc_VT_post(PPG_post_fil,PPG_foot_post,Cons_tem_num,Fs);
                        [Flag_VT_True_PPG_post(m),PPG_Corr0_post]=Determine_VT_Pulse_post(PPG_post_fil,PPG_foot_post,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base,Fs);
                    case 'Ventricular_Flutter_Fib'
                        [Flag_DetAcc_PPG_post,PPG_template_post,PPG_HR_base_post,PPG_Range_base_post,PPG_Amp_base_post]=DetAcc_VF_post(PPG_post_fil,PPG_foot_post,Cons_tem_num,Fs);
                        [Flag_VF_True_PPG_post(m),PPG_Corr0_post]=Determine_VF_Pulse_post(PPG_post_fil,PPG_foot_post,PPG_template,PPG_HR_base,PPG_Range_base,PPG_Amp_base,Fs);
                end
            end
            
            data_post=[data_post PPG_post];
            data_post_fil=[data_post_fil PPG_post_fil];
        end
    end   
    
    %% special processing for VF
    if strcmp(ALARMS{cur_type{m,2}},'Ventricular_Flutter_Fib') && 0<1
        Segment_t=10;
        Segment_num=size(signal,1)/Fs/Segment_t;
        SampEn1_0=zeros(Segment_num,1);
        SampEn2_0=zeros(Segment_num,1);
        Sd_ECG1_0=ones(Segment_num,1)*1000;
        Sd_ECG2_0=ones(Segment_num,1)*1000;
        Sd_abp_0=ones(Segment_num,1)*1000;
        Sd_ppg_0=ones(Segment_num,1)*1000;
        Mean_ECG1_0=zeros(Segment_num,1);
        Mean_ECG2_0=zeros(Segment_num,1);
        PeakLoca1=[];
        PeakLoca2=[];
        PeakLoca1_cur=[];
        PeakLoca2_cur=[];
        cur_PeakLoca1=[];
        cur_PeakLoca2=[];
        cur_PeakLoca11=[];
        cur_PeakLoca22=[];
        Indx1=[];
        Indx2=[];
        SampEn_thr1=0.05;
        SampEn_thr2=1;
        for i=1:Segment_num
            SampEn1_0(i) = SampEn_fast(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,1), 2, 0.2);
            if SampEn1_0(i)>SampEn_thr1 & SampEn1_0(i)<SampEn_thr2
                cur_ECG10=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,1),1000,Fs);
                cur_ECG10 = wden(cur_ECG10, 'rigrsure', 's', 'mln', 3, 'coif5');
                [C, L] = wavedec(cur_ECG10, 6, 'coif5'); % about 8 Hz
                tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
                indf   = 1 + floor((length(tretp) - length(cur_ECG10))/2) - floor(1*length(wfilters('coif5')));
                cur_ECG10_tre = tretp(indf:indf + length(cur_ECG10) - 1);
                cur_ECG1 = cur_ECG10 - cur_ECG10_tre;
                cur_ECG1_sort=sort(cur_ECG1);
                m_high=mean(cur_ECG1_sort(end-Fs+1:end))-mean(cur_ECG1);
                m_low=mean(cur_ECG1)-mean(cur_ECG1_sort(1:Fs));
                if 1.5*m_high<m_low
                    cur_ECG1=-cur_ECG1;
                end
                PeakLoca1_cur = round(FindPeak0(cur_ECG1,1000)*Fs/1000);
                Sd_ECG1_0(i)=std(diff(PeakLoca1_cur));
                Mean_ECG1_0(i)=mean(diff(PeakLoca1_cur));
                PeakLoca1=[PeakLoca1;PeakLoca1_cur+Fs*Segment_t*(i-1)+1];
                Indx1=[Indx1;i];
            end
            
            SampEn2_0(i) = SampEn_fast(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,2), 2, 0.2);
            if SampEn2_0(i)>SampEn_thr1 & SampEn2_0(i)<SampEn_thr2
                cur_ECG20=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,2),1000,Fs);
                cur_ECG20 = wden(cur_ECG20, 'rigrsure', 's', 'mln', 3, 'coif5');
                [C, L] = wavedec(cur_ECG20, 6, 'coif5'); % about 8 Hz
                tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
                indf   = 1 + floor((length(tretp) - length(cur_ECG20))/2) - floor(1*length(wfilters('coif5')));
                cur_ECG20_tre = tretp(indf:indf + length(cur_ECG20) - 1);
                cur_ECG2 = cur_ECG20 - cur_ECG20_tre;
                cur_ECG2_sort=sort(cur_ECG2);
                m_high=mean(cur_ECG2_sort(end-Fs+1:end))-mean(cur_ECG2);
                m_low=mean(cur_ECG2)-mean(cur_ECG2_sort(1:Fs));
                if 1.5*m_high<m_low
                    cur_ECG2=-cur_ECG2;
                end
                PeakLoca2_cur = round(FindPeak0(cur_ECG2,1000)*Fs/1000);
                Sd_ECG2_0(i)=std(diff(PeakLoca2_cur));
                Mean_ECG2_0(i)=mean(diff(PeakLoca2_cur));
                PeakLoca2=[PeakLoca2;PeakLoca2_cur+Fs*Segment_t*(i-1)+1];
                Indx2=[Indx2;i];
            end
            SampEn1=round(mean(SampEn1_0)*100)/100;
            SampEn2=round(mean(SampEn2_0)*100)/100;
        end
        
        Flag_falsedet_thr=0.1;
        Amp_thr=2;
        HR_ECG1=NaN;
        Amp_ECG1=NaN;
        Flag_falsedet1=0;
        if (~isempty(PeakLoca1))
            if  PeakLoca1(end)>length(ECG1)
                PeakLoca1(end)=[];
            end
            [aa cur_indx1]=min(Sd_ECG1_0(1:300/Segment_t-1));
            if aa<1000
                cur_PeakLoca1=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(cur_indx1-1) & PeakLoca1<Fs*Segment_t*cur_indx1));
                ECG_template10=zeros(length(cur_PeakLoca1)-1,Fs);
                Distance1=zeros(length(cur_PeakLoca1)-1,length(cur_PeakLoca1)-1);
                for k=1:length(cur_PeakLoca1)-1
                    ECG_template10(k,:)=resample(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)),Fs,cur_PeakLoca1(k+1)-cur_PeakLoca1(k)+1);
                    Range(k)=max(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)))-min(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)));
                    for k2=1:length(cur_PeakLoca1)-1
                        Range(k2)=max(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)))-min(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)));
                        if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                            Distance1(k,k2)=1;
                        end
                    end
                end
                if sum(sum(Distance1))/(length(cur_PeakLoca1)-1).^2 <Flag_falsedet_thr
                    Flag_falsedet1=1;
                end
                ECG_template1=mean(ECG_template10);
                HR_ECG1=60*Fs/mean(diff(cur_PeakLoca1));
                Amp_ECG1=max(ECG_template1)-min(ECG_template1);
                
                cur_PeakLoca11=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(30-1) & PeakLoca1<Fs*Segment_t*30));
                ECG_Seg30_corr1=zeros(length(cur_PeakLoca11)-1,1);
                for k=1:length(cur_PeakLoca11)-1
                    cursig = resample(ECG1(cur_PeakLoca11(k):cur_PeakLoca11(k+1)),Fs,cur_PeakLoca11(k+1)-cur_PeakLoca11(k)+1);
                    xy = corrcoef(ECG_template1,cursig);
                    ECG_Seg30_corr1(k) = xy(2,1);
                end
                ECG_A_corr1=mean(abs(ECG_Seg30_corr1));
            end
        else ECG_A_corr1=0;
        end
        
        HR_ECG2=NaN;
        Amp_ECG2=NaN;
        Flag_falsedet2=0;
        if (~isempty(PeakLoca2))
            if  PeakLoca2(end)>length(ECG2)
                PeakLoca2(end)=[];
            end
            [aa cur_indx2]=min(Sd_ECG2_0(1:300/Segment_t-1));
            if aa<1000
                cur_PeakLoca2=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(cur_indx2-1) & PeakLoca2<Fs*Segment_t*cur_indx2));
                ECG_template20=zeros(length(cur_PeakLoca2)-1,Fs);
                Distance2=zeros(length(cur_PeakLoca2)-1,length(cur_PeakLoca2)-1);
                for k=1:length(cur_PeakLoca2)-1
                    ECG_template20(k,:)=resample(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)),Fs,cur_PeakLoca2(k+1)-cur_PeakLoca2(k)+1);
                    Range(k)=max(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)))-min(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)));
                    for k2=1:length(cur_PeakLoca2)-1
                        Range(k2)=max(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)))-min(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)));
                        if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                            Distance2(k,k2)=1;
                        end
                    end
                end
                if sum(sum(Distance2))/(length(cur_PeakLoca2)-1).^2 <Flag_falsedet_thr
                    Flag_falsedet2=1;
                end
                ECG_template2=mean(ECG_template20);
                HR_ECG2=60*Fs/mean(diff(cur_PeakLoca2));
                Amp_ECG2=max(ECG_template2)-min(ECG_template2);
                
                cur_PeakLoca22=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(30-1) & PeakLoca2<Fs*Segment_t*30));
                ECG_Seg30_corr2=zeros(length(cur_PeakLoca22)-1,1);
                for k=1:length(cur_PeakLoca22)-1
                    cursig = resample(ECG2(cur_PeakLoca22(k):cur_PeakLoca22(k+1)),Fs,cur_PeakLoca22(k+1)-cur_PeakLoca22(k)+1);
                    xy = corrcoef(ECG_template2,cursig);
                    ECG_Seg30_corr2(k) = xy(2,1);
                end
                ECG_A_corr2=mean(abs(ECG_Seg30_corr2));
            end
        else ECG_A_corr2=0;
        end
        
        Falg_ECG1_VF=0;
        Falg_ECG2_VF=0;
        
        N0_d_VF=Fs*(5*60-5);
        
        if Flag_falsedet1
            cur_data=ECG1(N0_d_VF+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG1*0.6);
            if length(find(diff(cur_index)>10))+1>12  && HR_ECG1>=VFB_th-20
                Falg_ECG1_VF=1;
            end
            
        end
        
        if Flag_falsedet2
            cur_data=ECG2(N0_d_VF+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG2*0.8);
            if length(find(diff(cur_index)>10))+1>12  && HR_ECG2>=VFB_th
                Falg_ECG2_VF=1;
            end
        end
    end
    
    
    %% Determination 
    sqi_th = 0.6;
    sqi_th_T = 0.85;
    sqi_th_VF = 0.6;
    BRA_th = 40;
    TAC_th = 80;
    VFB_th = 170;
    tolerance = 5;

    
    switch ALARMS{cur_type{m,2}}
        case 'Asystole'
            Flag_A_True(m)=~((~Flag_A_True_ECG1(m) && Flag_DetAcc_ECG1) || (~Flag_A_True_ECG2(m) &&  Flag_DetAcc_ECG2) || (~Flag_A_True_ABP(m) &&  Flag_DetAcc_ABP) || (~Flag_A_True_PPG(m) &&  Flag_DetAcc_PPG));
%              if Flag_post
%                  if (Flag_A_True_ECG1_post(m) && Flag_DetAcc_ECG1) || (Flag_A_True_ECG2_post(m) && Flag_DetAcc_ECG2) || (Flag_A_True_ABP_post(m) && Flag_DetAcc_ABP_post && Flag_DetAcc_ABP && ~Flag_A_True_ABP(m)) || (Flag_A_True_PPG_post(m) && Flag_DetAcc_PPG_post && Flag_DetAcc_PPG  && ~Flag_A_True_PPG(m))
%                      Flag_A_True(m)=0;
%                  end
%              end
        
        case 'Bradycardia'
            if(~isempty(ABP_ind))
                if abpsqi>=sqi_th && low_hr_abp-tolerance>BRA_th
                    Flag_B_True(m)=0;
                end
            end
            if(~isempty(PPG_ind))
                if ppgsqi>=sqi_th && low_hr_ppg-tolerance>BRA_th
                    Flag_B_True(m)=0;
                end
            end
                                 
%             Flag_B_True(m)=~((~Flag_B_True_ECG1(m) && Flag_DetAcc_ECG1) || (~Flag_B_True_ECG2(m) &&  Flag_DetAcc_ECG2) || (~Flag_B_True_ABP(m) &&  Flag_DetAcc_ABP) || (~Flag_B_True_PPG(m) &&  Flag_DetAcc_PPG));
%             if Flag_post
%                  if (Flag_B_True_ECG1_post(m) && Flag_DetAcc_ECG1) || (Flag_B_True_ECG2_post(m) && Flag_DetAcc_ECG2) || (Flag_B_True_ABP_post(m) && Flag_DetAcc_ABP_post && Flag_DetAcc_ABP && ~Flag_B_True_ABP(m)) || (Flag_B_True_PPG_post(m) && Flag_DetAcc_PPG_post && Flag_DetAcc_PPG  && ~Flag_B_True_PPG(m))
%                      Flag_B_True(m)=0;
%                  end
%              end
        
        case 'Tachycardia'
            Flag_T_True(m)=~((~Flag_T_True_ECG1(m) && Flag_DetAcc_ECG1) || (~Flag_T_True_ECG2(m) &&  Flag_DetAcc_ECG2) || (~Flag_T_True_ABP(m) &&  Flag_DetAcc_ABP) || (~Flag_T_True_PPG(m) &&  Flag_DetAcc_PPG));
            if (Flag_T_True_ECG1(m) && Flag_DetAcc_ECG1 && ECG1_HR_base>110) || (Flag_T_True_ECG2(m) &&  Flag_DetAcc_ECG2 && ECG2_HR_base>110)
                Flag_T_True(m)=1;
            end
            if(~isempty(ABP_ind))
                if abpsqi>=sqi_th_T && high_hr_abp+tolerance<TAC_th && Flag_DetAcc_ABP
                    Flag_T_True(m)=0;
                end
            end
            if(~isempty(PPG_ind))
                if ppgsqi>=sqi_th_T && high_hr_ppg+tolerance<TAC_th  && Flag_DetAcc_PPG
                    Flag_T_True(m)=0;
                end
            end
            
        case 'Ventricular_Tachycardia'
            Flag_VT_True(m)=(Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && min(ECG1_Corr)<0.82 && max(ECG1_Corr)>0.9 && max(ECG1_Shape_change)>0.65) || (Flag_VT_True_ECG2(m) &&  Flag_DetAcc_ECG2 && min(ECG2_Corr)<0.82 && max(ECG2_Corr)>0.9 && max(ECG2_Shape_change)>0.65);
            %             if Flag_VT_True(m) && ~(Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2)
            %                 if (~Flag_VT_True_ABP(m) && Flag_DetAcc_ABP) || (~Flag_VT_True_PPG(m) &&  Flag_DetAcc_PPG)
            %                     Flag_VT_True(m)=0;
            %                 end
            %             end
            
%              if (~isempty(ABP_ind))
%                 if (Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && max(ECG1_VT_HR)-ECG1_HR_base>15  && max(ECG1_Corr)-min(ECG1_Corr)>0.15 && Flag_VT_True_ABP(m) && Flag_DetAcc_ABP) || (Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2 && max(ECG2_VT_HR)-ECG2_HR_base>15  && max(ECG2_Corr)-min(ECG2_Corr)>0.15 && Flag_VT_True_ABP(m) && Flag_DetAcc_ABP)
%                     Flag_VT_True(m)=1;
%                 end
%              end
%             
%              if (~isempty(PPG_ind))
%                  if (Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && max(ECG1_VT_HR)-ECG1_HR_base>15  && max(ECG1_Corr)-min(ECG1_Corr)>0.15 && Flag_VT_True_PPG(m) && Flag_DetAcc_PPG) || (Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2 && max(ECG2_VT_HR)-ECG2_HR_base>15  && max(ECG2_Corr)-min(ECG2_Corr)>0.15 && Flag_VT_True_PPG(m) && Flag_DetAcc_PPG)
%                      Flag_VT_True(m)=1;
%                  end
%              end
            
            if (~isempty(ABP_ind))
                if Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2 && Flag_VT_True_ABP(m) && Flag_DetAcc_ABP
                    Flag_VT_True(m)=1;
                end
            end
            
             if (~isempty(PPG_ind))
                if Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2 && Flag_VT_True_PPG(m) && Flag_DetAcc_PPG
                    Flag_VT_True(m)=1;
                end
             end
% 
            if Flag_VT_True_ECG1(m) && Flag_DetAcc_ECG1 && max(ECG1_VT_HR)-ECG1_HR_base>15  && max(ECG1_Corr)-min(ECG1_Corr)>0.15
                Flag_VT_True(m)=1;
            end
            
            if Flag_VT_True_ECG2(m) && Flag_DetAcc_ECG2 && max(ECG2_VT_HR)-ECG2_HR_base>15  && max(ECG2_Corr)-min(ECG2_Corr)>0.15
                Flag_VT_True(m)=1;
            end
%             %
            if debug
                if Flag_post
                    if ECG1_Corr0_post>0.92  || ECG2_Corr0_post>0.92
                        Flag_VT_True(m)=0;
                    end
                    [ECG1_Corr0 ECG2_Corr0 max(ECG1_VT_HR) max(ECG2_VT_HR) ECG1_Corr0_post ECG2_Corr0_post]
                    [ECG1_Corr';ECG2_Corr';ECG1_Shape_change';ECG2_Shape_change']
                    
                    
                else
                    [ECG1_Corr0 ECG2_Corr0 max(ECG1_VT_HR) max(ECG2_VT_HR)]
                     [ECG1_Corr';ECG2_Corr';ECG1_Shape_change';ECG2_Shape_change']
                end
            end
            
        case 'Ventricular_Flutter_Fib'           
            if (~isempty(ABP_ind))
                if (abpsqi>=sqi_th_VF && hr_max_abp+tolerance<VFB_th) || Falg_ECG1_VF || Falg_ECG2_VF
                    Flag_VF_True(m)=0;
                end
            end
            
            if (~isempty(PPG_ind))
                if (ppgsqi>=sqi_th_VF && hr_max_ppg+tolerance<VFB_th) || Falg_ECG1_VF || Falg_ECG2_VF
                    Flag_VF_True(m)=0;
                end
            end

    end
    
    %% plot signal and thier features
    if debug
        figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 12, 5.5]);
        switch ALARMS{cur_type{m,2}}
            case 'Asystole'                
                for j=1:size(data_be,2)
                    subplot(size(data_be,2),1,j)
                    plot((1:length(ECG1_be))/Fs+300-T_A_be,data_be_fil(:,j),'b-')
                    switch data_channel{j,:}
                        case 'ECG1'
                            hold on
                            plot((ECG1_R_peak_M1)/Fs+300-T_A_be,ECG1_be_fil(ECG1_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_A_True_ECG1(m)))})
                            
                        case 'ECG2'
                            hold on
                            plot((ECG2_R_peak_M1)/Fs+300-T_A_be,ECG2_be_fil(ECG2_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_A_True_ECG2(m)))})
                            
                        case 'ABP'
                            hold on
                            plot((ABP_foot)/Fs+300-T_A_be,ABP_be_fil(ABP_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_A_True_ABP(m)))})
                            
                        case 'PPG'
                            hold on
                            plot((PPG_foot)/Fs+300-T_A_be,PPG_be_fil(PPG_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_A_True_PPG(m)))})
                    end
                end
            case 'Bradycardia'                
                for j=1:size(data_be,2)
                    subplot(size(data_be,2),1,j)
                    plot((1:length(ECG1_be))/Fs+300-T_A_be,data_be_fil(:,j),'b-')
                    switch data_channel{j,:}
                        case 'ECG1'
                            hold on
                            plot((ECG1_R_peak_M1)/Fs+300-T_A_be,ECG1_be_fil(ECG1_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_B_True_ECG1(m)))})
                            
                        case 'ECG2'
                            hold on
                            plot((ECG2_R_peak_M1)/Fs+300-T_A_be,ECG2_be_fil(ECG2_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_B_True_ECG2(m)))})
                            
                        case 'ABP'
                            hold on
                            plot((ABP_foot)/Fs+300-T_A_be,ABP_be_fil(ABP_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_B_True_ABP(m)))})
                            
                        case 'PPG'
                            hold on
                            plot((PPG_foot)/Fs+300-T_A_be,PPG_be_fil(PPG_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_B_True_PPG(m)))})
                    end
                end
                
            case 'Tachycardia'
                for j=1:size(data_be,2)
                    subplot(size(data_be,2),1,j)
                    plot((1:length(ECG1_be))/Fs+300-T_A_be,data_be_fil(:,j),'b-')
                    switch data_channel{j,:}
                        case 'ECG1'
                            hold on
                            plot((ECG1_R_peak_M1)/Fs+300-T_A_be,ECG1_be_fil(ECG1_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_T_True_ECG1(m)))})
                            
                        case 'ECG2'
                            hold on
                            plot((ECG2_R_peak_M1)/Fs+300-T_A_be,ECG2_be_fil(ECG2_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_T_True_ECG2(m)))})
                            
                        case 'ABP'
                            hold on
                            plot((ABP_foot)/Fs+300-T_A_be,ABP_be_fil(ABP_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_T_True_ABP(m)))})
                            
                        case 'PPG'
                            hold on
                            plot((PPG_foot)/Fs+300-T_A_be,PPG_be_fil(PPG_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_T_True_PPG(m)))})
                    end
                end
                
            case 'Ventricular_Tachycardia'
                for j=1:size(data_be,2)
                    subplot(size(data_be,2),1,j)
                    plot((1:length(ECG1_be))/Fs+300-T_A_be,data_be_fil(:,j),'b-')
                    switch data_channel{j,:}
                        case 'ECG1'
                            hold on
                            plot((ECG1_R_peak_M1)/Fs+300-T_A_be,ECG1_be_fil(ECG1_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_VT_True_ECG1(m)))})
                            
                        case 'ECG2'
                            hold on
                            plot((ECG2_R_peak_M1)/Fs+300-T_A_be,ECG2_be_fil(ECG2_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_VT_True_ECG2(m)))})
                            
                        case 'ABP'
                            hold on
                            plot((ABP_foot)/Fs+300-T_A_be,ABP_be_fil(ABP_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_VT_True_ABP(m)))})
                            
                        case 'PPG'
                            hold on
                            plot((PPG_foot)/Fs+300-T_A_be,PPG_be_fil(PPG_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_VT_True_PPG(m)))})
                    end
                end
                
            case 'Ventricular_Flutter_Fib'
                 for j=1:size(data_be,2)
                    subplot(size(data_be,2),1,j)
                    plot((1:length(ECG1_be))/Fs+300-T_A_be,data_be_fil(:,j),'b-')
                    switch data_channel{j,:}
                        case 'ECG1'
                            hold on
                            plot((ECG1_R_peak_M1)/Fs+300-T_A_be,ECG1_be_fil(ECG1_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_VF_True_ECG1(m)))})
                            
                        case 'ECG2'
                            hold on
                            plot((ECG2_R_peak_M1)/Fs+300-T_A_be,ECG2_be_fil(ECG2_R_peak_M1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_VF_True_ECG2(m)))})
                            
                        case 'ABP'
                            hold on
                            plot((ABP_foot)/Fs+300-T_A_be,ABP_be_fil(ABP_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_VF_True_ABP(m)))})
                            
                        case 'PPG'
                            hold on
                            plot((PPG_foot)/Fs+300-T_A_be,PPG_be_fil(PPG_foot),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                            ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_VF_True_PPG(m)))})
                    end
                 end                
        end
        
        if Flag_post
            figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6.15, 5.5]);
            switch ALARMS{cur_type{m,2}}
                case 'Asystole'
                    for j=1:size(data_post,2)
                        subplot(size(data_post,2),1,j)
                        plot((1:length(ECG1_post))/Fs+300,data_post_fil(:,j),'b-')
                        switch data_channel{j,:}
                            case 'ECG1'
                                hold on
                                plot((ECG1_R_peak_post)/Fs+300,ECG1_post_fil(ECG1_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1_post)),strcat('True=',num2str(Flag_A_True_ECG1_post(m)))})
                                
                            case 'ECG2'
                                hold on
                                plot((ECG2_R_peak_post)/Fs+300,ECG2_post_fil(ECG2_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2_post)),strcat('True=',num2str(Flag_A_True_ECG2_post(m)))})
                                
                            case 'ABP'
                                hold on
                                plot((ABP_foot_post)/Fs+300,ABP_post_fil(ABP_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP_post)),strcat('True=',num2str(Flag_A_True_ABP_post(m)))})
                                
                            case 'PPG'
                                hold on
                                plot((PPG_foot_post)/Fs+300,PPG_post_fil(PPG_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG_post)),strcat('True=',num2str(Flag_A_True_PPG_post(m)))})
                        end
                    end
                    
                case 'Bradycardia'
                    for j=1:size(data_post,2)
                        subplot(size(data_post,2),1,j)
                        plot((1:length(ECG1_post))/Fs+300,data_post_fil(:,j),'b-')
                        switch data_channel{j,:}
                            case 'ECG1'
                                hold on
                                plot((ECG1_R_peak_post)/Fs+300,ECG1_post_fil(ECG1_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1_post)),strcat('True=',num2str(Flag_B_True_ECG1_post(m)))})
                                
                            case 'ECG2'
                                hold on
                                plot((ECG2_R_peak_post)/Fs+300,ECG2_post_fil(ECG2_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2_post)),strcat('True=',num2str(Flag_B_True_ECG2_post(m)))})
                                
                            case 'ABP'
                                hold on
                                plot((ABP_foot_post)/Fs+300,ABP_post_fil(ABP_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP_post)),strcat('True=',num2str(Flag_B_True_ABP_post(m)))})
                                
                            case 'PPG'
                                hold on
                                plot((PPG_foot_post)/Fs+300,PPG_post_fil(PPG_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG_post)),strcat('True=',num2str(Flag_B_True_PPG_post(m)))})
                        end
                    end
                    
                case 'Tachycardia'
                    for j=1:size(data_post,2)
                        subplot(size(data_post,2),1,j)
                        plot((1:length(ECG1_post))/Fs+300,data_post_fil(:,j),'b-')
                        switch data_channel{j,:}
                            case 'ECG1'
                                hold on
                                plot((ECG1_R_peak_post)/Fs+300,ECG1_post_fil(ECG1_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1)),strcat('True=',num2str(Flag_A_True_ECG1(m)))})
                                
                            case 'ECG2'
                                hold on
                                plot((ECG2_R_peak_post)/Fs+300,ECG2_post_fil(ECG2_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2)),strcat('True=',num2str(Flag_A_True_ECG2(m)))})
                                
                            case 'ABP'
                                hold on
                                plot((ABP_foot_post)/Fs+300,ABP_post_fil(ABP_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP)),strcat('True=',num2str(Flag_A_True_ABP(m)))})
                                
                            case 'PPG'
                                hold on
                                plot((PPG_foot_post)/Fs+300,PPG_post_fil(PPG_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG)),strcat('True=',num2str(Flag_A_True_PPG(m)))})
                        end
                    end
                    
                case 'Ventricular_Tachycardia'
                    for j=1:size(data_post,2)
                        subplot(size(data_post,2),1,j)
                        plot((1:length(ECG1_post))/Fs+300,data_post_fil(:,j),'b-')
                        switch data_channel{j,:}
                            case 'ECG1'
                                hold on
                                plot((ECG1_R_peak_post)/Fs+300,ECG1_post_fil(ECG1_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1_post)),strcat('True=',num2str(Flag_A_True_ECG1_post(m)))})
                                
                            case 'ECG2'
                                hold on
                                plot((ECG2_R_peak_post)/Fs+300,ECG2_post_fil(ECG2_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2_post)),strcat('True=',num2str(Flag_A_True_ECG2_post(m)))})
                                
                            case 'ABP'
                                hold on
                                plot((ABP_foot_post)/Fs+300,ABP_post_fil(ABP_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP_post)),strcat('True=',num2str(Flag_A_True_ABP_post(m)))})
                                
                            case 'PPG'
                                hold on
                                plot((PPG_foot_post)/Fs+300,PPG_post_fil(PPG_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG_post)),strcat('True=',num2str(Flag_A_True_PPG_post(m)))})
                        end
                    end
                    
                case 'Ventricular_Flutter_Fib'
                    for j=1:size(data_post,2)
                        subplot(size(data_post,2),1,j)
                        plot((1:length(ECG1_post))/Fs+300,data_post_fil(:,j),'b-')
                        switch data_channel{j,:}
                            case 'ECG1'
                                hold on
                                plot((ECG1_R_peak_post)/Fs+300,ECG1_post_fil(ECG1_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG1',strcat('DecAcc=',num2str(Flag_DetAcc_ECG1_post)),strcat('True=',num2str(Flag_A_True_ECG1_post(m)))})
                                
                            case 'ECG2'
                                hold on
                                plot((ECG2_R_peak_post)/Fs+300,ECG2_post_fil(ECG2_R_peak_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ECG2',strcat('DecAcc=',num2str(Flag_DetAcc_ECG2_post)),strcat('True=',num2str(Flag_A_True_ECG2_post(m)))})
                                
                            case 'ABP'
                                hold on
                                plot((ABP_foot_post)/Fs+300,ABP_post_fil(ABP_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'ABP',strcat('DecAcc=',num2str(Flag_DetAcc_ABP_post)),strcat('True=',num2str(Flag_A_True_ABP_post(m)))})
                                
                            case 'PPG'
                                hold on
                                plot((PPG_foot_post)/Fs+300,PPG_post_fil(PPG_foot_post),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
                                ylabel({'PPG',strcat('DecAcc=',num2str(Flag_DetAcc_PPG_post)),strcat('True=',num2str(Flag_A_True_PPG_post(m)))})
                        end
                    end
            end
        end
    end
end

%% claculate index
switch ALARMS{cur_type{m,2}}
    case 'Asystole'
        FP=sum(Flag_A_True(1:length(cur_type1)))/length(cur_type1);
        TN=(length(cur_type1)-sum(Flag_A_True(1:length(cur_type1))))/length(cur_type1);
        TP=sum(Flag_A_True(length(cur_type1)+1:length(cur_type)))/length(cur_type2);
        FN=(length(cur_type2)-sum(Flag_A_True(length(cur_type1)+1:length(cur_type))))/length(cur_type2);
        Score= (TP+TN)/(TP+TN+FP+5*FN);
        Index=[round(sum(Flag_A_True(length(cur_type1)+1:length(cur_type)))), round(length(cur_type2)-sum(Flag_A_True(length(cur_type1)+1:length(cur_type)))),round(sum(Flag_A_True(1:length(cur_type1)))), round(length(cur_type1)-sum(Flag_A_True(1:length(cur_type1)))), round(TP*100), round(FN*100),round(FP*100), round(TN*100),round(Score*100)]
        
    case 'Bradycardia'
        FP=sum(Flag_B_True(1:length(cur_type1)))/length(cur_type1);
        TN=(length(cur_type1)-sum(Flag_B_True(1:length(cur_type1))))/length(cur_type1);
        TP=sum(Flag_B_True(length(cur_type1)+1:length(cur_type)))/length(cur_type2);
        FN=(length(cur_type2)-sum(Flag_B_True(length(cur_type1)+1:length(cur_type))))/length(cur_type2);
        Score= (TP+TN)/(TP+TN+FP+5*FN);
        Index=[round(sum(Flag_B_True(length(cur_type1)+1:length(cur_type)))), round(length(cur_type2)-sum(Flag_B_True(length(cur_type1)+1:length(cur_type)))),round(sum(Flag_B_True(1:length(cur_type1)))), round(length(cur_type1)-sum(Flag_B_True(1:length(cur_type1)))), round(TP*100), round(FN*100),round(FP*100), round(TN*100),round(Score*100)]
        
    case 'Tachycardia'
         FP=sum(Flag_T_True(1:length(cur_type1)))/length(cur_type1);
        TN=(length(cur_type1)-sum(Flag_T_True(1:length(cur_type1))))/length(cur_type1);
        TP=sum(Flag_T_True(length(cur_type1)+1:length(cur_type)))/length(cur_type2);
        FN=(length(cur_type2)-sum(Flag_T_True(length(cur_type1)+1:length(cur_type))))/length(cur_type2);
        Score= (TP+TN)/(TP+TN+FP+5*FN);
        Index=[round(sum(Flag_T_True(length(cur_type1)+1:length(cur_type)))), round(length(cur_type2)-sum(Flag_T_True(length(cur_type1)+1:length(cur_type)))),round(sum(Flag_T_True(1:length(cur_type1)))), round(length(cur_type1)-sum(Flag_T_True(1:length(cur_type1)))), round(TP*100), round(FN*100),round(FP*100), round(TN*100),round(Score*100)]
      
    case 'Ventricular_Tachycardia'
         FP=sum(Flag_VT_True(1:length(cur_type1)))/length(cur_type1);
        TN=(length(cur_type1)-sum(Flag_VT_True(1:length(cur_type1))))/length(cur_type1);
        TP=sum(Flag_VT_True(length(cur_type1)+1:length(cur_type)))/length(cur_type2);
        FN=(length(cur_type2)-sum(Flag_VT_True(length(cur_type1)+1:length(cur_type))))/length(cur_type2);
        Score= (TP+TN)/(TP+TN+FP+5*FN);
        Index=[round(sum(Flag_VT_True(length(cur_type1)+1:length(cur_type)))), round(length(cur_type2)-sum(Flag_VT_True(length(cur_type1)+1:length(cur_type)))),round(sum(Flag_VT_True(1:length(cur_type1)))), round(length(cur_type1)-sum(Flag_VT_True(1:length(cur_type1)))), round(TP*100), round(FN*100),round(FP*100), round(TN*100),round(Score*100)]
      
    case 'Ventricular_Flutter_Fib'
         FP=sum(Flag_VF_True(1:length(cur_type1)))/length(cur_type1);
        TN=(length(cur_type1)-sum(Flag_VF_True(1:length(cur_type1))))/length(cur_type1);
        TP=sum(Flag_VF_True(length(cur_type1)+1:length(cur_type)))/length(cur_type2);
        FN=(length(cur_type2)-sum(Flag_VF_True(length(cur_type1)+1:length(cur_type))))/length(cur_type2);
        Score= (TP+TN)/(TP+TN+FP+5*FN);
        Index=[round(sum(Flag_VF_True(length(cur_type1)+1:length(cur_type)))), round(length(cur_type2)-sum(Flag_VF_True(length(cur_type1)+1:length(cur_type)))),round(sum(Flag_VF_True(1:length(cur_type1)))), round(length(cur_type1)-sum(Flag_VF_True(1:length(cur_type1)))), round(TP*100),round(FN*100), round(FP*100), round(TN*100),round(Score*100)]
      
end







    
    
    %
    %
    %     %Run WABP on the record, which by default will analyze the first ABP, ART, or BP signal
    %     N=[];
    %     N0=[];
    %     abp_ind=get_index(description,'ABP');
    %     ann_abp=[];
    %     features=[];
    %     BEATQ=[];
    %     R=[];
    %     HR_abp=NaN;
    %     Amp_abp=NaN;
    %     Flag_falsedet_abp=0;
    %     if(~isempty(abp_ind))
    %         abp=signal(:,abp_ind);
    %         ann_abp=wabp(signal(:,abp_ind),0,1);
    %         if debug
    %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    %             plot((1:length(signal(:,abp_ind)))/Fs,signal(:,abp_ind),'b-')
    %             hold on
    %             plot(ann_abp/Fs,signal(ann_abp,abp_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    %         end
    %         % Analyze the signal quality index of ABP using jSQI
    %         if length(ann_abp)>=3 % at least 3 abp beats detected
    %             [features] = abpfeature(signal(:,abp_ind),ann_abp);
    %             [BEATQ R] = jSQI(features, ann_abp, signal(:,abp_ind));
    %         end
    %
    %         if (~isempty(ann_abp))
    %             if  ann_abp(end)>length(abp)
    %                 ann_abp(end)=[];
    %             end
    %             for i=1:300/Segment_t-1
    %                 cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(i-1)+1 & ann_abp<Fs*Segment_t*i));
    %                 if length(cur_ann_abp)>3
    %                     Sd_abp_0(i)=std(diff(cur_ann_abp));
    %                 end
    %             end
    %             [aa cur_indx3]=min(Sd_abp_0(1:300/Segment_t-1));
    %             if aa<1000
    %                 cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(cur_indx3-1) & ann_abp<Fs*Segment_t*cur_indx3));
    %                 abp_template_0=zeros(length(cur_ann_abp)-1,Fs);
    %                 Distance3=zeros(length(cur_ann_abp)-1,length(cur_ann_abp)-1);
    %                 for k=1:length(cur_ann_abp)-1
    %                     abp_template_0(k,:)=resample(abp(cur_ann_abp(k):cur_ann_abp(k+1)),Fs,cur_ann_abp(k+1)-cur_ann_abp(k)+1);
    %                     Range(k)=max(abp(cur_ann_abp(k):cur_ann_abp(k+1)))-min(abp(cur_ann_abp(k):cur_ann_abp(k+1)));
    %                     for k2=1:length(cur_ann_abp)-1
    %                         Range(k2)=max(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)))-min(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)));
    %                         if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    %                             Distance3(k,k2)=1;
    %                         end
    %                     end
    %                 end
    %                 if sum(sum(Distance3))/(length(cur_ann_abp)-1).^2 <Flag_falsedet_thr
    %                     Flag_falsedet_abp=1;
    %                 end
    %                 abp_template=mean(abp_template_0);
    %                 HR_abp=60*Fs/mean(diff(cur_ann_abp));
    %                 Amp_abp=max(abp_template)-min(abp_template);
    %             end
    %         end
    %     end
    %
    %     %Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
    %     ppg_ind=get_index(description,'PLETH');
    %     ann_ppg=[];
    %     HR_ppg=NaN;
    %     Amp_ppg=NaN;
    %     Flag_falsedet_ppg=0;
    %     if (~isempty(ppg_ind))
    %         ppg=signal(:,ppg_ind);
    %         y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,ppg_ind)
    %         ann_ppg=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120);
    %         if debug
    %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    %             plot((1:length(signal(:,ppg_ind)))/Fs,signal(:,ppg_ind),'b-')
    %             hold on
    %             plot(ann_ppg/Fs,signal(ann_ppg,ppg_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    %         end
    %         % Analyze the signal quality index of PPG
    %         if ~isempty(ann_ppg)
    %             [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
    %         end
    %
    %         if (~isempty(ann_ppg))
    %             if  ann_ppg(end)>length(ppg)
    %                 ann_ppg(end)=[];
    %             end
    %             for i=1:300/Segment_t-1
    %                 cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(i-1)+1 & ann_ppg<Fs*Segment_t*i));
    %                 if length(cur_ann_ppg)>3
    %                     Sd_ppg_0(i)=std(diff(cur_ann_ppg));
    %                 end
    %             end
    %             [aa cur_indx4]=min(Sd_ppg_0(1:300/Segment_t-1));
    %             if aa<1000
    %                 cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(cur_indx4-1) & ann_ppg<Fs*Segment_t*cur_indx4));
    %                 ppg_template_0=zeros(length(cur_ann_ppg)-1,Fs);
    %                 Distance4=zeros(length(cur_ann_ppg)-1,length(cur_ann_ppg)-1);
    %                 for k=1:length(cur_ann_ppg)-1
    %                     ppg_template_0(k,:)=resample(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)),Fs,cur_ann_ppg(k+1)-cur_ann_ppg(k)+1);
    %                     Range(k)=max(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)))-min(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)));
    %                     for k2=1:length(cur_ann_ppg)-1
    %                         Range(k2)=max(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)))-min(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)));
    %                         if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    %                             Distance4(k,k2)=1;
    %                         end
    %                     end
    %                 end
    %                 if sum(sum(Distance4))/(length(cur_ann_ppg)-1).^2 <Flag_falsedet_thr
    %                     Flag_falsedet_ppg=1;
    %                 end
    %                 ppg_template=mean(ppg_template_0);
    %                 HR_ppg=60*Fs/mean(diff(cur_ann_ppg));
    %                 Amp_ppg=max(ppg_template)-min(ppg_template);
    %             end
    %         end
    %     end
    
    
    
    
    
    
    %
    % %% RBF method
    % rand_A0=rand(size(A0_record,1),1);
    % train_index_A0 = find(rand_A0<0.5);
    % A0_record_train = A0_record(train_index_A0,:);
    % A0_record_test = A0_record;
    % A0_record_test(train_index_A0,:) = [];
    % rand_A1=rand(size(A1_record,1),1);
    % train_index_A1 = find(rand_A1<0.5);
    % A1_record_train = A1_record(train_index_A1,:);
    % A1_record_test = A1_record;
    % A1_record_test(train_index_A1,:) = [];
    %
    % A_record_train=[A0_record_train;A1_record_train];
    % A_record_train_target=[-1*ones(length(train_index_A0),1);ones(length(train_index_A1),1)]';
    % A_record_test=[A0_record_test;A1_record_test];
    %
    % Fs=250; T=8; % 8һ
    % Min_cf=0.4;
    % Max_cf=3.2;
    % Qth=0.8;
    % SegN=5;  % 5
    % Tnum=0;  % ѵĸ
    %
    % for m=1:size(A_record_train,1)
    %     [aa,signal,Fs,siginfo]=rdmat(RECORDS{A_record_train{m,2}});
    %     for segn=1:SegN
    %         start=300*Fs-segn*Fs*T+1;  % ŷֶ
    %         tail=300*Fs-(segn-1)*Fs*T;
    %         for n_channel=1:size(signal,2)
    %             y=signal(start:tail,n_channel);
    %             [b,a]=butter(5,2*[1 50]/Fs); %˲
    %             x=filtfilt(b,a,y); clear b a;
    %             x=x-mean(x);     % ȥֵ
    %             Energy(segn,n_channel)=sum(abs(x).^2)/Fs;  % 
    %             [HR(segn,n_channel),...
    %                 Quality(segn,n_channel),...
    %                 Qindex(segn,n_channel)]...    % ź
    %                 =Hr_quality(x,Fs,Min_cf,Max_cf,Qth);
    %            psdec(segn,n_channel)=power_sepctrum_dec(x,Fs,5);  % 
    %             clear y x;
    %         end
    %     end
    %     clear aa signal siginfo;
    %
    %     [Min_energy1,Min_index1]=sort(Energy(:,1),'ascend'); % 
    %     [Min_energy2,Min_index2]=sort(Energy(:,2),'ascend');
    %     % ֻǰС
    %     tvector=[Energy(Min_index1(1:2),1) Qindex(Min_index1(1:2),1)...
    %         Energy(Min_index2(1:2),2) Qindex(Min_index2(1:2),2)...
    %         Qindex(Min_index1(1:2),3) Qindex(Min_index2(1:2),3)...
    %         psdec(Min_index1(1:2),1) psdec(Min_index1(1:2),2) psdec(Min_index1(1:2),3)...
    %         psdec(Min_index2(1:2),1) psdec(Min_index2(1:2),2) psdec(Min_index2(1:2),3)];
    %
    %     vector(:,m)=tvector(:);
    %     vector(isnan(tvector(:)),m)=0;  % nannanǿΪ0
    %     ['ȡ  ' num2str(m) '  ݵ']
    % end
    %
    % for m=1:size(A_record_test,1)
    %     [aa,signal,Fs,siginfo]=rdmat(RECORDS{A_record_test{m,2}});
    %     for segn=1:SegN
    %         start=300*Fs-segn*Fs*T+1;  % ŷֶ
    %         tail=300*Fs-(segn-1)*Fs*T;
    %         for n_channel=1:size(signal,2)
    %             y=signal(start:tail,n_channel);
    %             [b,a]=butter(5,2*[1 50]/Fs); %˲
    %             x=filtfilt(b,a,y); clear b a;
    %             x=x-mean(x);     % ȥֵ
    %             Energy(segn,n_channel)=sum(abs(x).^2)/Fs;  % 
    %             [HR(segn,n_channel),...
    %                 Quality(segn,n_channel),...
    %                 Qindex(segn,n_channel)]...    % ź
    %                 =Hr_quality(x,Fs,Min_cf,Max_cf,Qth);
    %            psdec(segn,n_channel)=power_sepctrum_dec(x,Fs,5);  % 
    %             clear y x;
    %         end
    %     end
    %     clear aa signal siginfo;
    %
    %     [Min_energy1,Min_index1]=sort(Energy(:,1),'ascend'); % 
    %     [Min_energy2,Min_index2]=sort(Energy(:,2),'ascend');
    %     % ֻǰС
    %     tvector=[Energy(Min_index1(1:2),1) Qindex(Min_index1(1:2),1)...
    %         Energy(Min_index2(1:2),2) Qindex(Min_index2(1:2),2)...
    %         Qindex(Min_index1(1:2),3) Qindex(Min_index2(1:2),3)...
    %         psdec(Min_index1(1:2),1) psdec(Min_index1(1:2),2) psdec(Min_index1(1:2),3)...
    %         psdec(Min_index2(1:2),1) psdec(Min_index2(1:2),2) psdec(Min_index2(1:2),3)];
    %
    %     A_vector_test(:,m)=tvector(:);
    %     A_vector_test(isnan(tvector(:)),m)=0;  % nannanǿΪ0
    %     ['ȡ  ' num2str(m) '  ݵ']
    % end
    %
    % [net_A,tr_A] = newrb(vector,A_record_train_target,0,1);  % ѵ
    % net_out=sim(net_A,A_vector_test);
    %
    %
    
    %
    %
    % cur_type=B0_record;
    % Acc=zeros(length(cur_type),1);
    % Index=[];
    % % for m=1:length(cur_type)
    % for m=6:10
    %     [aa,signal,Fs,siginfo]=rdmat(RECORDS{cur_type{m,2}});
    %     alarmResult=1;
    %     description=squeeze(struct2cell(siginfo));
    %     description=description(4,:);   % description = 'II'    'V'    'PLETH'    'RESP'
    %
    %     % Resample signal to 125Hz
    %     Fs=Fs(1);
    %     if Fs~=125
    %         signal=resample(signal,125,Fs);
    %         Fs=125;
    %     end
    %
    %     %% ECG signal quality assessment
    %     ECG1=signal(:,1);
    %     ECG2=signal(:,2);
    %     % process ECG with SampEn
    %     Segment_t=10;
    %     Segment_num=size(signal,1)/Fs/Segment_t;
    %     Qth=0.5;  % 
    %     Min_cf=0.4;
    %     Max_cf=3.2;  % ѭƵʱ߽
    %     HR_ECG1_cf=zeros(Segment_num,1);
    %     HR_ECG2_cf=zeros(Segment_num,1);
    %     Quality_ECG1_cf=zeros(Segment_num,1);
    %     Quality_ECG2_cf=zeros(Segment_num,1);
    %     Qindex_ECG1_cf=zeros(Segment_num,1);
    %     Qindex_ECG2_cf=zeros(Segment_num,1);
    %
    %     SampEn_ECG1=zeros(Segment_num,1);
    %     SampEn_ECG2=zeros(Segment_num,1);
    %     K_ECG1=zeros(Segment_num,1);
    %     K_ECG2=zeros(Segment_num,1);
    %
    %
    %     Sd_ECG1_0=ones(Segment_num,1)*1000;
    %     Sd_ECG2_0=ones(Segment_num,1)*1000;
    %     Sd_abp_0=ones(Segment_num,1)*1000;
    %     Sd_ppg_0=ones(Segment_num,1)*1000;
    %     Mean_ECG1_0=zeros(Segment_num,1);
    %     Mean_ECG2_0=zeros(Segment_num,1);
    %     PeakLoca1=[];
    %     PeakLoca2=[];
    %     PeakLoca1_cur=[];
    %     PeakLoca2_cur=[];
    %     cur_PeakLoca1=[];
    %     cur_PeakLoca2=[];
    %     cur_PeakLoca11=[];
    %     cur_PeakLoca22=[];
    %     Indx1=[];
    %     Indx2=[];
    %     SampEn_thr1=0.05;
    %     SampEn_thr2=1;
    %     for i=1:Segment_num
    %         SampEn_ECG1(i) = SampEn_fast(ECG1(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i), 2, 0.2);
    %         mean_cur=mean(ECG1(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i));
    %         sd_cur=std(ECG1(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i));
    %         K_ECG1(i)=mean(((ECG1(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i)-mean_cur)./sd_cur).^4);
    %         %         if SampEn_ECG1(i)>SampEn_thr1 & SampEn_ECG1(i)<SampEn_thr2
    %         [HR_ECG1_cf(i),Quality_ECG1_cf(i),Qindex_ECG1_cf(i)]=Hr_quality(ECG1(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i),Fs,Min_cf,Max_cf,Qth);
    %
    %         %             cur_ECG10=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,1),1000,Fs);
    %         %             cur_ECG10 = wden(cur_ECG10, 'rigrsure', 's', 'mln', 3, 'coif5');
    %         %             [C, L] = wavedec(cur_ECG10, 6, 'coif5'); % about 8 Hz
    %         %             tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
    %         %             indf   = 1 + floor((length(tretp) - length(cur_ECG10))/2) - floor(1*length(wfilters('coif5')));
    %         %             cur_ECG10_tre = tretp(indf:indf + length(cur_ECG10) - 1);
    %         %             cur_ECG1 = cur_ECG10 - cur_ECG10_tre;
    %         %             cur_ECG1_sort=sort(cur_ECG1);
    %         %             m_high=mean(cur_ECG1_sort(end-Fs+1:end))-mean(cur_ECG1);
    %         %             m_low=mean(cur_ECG1)-mean(cur_ECG1_sort(1:Fs));
    %         %             if 1.5*m_high<m_low
    %         %                 cur_ECG1=-cur_ECG1;
    %         %             end
    %         %             PeakLoca1_cur = round(FindPeak1(cur_ECG1,1000)*Fs/1000);
    %         %             Sd_ECG1_0(i)=std(diff(PeakLoca1_cur));
    %         %             Mean_ECG1_0(i)=mean(diff(PeakLoca1_cur));
    %         %             PeakLoca1=[PeakLoca1;PeakLoca1_cur+Fs*Segment_t*(i-1)+1];
    %         %             Indx1=[Indx1;i];
    %
    %         SampEn_ECG2(i) = SampEn_fast(ECG2(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i), 2, 0.2);
    %         mean_cur=mean(ECG2(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i));
    %         sd_cur=std(ECG2(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i));
    %         K_ECG2(i)=mean(((ECG2(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i)-mean_cur)./sd_cur).^4);
    %         %         if SampEn_ECG2(i)>SampEn_thr1 & SampEn_ECG2(i)<SampEn_thr2
    %         [HR_ECG2_cf(i),Quality_ECG2_cf(i),Qindex_ECG2_cf(i)]=Hr_quality(ECG2(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i),Fs,Min_cf,Max_cf,Qth);
    %
    %         %             cur_ECG20=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,2),1000,Fs);
    %         %             cur_ECG20 = wden(cur_ECG20, 'rigrsure', 's', 'mln', 3, 'coif5');
    %         %             [C, L] = wavedec(cur_ECG20, 6, 'coif5'); % about 8 Hz
    %         %             tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
    %         %             indf   = 1 + floor((length(tretp) - length(cur_ECG20))/2) - floor(1*length(wfilters('coif5')));
    %         %             cur_ECG20_tre = tretp(indf:indf + length(cur_ECG20) - 1);
    %         %             cur_ECG2 = cur_ECG20 - cur_ECG20_tre;
    %         %             cur_ECG2_sort=sort(cur_ECG2);
    %         %             m_high=mean(cur_ECG2_sort(end-Fs+1:end))-mean(cur_ECG2);
    %         %             m_low=mean(cur_ECG2)-mean(cur_ECG2_sort(1:Fs));
    %         %             if 1.5*m_high<m_low
    %         %                 cur_ECG2=-cur_ECG2;
    %         %             end
    %         %             PeakLoca2_cur = round(FindPeak1(cur_ECG2,1000)*Fs/1000);
    %         %             Sd_ECG2_0(i)=std(diff(PeakLoca2_cur));
    %         %             Mean_ECG2_0(i)=mean(diff(PeakLoca2_cur));
    %         %             PeakLoca2=[PeakLoca2;PeakLoca2_cur+Fs*Segment_t*(i-1)+1];
    %         %             Indx2=[Indx2;i];
    %     end
    %     if debug
    %         figure('Color', 'w', 'Units', 'Inch', 'Position', [2, 1, 12, 4.5]);
    %         subplot(511)
    %         plot((1:length(ECG1))/Fs,ECG1,'b-')
    %         hold on
    %         plot([296 296],[0 1],'r-')
    %         hold on
    %         plot([298.4 298.4],[0 1],'r-')
    %         subplot(512)
    %         plot((1:Segment_num)-0.5,SampEn_ECG1,'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
    %         hold on
    %         plot([0 Segment_num],[SampEn_thr1 SampEn_thr1],'r--')
    %         hold on
    %         plot([0 Segment_num],[SampEn_thr2 SampEn_thr2],'r--')
    %         subplot(513)
    %         plot((1:Segment_num)-0.5,K_ECG1,'mo','MarkerSize',4,'MarkerEdgeColor','m','MarkerFaceColor','m')
    %         subplot(514)
    %         plot((1:Segment_num)-0.5,Quality_ECG1_cf,'co','MarkerSize',4,'MarkerEdgeColor','c','MarkerFaceColor','c')
    %         subplot(515)
    %         plot((1:Segment_num)-0.5,HR_ECG1_cf,'ko','MarkerSize',4,'MarkerEdgeColor','k','MarkerFaceColor','k')
    %          hold on
    %         plot([0 Segment_num],[100 100],'r--')
    %
    %         figure('Color', 'w', 'Units', 'Inch', 'Position', [2, 1, 12, 4.5]);
    %         subplot(511)
    %         plot((1:length(ECG2))/Fs,ECG2,'g-')
    %         hold on
    %         plot([296 296],[0 1],'r-')
    %         hold on
    %         plot([298.4 298.4],[0 1],'r-')
    %         subplot(512)
    %         plot((1:Segment_num)-0.5,SampEn_ECG2,'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r')
    %         hold on
    %         plot([0 Segment_num],[SampEn_thr1 SampEn_thr1],'r--')
    %         hold on
    %         plot([0 Segment_num],[SampEn_thr2 SampEn_thr2],'r--')
    %         subplot(513)
    %         plot((1:Segment_num)-0.5,K_ECG2,'mo','MarkerSize',4,'MarkerEdgeColor','m','MarkerFaceColor','m')
    %         subplot(514)
    %         plot((1:Segment_num)-0.5,Quality_ECG2_cf,'co','MarkerSize',4,'MarkerEdgeColor','c','MarkerFaceColor','c')
    %         subplot(515)
    %         plot((1:Segment_num)-0.5,HR_ECG2_cf,'ko','MarkerSize',4,'MarkerEdgeColor','k','MarkerFaceColor','k')
    %         hold on
    %         plot([0 Segment_num],[100 100],'r--')
    %     end
    %
    % end
    %
    % %
    % %     abp_ind=get_index(description,'ABP');
    % %     if(~isempty(abp_ind))
    % %         abp=signal(:,abp_ind);
    % %         ann_abp=wabp(signal(:,abp_ind),0,1);
    % %         if debug
    % %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    % %             plot((1:length(signal(:,abp_ind)))/Fs,signal(:,abp_ind),'b-')
    % %             hold on
    % %             plot(ann_abp/Fs,signal(ann_abp,abp_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         end
    % %         % Analyze the signal quality index of ABP using jSQI
    % %         if length(ann_abp)>=3 % at least 3 abp beats detected
    % %             [features] = abpfeature(signal(:,abp_ind),ann_abp);
    % %             [BEATQ R] = jSQI(features, ann_abp, signal(:,abp_ind));
    % %         end
    % %
    % %     end
    % %     ppg_ind=get_index(description,'PLETH');
    % %     if (~isempty(ppg_ind))
    % %         ppg=signal(:,ppg_ind);
    % %         y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,ppg_ind)
    % %         ann_ppg=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120);
    % %         if debug
    % %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    % %             plot((1:length(signal(:,ppg_ind)))/Fs,signal(:,ppg_ind),'b-')
    % %             hold on
    % %             plot(ann_ppg/Fs,signal(ann_ppg,ppg_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         end
    % %         % Analyze the signal quality index of PPG
    % %         if ~isempty(ann_ppg)
    % %             [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
    % %         end
    % %     end
    % %
    % %
    % %
    % %
    % %
    % %
    % %
    % %     Flag_falsedet_thr=0.1;
    % %     Amp_thr=2;
    % %     HR_ECG1=NaN;
    % %     Amp_ECG1=NaN;
    % %     Flag_falsedet1=0;
    % %     if (~isempty(PeakLoca1))
    % %         if  PeakLoca1(end)>length(ECG1)
    % %             PeakLoca1(end)=[];
    % %         end
    % %         [aa cur_indx1]=min(Sd_ECG1_0(1:300/Segment_t-1));
    % %         if aa<1000
    % %             cur_PeakLoca1=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(cur_indx1-1) & PeakLoca1<Fs*Segment_t*cur_indx1));
    % %             ECG_template10=zeros(length(cur_PeakLoca1)-1,Fs);
    % %             Distance1=zeros(length(cur_PeakLoca1)-1,length(cur_PeakLoca1)-1);
    % %             for k=1:length(cur_PeakLoca1)-1
    % %                 ECG_template10(k,:)=resample(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)),Fs,cur_PeakLoca1(k+1)-cur_PeakLoca1(k)+1);
    % %                 Range(k)=max(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)))-min(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)));
    % %                 for k2=1:length(cur_PeakLoca1)-1
    % %                     Range(k2)=max(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)))-min(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)));
    % %                     if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    % %                         Distance1(k,k2)=1;
    % %                     end
    % %                 end
    % %             end
    % %             if sum(sum(Distance1))/(length(cur_PeakLoca1)-1).^2 <Flag_falsedet_thr
    % %                 Flag_falsedet1=1;
    % %             end
    % %             ECG_template1=mean(ECG_template10);
    % %             HR_ECG1=60*Fs/mean(diff(cur_PeakLoca1));
    % %             Amp_ECG1=max(ECG_template1)-min(ECG_template1);
    % %
    % %             cur_PeakLoca11=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(30-1) & PeakLoca1<Fs*Segment_t*30));
    % %             ECG_Seg30_corr1=zeros(length(cur_PeakLoca11)-1,1);
    % %             for k=1:length(cur_PeakLoca11)-1
    % %                 cursig = resample(ECG1(cur_PeakLoca11(k):cur_PeakLoca11(k+1)),Fs,cur_PeakLoca11(k+1)-cur_PeakLoca11(k)+1);
    % %                 xy = corrcoef(ECG_template1,cursig);
    % %                 ECG_Seg30_corr1(k) = xy(2,1);
    % %             end
    % %             ECG_A_corr1=mean(abs(ECG_Seg30_corr1));
    % %         end
    % %     else ECG_A_corr1=0;
    % %     end
    % %
    % %     HR_ECG2=NaN;
    % %     Amp_ECG2=NaN;
    % %     Flag_falsedet2=0;
    % %     if (~isempty(PeakLoca2))
    % %         if  PeakLoca2(end)>length(ECG2)
    % %             PeakLoca2(end)=[];
    % %         end
    % %         [aa cur_indx2]=min(Sd_ECG2_0(1:300/Segment_t-1));
    % %         if aa<1000
    % %             cur_PeakLoca2=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(cur_indx2-1) & PeakLoca2<Fs*Segment_t*cur_indx2));
    % %             ECG_template20=zeros(length(cur_PeakLoca2)-1,Fs);
    % %             Distance2=zeros(length(cur_PeakLoca2)-1,length(cur_PeakLoca2)-1);
    % %             for k=1:length(cur_PeakLoca2)-1
    % %                 ECG_template20(k,:)=resample(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)),Fs,cur_PeakLoca2(k+1)-cur_PeakLoca2(k)+1);
    % %                 Range(k)=max(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)))-min(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)));
    % %                 for k2=1:length(cur_PeakLoca2)-1
    % %                     Range(k2)=max(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)))-min(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)));
    % %                     if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    % %                         Distance2(k,k2)=1;
    % %                     end
    % %                 end
    % %             end
    % %             if sum(sum(Distance2))/(length(cur_PeakLoca2)-1).^2 <Flag_falsedet_thr
    % %                 Flag_falsedet2=1;
    % %             end
    % %             ECG_template2=mean(ECG_template20);
    % %             HR_ECG2=60*Fs/mean(diff(cur_PeakLoca2));
    % %             Amp_ECG2=max(ECG_template2)-min(ECG_template2);
    % %
    % %             cur_PeakLoca22=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(30-1) & PeakLoca2<Fs*Segment_t*30));
    % %             ECG_Seg30_corr2=zeros(length(cur_PeakLoca22)-1,1);
    % %             for k=1:length(cur_PeakLoca22)-1
    % %                 cursig = resample(ECG2(cur_PeakLoca22(k):cur_PeakLoca22(k+1)),Fs,cur_PeakLoca22(k+1)-cur_PeakLoca22(k)+1);
    % %                 xy = corrcoef(ECG_template2,cursig);
    % %                 ECG_Seg30_corr2(k) = xy(2,1);
    % %             end
    % %             ECG_A_corr2=mean(abs(ECG_Seg30_corr2));
    % %         end
    % %     else ECG_A_corr2=0;
    % %     end
    % %
    % %
    % %     if debug
    % %         figure('Color', 'w', 'Units', 'Inch', 'Position', [2, 1, 12, 4.5]);
    % %         subplot(211)
    % %         plot((1:length(ECG1))/Fs,ECG1,'b-')
    % %         hold on
    % %         plot(PeakLoca1/Fs,ECG1(PeakLoca1),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         hold on
    % %         plot(cur_PeakLoca1/Fs,ECG1(cur_PeakLoca1),'go','MarkerSize',4,'MarkerEdgeColor','g','MarkerFaceColor','g');
    % %         subplot(212)
    % %         plot((1:length(ECG2))/Fs,ECG2,'b-')
    % %         hold on
    % %         plot(PeakLoca2/Fs,ECG2(PeakLoca2),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         hold on
    % %         plot(cur_PeakLoca2/Fs,ECG2(cur_PeakLoca2),'go','MarkerSize',4,'MarkerEdgeColor','g','MarkerFaceColor','g');
    % %         [HR_ECG1,Amp_ECG1,Flag_falsedet1;
    % %             HR_ECG2,Amp_ECG2,Flag_falsedet2]
    % %     end
    % %
    % %     %Run WABP on the record, which by default will analyze the first ABP, ART, or BP signal
    % %     N=[];
    % %     N0=[];
    % %     abp_ind=get_index(description,'ABP');
    % %     ann_abp=[];
    % %     features=[];
    % %     BEATQ=[];
    % %     R=[];
    % %     HR_abp=NaN;
    % %     Amp_abp=NaN;
    % %     Flag_falsedet_abp=0;
    % %     if(~isempty(abp_ind))
    % %         abp=signal(:,abp_ind);
    % %         ann_abp=wabp(signal(:,abp_ind),0,1);
    % %         if debug
    % %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    % %             plot((1:length(signal(:,abp_ind)))/Fs,signal(:,abp_ind),'b-')
    % %             hold on
    % %             plot(ann_abp/Fs,signal(ann_abp,abp_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         end
    % %         % Analyze the signal quality index of ABP using jSQI
    % %         if length(ann_abp)>=3 % at least 3 abp beats detected
    % %             [features] = abpfeature(signal(:,abp_ind),ann_abp);
    % %             [BEATQ R] = jSQI(features, ann_abp, signal(:,abp_ind));
    % %         end
    % %
    % %         if (~isempty(ann_abp))
    % %             if  ann_abp(end)>length(abp)
    % %                 ann_abp(end)=[];
    % %             end
    % %             for i=1:300/Segment_t-1
    % %                 cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(i-1)+1 & ann_abp<Fs*Segment_t*i));
    % %                 if length(cur_ann_abp)>3
    % %                     Sd_abp_0(i)=std(diff(cur_ann_abp));
    % %                 end
    % %             end
    % %             [aa cur_indx3]=min(Sd_abp_0(1:300/Segment_t-1));
    % %             if aa<1000
    % %                 cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(cur_indx3-1) & ann_abp<Fs*Segment_t*cur_indx3));
    % %                 abp_template_0=zeros(length(cur_ann_abp)-1,Fs);
    % %                 Distance3=zeros(length(cur_ann_abp)-1,length(cur_ann_abp)-1);
    % %                 for k=1:length(cur_ann_abp)-1
    % %                     abp_template_0(k,:)=resample(abp(cur_ann_abp(k):cur_ann_abp(k+1)),Fs,cur_ann_abp(k+1)-cur_ann_abp(k)+1);
    % %                     Range(k)=max(abp(cur_ann_abp(k):cur_ann_abp(k+1)))-min(abp(cur_ann_abp(k):cur_ann_abp(k+1)));
    % %                     for k2=1:length(cur_ann_abp)-1
    % %                         Range(k2)=max(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)))-min(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)));
    % %                         if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    % %                             Distance3(k,k2)=1;
    % %                         end
    % %                     end
    % %                 end
    % %                 if sum(sum(Distance3))/(length(cur_ann_abp)-1).^2 <Flag_falsedet_thr
    % %                     Flag_falsedet_abp=1;
    % %                 end
    % %                 abp_template=mean(abp_template_0);
    % %                 HR_abp=60*Fs/mean(diff(cur_ann_abp));
    % %                 Amp_abp=max(abp_template)-min(abp_template);
    % %             end
    % %         end
    % %     end
    % %
    % %     %Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
    % %     ppg_ind=get_index(description,'PLETH');
    % %     ann_ppg=[];
    % %     HR_ppg=NaN;
    % %     Amp_ppg=NaN;
    % %     Flag_falsedet_ppg=0;
    % %     if (~isempty(ppg_ind))
    % %         ppg=signal(:,ppg_ind);
    % %         y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,ppg_ind)
    % %         ann_ppg=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120);
    % %         if debug
    % %             figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
    % %             plot((1:length(signal(:,ppg_ind)))/Fs,signal(:,ppg_ind),'b-')
    % %             hold on
    % %             plot(ann_ppg/Fs,signal(ann_ppg,ppg_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
    % %         end
    % %         % Analyze the signal quality index of PPG
    % %         if ~isempty(ann_ppg)
    % %             [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
    % %         end
    % %
    % %         if (~isempty(ann_ppg))
    % %             if  ann_ppg(end)>length(ppg)
    % %                 ann_ppg(end)=[];
    % %             end
    % %             for i=1:300/Segment_t-1
    % %                 cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(i-1)+1 & ann_ppg<Fs*Segment_t*i));
    % %                 if length(cur_ann_ppg)>3
    % %                     Sd_ppg_0(i)=std(diff(cur_ann_ppg));
    % %                 end
    % %             end
    % %             [aa cur_indx4]=min(Sd_ppg_0(1:300/Segment_t-1));
    % %             if aa<1000
    % %                 cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(cur_indx4-1) & ann_ppg<Fs*Segment_t*cur_indx4));
    % %                 ppg_template_0=zeros(length(cur_ann_ppg)-1,Fs);
    % %                 Distance4=zeros(length(cur_ann_ppg)-1,length(cur_ann_ppg)-1);
    % %                 for k=1:length(cur_ann_ppg)-1
    % %                     ppg_template_0(k,:)=resample(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)),Fs,cur_ann_ppg(k+1)-cur_ann_ppg(k)+1);
    % %                     Range(k)=max(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)))-min(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)));
    % %                     for k2=1:length(cur_ann_ppg)-1
    % %                         Range(k2)=max(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)))-min(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)));
    % %                         if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
    % %                             Distance4(k,k2)=1;
    % %                         end
    % %                     end
    % %                 end
    % %                 if sum(sum(Distance4))/(length(cur_ann_ppg)-1).^2 <Flag_falsedet_thr
    % %                     Flag_falsedet_ppg=1;
    % %                 end
    % %                 ppg_template=mean(ppg_template_0);
    % %                 HR_ppg=60*Fs/mean(diff(cur_ann_ppg));
    % %                 Amp_ppg=max(ppg_template)-min(ppg_template);
    % %             end
    % %         end
    % %     end
    % %
    % %
    % %
    % %     %% Judgement
    % %     N_d=Fs*5*60; % alarm position
    % %     N0_d=N_d-Fs*16+1; % 16s before the alarm
    % %
    % %     % select the beats in the segment
    % %     n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
    % %     n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));
    % %
    % %     hr_max_abp=NaN;
    % %     max_rr_abp=NaN;
    % %     hr_max_ppg=NaN;
    % %     max_rr_ppg=NaN;
    % %
    % %     % calculate the heart rate
    % %     if length(n_abp_beats)>=2
    % %         hr_max_abp=60*Fs/min(diff(ann_abp(n_abp_beats)));   % 16s maximun HR
    % %         max_rr_abp1=max(diff(ann_abp(n_abp_beats)))/Fs;     % % 16s maximun RR
    % %         max_rr_abp2=(Fs*5*60-ann_abp(n_abp_beats(end)))/Fs;
    % %         max_rr_abp=max(max_rr_abp1,max_rr_abp2);
    % %     end
    % %     if length(n_ppg_beats)>=2
    % %         hr_max_ppg=60*Fs/min(diff(ann_ppg(n_ppg_beats)));
    % %         max_rr_ppg1=max(diff(ann_ppg(n_ppg_beats)))/Fs;
    % %         max_rr_ppg2=(Fs*5*60-ann_ppg(n_ppg_beats(end)))/Fs;
    % %         max_rr_ppg=max(max_rr_ppg1,max_rr_ppg2);
    % %     end
    % %
    % %     % calculate low heart rate of 5 consecutive beats for Bradycardia
    % %     low_hr_abp=NaN;
    % %     low_hr_ppg=NaN;
    % %     if length(n_abp_beats>=5)
    % %         for i=1:length(n_abp_beats)-4
    % %             low_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+4))-ann_abp(n_abp_beats(i)))/4);
    % %         end
    % %     end
    % %     low_hr_abp=min(low_hr_abp);
    % %     if length(n_ppg_beats>=5)
    % %         for i=1:length(n_ppg_beats)-4
    % %             low_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+4))-ann_ppg(n_ppg_beats(i)))/4);
    % %         end
    % %     end
    % %     low_hr_ppg=min(low_hr_ppg);
    % %
    % %     % calculate high heart reate of 17 consecutive beats for Tachycardia
    % %     high_hr_abp=NaN;
    % %     high_hr_ppg=NaN;
    % %     if length(n_abp_beats>=17)
    % %         for i=1:length(n_abp_beats)-16
    % %             high_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+16))-ann_abp(n_abp_beats(i)))/16);
    % %         end
    % %     end
    % %     high_hr_abp=max(high_hr_abp);
    % %     if length(n_ppg_beats>=17)
    % %         for i=1:length(n_ppg_beats)-16
    % %             high_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+16))-ann_ppg(n_ppg_beats(i)))/16);
    % %         end
    % %     end
    % %     high_hr_ppg=max(high_hr_ppg);
    % %
    % %     % calculate the signal quality index
    % %     if ~isempty(ann_abp)
    % %         abpsqi=1-sum(sum(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:)))/numel(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:));
    % %     else
    % %         abpsqi=0;
    % %     end
    % %     if ~isempty(ann_ppg)
    % %         ppgsqi=mean(psqi(intersect(n_ppg_beats,1:length(psqi))));  % intersect: get the intersection of two sets
    % %     else
    % %         ppgsqi=0;
    % %     end
    % %
    % %     % SQI threshold
    % %     sqi_th = 0.6;
    % %     sqi_th_A = 0.6;
    % %     sqi_th_B = 0.5;
    % %     sqi_th_T = 0.9;
    % %     sqi_th_VT = 0.7;
    % %     sqi_th_VF = 0.6;
    % %
    % %
    % %     % Alarm threshold (seconds)
    % %     ASY_th = 3.5;
    % %     BRA_th = 40;
    % %     TAC_th = 140;
    % %     VTA_th = 100;
    % %     VFB_th = 170;
    % %     tolerance = 5; % tolerance = 5 bmp
    % %
    % %
    % %     %% For ECG judgement
    % %     Falg_ECG1_A=0;
    % %     Falg_ECG2_A=0;
    % %     Falg_ECG1_B=1;
    % %     Falg_ECG2_B=1;
    % %     Falg_ECG1_VT=0;
    % %     Falg_ECG2_VT=0;
    % %     Falg_ECG1_VF=0;
    % %     Falg_ECG2_VF=0;
    % %
    % %     N0_d_A=Fs*(5*60-5);
    % %     N0_d_B=Fs*(5*60-6);
    % %     N0_d_VT=Fs*(5*60-5);
    % %     N0_d_VF=Fs*(5*60-5);
    % %
    % %     hr_VT_ECG1=NaN;
    % %     hr_VT_ECG2=NaN;
    % %
    % %     if Flag_falsedet1
    % %         cur_data=ECG1(N0_d_A+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG1);
    % %         if length(find(diff(cur_index)>10))+1>HR_ECG1/12*0.8
    % %             Falg_ECG1_A=1;
    % %         end
    % %
    % %         cur_data=ECG1(N0_d_B+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG1*0.8);
    % %         if length(find(diff(cur_index)>10))+1<4
    % %             Falg_ECG1_B=0;
    % %         end
    % %
    % %         high_hr_abp=max(high_hr_abp,HR_ECG1);
    % %
    % %         %             cur_data=ECG1(N0_d_VT+1:N_d);
    % %         %         cur_data=cur_data-min(cur_data);
    % %         %         cur_index=find(cur_data>Amp_ECG1*0.8);
    % %         %         if length(find(diff(cur_index)>10))+1>7 && (HR_ECG1>=VTA_th+20 || HR_ECG1<=VTA_th-20)
    % %         %             Falg_ECG1_VT=1;
    % %         %         end
    % %
    % %
    % %         n_ECG1_beats_VT=intersect(find(PeakLoca1>=N0_d_VT),find(PeakLoca1<=N_d));
    % %         if length(n_ECG1_beats_VT)>5
    % %             hr_VT_ECG1=60*Fs/(mean(diff(PeakLoca1(n_ECG1_beats_VT))));
    % %             if  HR_ECG1<75 || Amp_ECG1<0.35  || SampEn1>0.8 || SampEn1==0 || hr_VT_ECG1>170
    % %                 Falg_ECG1_VT=1;
    % %             end
    % %         end
    % %
    % %         cur_data=ECG1(N0_d_VF+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG1*0.6);
    % %         if length(find(diff(cur_index)>10))+1>12  && HR_ECG1>=VFB_th-20
    % %             Falg_ECG1_VF=1;
    % %         end
    % %
    % %     end
    % %
    % %     if Flag_falsedet2
    % %         cur_data=ECG2(N0_d_A+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG2);
    % %         if length(find(diff(cur_index)>10))+1>HR_ECG2/12*0.8
    % %             Falg_ECG2_A=1;
    % %         end
    % %
    % %         cur_data=ECG2(N0_d_B+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG2*0.8);
    % %         if length(find(diff(cur_index)>10))+1<4
    % %             Falg_ECG2_B=0;
    % %         end
    % %
    % %         high_hr_abp=max(high_hr_abp,HR_ECG2);
    % %
    % %         %            cur_data=ECG2(N0_d_VT+1:N_d);
    % %         %         cur_data=cur_data-min(cur_data);
    % %         %         cur_index=find(cur_data>Amp_ECG2*0.8);
    % %         %         if length(find(diff(cur_index)>10))+1>7  && (HR_ECG2>=VTA_th+20 || HR_ECG2<=VTA_th-20)
    % %         %             Falg_ECG2_VT=1;
    % %         %         end
    % %
    % %         n_ECG2_beats_VT=intersect(find(PeakLoca2>=N0_d_VT),find(PeakLoca2<=N_d));
    % %         if length(n_ECG2_beats_VT)>5
    % %             hr_VT_ECG2=60*Fs/(mean(diff(PeakLoca2(n_ECG2_beats_VT))));
    % %             if  HR_ECG2<75 || Amp_ECG2>4.5 || SampEn2>0.85 || SampEn2==0 || hr_VT_ECG2>170
    % %                 Falg_ECG2_VT=1;
    % %             end
    % %         end
    % %
    % %         cur_data=ECG2(N0_d_VF+1:N_d);
    % %         cur_data=cur_data-min(cur_data);
    % %         cur_index=find(cur_data>Amp_ECG2*0.6);
    % %         if length(find(diff(cur_index)>10))+1>12  && HR_ECG2>=VFB_th-20
    % %             Falg_ECG2_VF=1;
    % %         end
    % %
    % %     end
    % %
    % %
    % %
    % %     switch ALARMS{cur_type{m,2}}
    % %         case 'Asystole'
    % %             % if the signal quality is good enough and the maximum RR interval
    % %             % is less than the Asystole threshold, set the alarm as 'F'
    % %             if (abpsqi>=sqi_th_A && max_rr_abp<ASY_th) || (ppgsqi>=sqi_th_A && max_rr_ppg<ASY_th) || Falg_ECG1_A || Falg_ECG2_A
    % %                 alarmResult=0;
    % %             end
    % %         case 'Bradycardia'
    % %             % if the signal quality is good enough and the low heart rate
    % %             % is greater than the Bradycardia threshold, set the alarm as 'F'
    % %             if (abpsqi>=sqi_th_B && low_hr_abp-tolerance>BRA_th) || (ppgsqi>=sqi_th_B && low_hr_ppg-tolerance>BRA_th)
    % %                 alarmResult=0;
    % %             end
    % %         case 'Tachycardia'
    % %             % if the signal quality is good enough and the high heart rate
    % %             % is less than the Tachycardia threshold, set the alarm as 'F'
    % %             if (abpsqi>=sqi_th_T && high_hr_abp+tolerance<TAC_th) || (ppgsqi>=sqi_th_T && high_hr_ppg+tolerance<TAC_th)
    % %                 alarmResult=0;
    % %             end
    % %         case 'Ventricular_Tachycardia'
    % %             % suppress false alarm using hr_max & sqi
    % %             if (abpsqi>=sqi_th_VT && hr_max_abp+tolerance<VTA_th) || (ppgsqi>=sqi_th_VT && hr_max_ppg+tolerance<VTA_th) || Falg_ECG1_VT || Falg_ECG2_VT
    % %                 alarmResult=0;
    % %             end
    % %         case 'Ventricular_Flutter_Fib'
    % %             % suppress false alarm using hr_max & sqi
    % %             if (abpsqi>=sqi_th_VF && hr_max_abp+tolerance<VFB_th) || (ppgsqi>=sqi_th_VF && hr_max_ppg+tolerance<VFB_th) || Falg_ECG1_VF || Falg_ECG2_VF
    % %                 alarmResult=0;
    % %             end
    % %         otherwise
    % %             error(['Unknown alarm type: ' alarm_type])
    % %     end
    % %
    % %     if alarmResult==GOLD_TRUTH(cur_type{m,2})
    % %         Acc(m)=1;
    % %     end
    % %     Index=[Index;HR_ECG1 HR_ECG2 Amp_ECG1 Amp_ECG2 SampEn1 SampEn2 ECG_A_corr1 ECG_A_corr2 hr_VT_ECG1 hr_VT_ECG2 Flag_falsedet1 Flag_falsedet2 Falg_ECG1_VT Falg_ECG2_VT abpsqi ppgsqi hr_max_abp hr_max_ppg];
    % % end
    % % if ~debug
    % %     find(Acc==0)
    % %     sum(Acc)/length(cur_type)*100
    % % end
    toc
    
    
    
