function results = CinC2015(data)
%% note: when using this function, please add the data file road to the
%% line 616

%% initialize global variables
global A0_record;
global A1_record;
global B0_record;
global B1_record;
global T0_record;
global T1_record;
global VT0_record;
global VT1_record;
global VF0_record;
global VF1_record;

global A0_E1_record;
global A1_E1_record;
global B0_E1_record;
global B1_E1_record;
global T0_E1_record;
global T1_E1_record;
global VT0_E1_record;
global VT1_E1_record;
global VF0_E1_record;
global VF1_E1_record;

global A0_E2_record;
global A1_E2_record;
global B0_E2_record;
global B1_E2_record;
global T0_E2_record;
global T1_E2_record;
global VT0_E2_record;
global VT1_E2_record;
global VF0_E2_record;
global VF1_E2_record;
global cur_record;

global kickNumberalarm_type;
global kickNumbergold;
global kickNumberevent;
global kickNumberroom_window;

global Fs;
global Alarm_type;
global Gold_flag;
global Event;
global Room_window;
global SubNo;
global signal;
global description;
global channel_num;
global PeakLoca1;
global PeakLoca2;
global ann_ppg;
global ann_abp;
global NN;
global t;
global time;

global color_set;
global fontsize1;
global fontsize2;

color_set = [0.2 0.8 0.8];
fontsize1=12;
fontsize2=10;

box_left =0.01;
box_low =0.789;
box_w = 0.09;
box_w_int = 0.009;
box_h = 0.1;
box_h_1=0.045;


figure_left =0.06;
figure_low =0.07;
figure_w = 0.68;
figure_h = 0.14;
figure_h_int = 0.04;
x_range=[0 300];

smallbox_h = 0.04;

debug=0;

%% Creat figures and uicontrols
hMainFigure = figure('Name', 'Sound Generator', ...
    'NumberTitle', 'off', ...
    'Resize', 'on', ...
    'Units', 'pixel',...
    'HandleVisibility', 'callback',...
    'Position', [100 100 1024 568],...
    'color',color_set);

hData1Axes = axes(...
    'Parent', hMainFigure,...
    'HandleVisibility', 'callback', ...
    'Units', 'normalized', ...
    'Position', [figure_left   figure_low+3*figure_h+3*figure_h_int    figure_w    figure_h], ...
    'XLimMode','manual',...
    'XLim', x_range, ...
    'XTick', 0:50:300,...
    'NextPlot', 'replacechildren');
ylabel(hData1Axes,'-- (--)');

hData2Axes = axes(...
    'Parent', hMainFigure,...
    'HandleVisibility', 'callback', ...
    'Units', 'normalized', ...
    'Position', [figure_left    figure_low+2*figure_h+2*figure_h_int    figure_w    figure_h], ...
    'XLimMode','manual',...
    'XLim', x_range, ...
    'XTick', 0:50:300,...
    'NextPlot', 'replacechildren');
ylabel(hData2Axes,'-- (--)');


hData3Axes = axes(...
    'Parent', hMainFigure, ...
    'HandleVisibility', 'callback', ...
    'Units', 'normalized', ...
    'Position', [figure_left   figure_low+figure_h+figure_h_int   figure_w    figure_h], ...
    'XLimMode','manual',...
    'XLim', x_range, ...
    'XTick', 0:50:300);
ylabel(hData3Axes,'-- (--)');

hData4Axes = axes(...
    'Parent', hMainFigure, ...
    'HandleVisibility', 'callback', ...
    'Units', 'normalized', ...
    'Position', [figure_left    figure_low    figure_w    figure_h], ...
    'XLimMode','manual',...
    'XLim', x_range, ...
    'XTick', 0:50:300);
ylabel(hData4Axes,'-- (--)');
xlabel(hData4Axes,'Time (s)');


tickTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.1    0.945    0.75    0.04], ...
    'String', 'Signal playback system ---- 2015 PhysioNet/CinC Challenge',...
    'fontsize',14,...
    'background',[0.2 0.8 0.8]);

tickTitle2 = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0    0.906    0.9    0.04], ...
    'String', '-----------------------------------------------------------------------------------------------------------------------------------------------------------------------',...
    'fontsize',14,...
    'background',[0.2 0.8 0.8]);

tickTitle3 = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.76    0.01    0.0015    0.9], ...
    'String', '- - - - - - - - - - - - - - - - - - - - - - - -',...
    'fontsize',10,...
    'background',[0.25 0.25 0.25]);

tickTitle4 = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.765    0.08    0.23    0.002], ...
    'String', '------------------------------------------------------',...
    'fontsize',10,...
    'background',[0.25 0.25 0.25]);


tickSubTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.9    0.90    0.1    0.04], ...
    'String', 'CinC 2015',...
    'fontsize',10,...
    'background',[0.2 0.8 0.8]);

hBeatNumEdit_ini = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left   box_low    box_w    box_h], ...
    'String', 'Initialize', ...
    'fontsize',13,...
    'fontweight','bold',...
    'background',[0.2 0.8 0.6],....
    'Callback', @initial);

hBeatNumEdit_load = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+box_w+box_w_int   box_low    box_w    box_h], ...
    'String', 'Load data', ...
    'fontweight','bold',...
    'fontsize',13,...
    'background',[0.2 0.8 0.6],....
    'Callback', @load);


hBeatNumEdit = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+2*box_w+2*box_w_int   box_low+box_h_1    box_w    box_h-box_h_1], ...
    'String', 'Alarm type', ...
    'fontsize',fontsize1,...
    'Callback', @alarm_type);

tickalarm_type = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+2*box_w+2*box_w_int   box_low    box_w    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);

hBeatNumEdit = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+3*box_w+3*box_w_int   box_low+box_h_1    box_w    box_h-box_h_1], ...
    'String', 'GOLD', ...
    'fontsize',fontsize1,...
    'Callback', @gold);

tickgold = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+3*box_w+3*box_w_int   box_low    box_w    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);

hBeatNumEdit = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+4*box_w+4*box_w_int   box_low+box_h_1    box_w    box_h-box_h_1], ...
    'String', 'Event', ...
    'fontsize',fontsize1,...
    'Callback', @event);

tickevent = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+4*box_w+4*box_w_int   box_low    box_w    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);


hBeatNumEdit = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+5*box_w+5*box_w_int   box_low+box_h_1    box_w    box_h-box_h_1], ...
    'String', 'Window', ...
    'fontsize',fontsize1,...
    'Callback', @room_window);

tickroom_window = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+5*box_w+5*box_w_int   box_low    box_w    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);


hBeatNumSubject = uicontrol(hMainFigure, ...
    'Style', 'slider', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+6*box_w+6*box_w_int   box_low+box_h_1    box_w*1.2    box_h-box_h_1], ...
    'String', 'Subject', ...
    'fontsize',fontsize1,...
    'Min',1,'Max',10,'Value',1,...
    'Callback', @subject);

ticksubject = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+6*box_w+6*box_w_int   box_low    box_w*1.2/2    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);

tickRecordName = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+6.6*box_w+6*box_w_int   box_low    box_w*1.2/2    box_h_1], ...
    'String', '--',...
    'fontsize',fontsize2);


hBeatNumEdit = uicontrol(hMainFigure, ...
    'Style', 'pushbutton', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [box_left+7.2*box_w+7*box_w_int   box_low    0.03    0.05], ...
    'String', '+', ...
    'fontsize',24,...
    'Callback', @play_room);



tickTitle5 = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.765    0.85    0.23    0.035], ...
    'String', 'Information of current sub-type',...
    'fontangle','italic',...
    'fontweight','bold',...
    'fontsize',11,...
    'background',[0.2 0.6 0.8]);

tickSubTypeNotitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.77    0.8    0.15    smallbox_h-0.005], ...
    'String', 'Total recording No:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickSubTypeNo = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.93    0.8    0.05    smallbox_h], ...
    'String', '--',...
    'fontsize',12);

tickOrderRecordtitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.77    0.75    0.15    smallbox_h-0.005], ...
    'String', 'Order of recording:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickOrderRecord = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.93    0.75    0.05    smallbox_h], ...
    'String', '--',...
    'fontsize',12);

tickTitle6 = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.765    0.685    0.23    0.035], ...
    'String', 'Parameter outputs',...
    'fontangle','italic',...
    'fontweight','bold',...
    'fontsize',11,...
    'background',[0.2 0.6 0.8]);

tickECG1Title = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.887    0.63    0.05    0.04], ...
    'String', 'ECG1',...
    'fontsize',12,...
    'fontweight','bold',...
    'background',color_set);

tickECG2Title = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.942    0.63    0.05   0.04], ...
    'String', 'ECG2',...
    'fontsize',12,...
    'fontweight','bold',...
    'background',color_set);


tickHR_ECGTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.59    0.09   smallbox_h-0.005], ...
    'String', 'Heart rate:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickHR_ECG1 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.59   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickHR_ECG2 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.59   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickAmp_ECGTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.54    0.09   smallbox_h-0.005], ...
    'String', 'Amplitude:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickAmp_ECG1 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.54   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickAmp_ECG2 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.54   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickFlag_ECGTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.49    0.09   smallbox_h-0.005], ...
    'String', 'Deetct right:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickFlag_ECG1 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.49   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickFlag_ECG2 = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.49   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);


tickABPTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.885    0.44    0.05    0.04], ...
    'String', 'ABP',...
    'fontsize',12,...
    'fontweight','bold',...
    'background',color_set);

tickPPGTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.94    0.44    0.05   0.04], ...
    'String', 'PPG',...
    'fontsize',12,...
    'fontweight','bold',...
    'background',color_set);

tickHR_pulseTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.4    0.09   smallbox_h-0.005], ...
    'String', 'Heart rate:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickHR_abp = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.4   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickHR_ppg = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.4   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickAmp_pulseTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.35    0.09   smallbox_h-0.005], ...
    'String', 'Amplitude:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickAmp_abp = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.35   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickAmp_ppg = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.35   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

ticksignalTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.3    0.09   smallbox_h-0.005], ...
    'String', 'Signal quality:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickABPquality = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.3   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickPPGquality = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.3   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickhr_maxTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.25    0.09  smallbox_h-0.005], ...
    'String', 'Max HR:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickABPhr_max = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.25   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickPPGhr_max = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.25   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickmax_rrTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.2    0.09   smallbox_h-0.005], ...
    'String', 'Max RR:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickABPmax_rr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.2   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickPPGmax_rr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.2   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

ticklow_hrTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.15    0.09   smallbox_h-0.005], ...
    'String', 'Low HR thr:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickABPlow_hr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.15   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickPPGlow_hr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.15   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickhigh_hrTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.78    0.1    0.09   smallbox_h-0.005], ...
    'String', 'High HR thr:',...
    'fontsize',10,...
    'fontweight','bold',...
    'background',color_set);

tickABPhigh_hr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.89    0.1   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

tickPPGhigh_hr = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.945    0.1   0.045    smallbox_h], ...
    'String', '--',...
    'fontsize',10);

%% output end result
tickDetectionresultTitle = uicontrol(hMainFigure, ...
    'Style', 'text', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.77    0.02    0.15    0.04], ...
    'String', 'Detection result:',...
    'fontsize',12,...
    'fontweight','bold',...
    'ForegroundColor','b',...
    'background',color_set);

tickDetectionresult = uicontrol(hMainFigure, ...
    'Style', 'edit', ...?% can changed text
    'HandleVisibility', 'callback', ...
    'Units', 'normalized',...
    'Position', [0.93    0.02    0.05    0.045], ...
    'String', '--',...
    'ForegroundColor','r',...
    'fontsize',14);

%% initial functions
    function initial(hObject, eventdata)
        clc
        clear all;
        
        kickNumberalarm_type = 0;
        kickNumbergold =0;
        kickNumberevent=0;
        kickNumberroom_window=0;
        
        Alarm_type = 1;
        Gold_flag=0;
        Event=0;
        Room_window=32;
        SubNo=1;
        
        set(tickalarm_type, 'String','Asystole');
        set(tickgold, 'String','False');
        set(tickevent, 'String','Event 1&2');
        set(tickroom_window, 'String','32s');
        set(ticksubject, 'String',strcat('Sub','-',num2str(1)));
        
        
        fid=fopen('answers.txt','r');
        if(fid ~= -1)
            ANSWERS=textscan(fid,'%s %d','Delimiter',',','EmptyValue',0); %Set empty values to FALSE alarms by default
            fclose(fid);
        else
            error('Could not open users answer.txt for scoring. Run the generateValidationSet.m script and try again.')
        end
        
        fid=fopen(['ALARMS'],'r');
        if(fid ~= -1)
            GOLD=textscan(fid,'%s %s %d','Delimiter',',');
            fclose(fid);
        else
            error('Could not open challenge/ALARMS for scoring. Exiting...')
        end
        
        N=length(GOLD{1});
        %Result columnes are: true positives, false positive, false negative, true
        %negatives
        RECORDS=GOLD{1};
        ALARMS=GOLD{2};
        ALARM_TYPES=unique(ALARMS);
        NTYPES=length(ALARM_TYPES);
        results=zeros(NTYPES,4);
        GOLD_TRUTH=GOLD{3};
        
        A0_record=[];
        A1_record=[];
        B0_record=[];
        B1_record=[];
        T0_record=[];
        T1_record=[];
        VT0_record=[];
        VT1_record=[];
        VF0_record=[];
        VF1_record=[];
        A0_E1_record=[];
        A1_E1_record=[];
        B0_E1_record=[];
        B1_E1_record=[];
        T0_E1_record=[];
        T1_E1_record=[];
        VT0_E1_record=[];
        VT1_E1_record=[];
        VF0_E1_record=[];
        VF1_E1_record=[];
        A0_E2_record=[];
        A1_E2_record=[];
        B0_E2_record=[];
        B1_E2_record=[];
        T0_E2_record=[];
        T1_E2_record=[];
        VT0_E2_record=[];
        VT1_E2_record=[];
        VF0_E2_record=[];
        VF1_E2_record=[];
        
        for i=1:N
            [aa,signal,Fs,siginfo]=rdmat(RECORDS{i});
            Event_flag=size(signal,1)/Fs(1)>300;
            
            switch ALARMS{i}
                case 'Asystole'
                    if GOLD_TRUTH(i)==0
                        A0_record = [A0_record;RECORDS(i),i];
                        if Event_flag
                            A0_E2_record = [A0_E2_record;RECORDS(i),i];
                        else
                            A0_E1_record = [A0_E1_record;RECORDS(i),i];
                        end
                    else
                        A1_record = [A1_record;RECORDS(i),i];
                        if Event_flag
                            A1_E2_record = [A1_E2_record;RECORDS(i),i];
                        else
                            A1_E1_record = [A1_E1_record;RECORDS(i),i];
                        end
                    end
                    
                case 'Bradycardia'
                    if GOLD_TRUTH(i)==0
                        B0_record = [B0_record;RECORDS(i),i];
                        if Event_flag
                            B0_E2_record = [B0_E2_record;RECORDS(i),i];
                        else
                            B0_E1_record = [B0_E1_record;RECORDS(i),i];
                        end
                    else
                        B1_record = [B1_record;RECORDS(i),i];
                        if Event_flag
                            B1_E2_record = [B1_E2_record;RECORDS(i),i];
                        else
                            B1_E1_record = [B1_E1_record;RECORDS(i),i];
                        end
                    end
                case 'Tachycardia'
                    if GOLD_TRUTH(i)==0
                        T0_record = [T0_record;RECORDS(i),i];
                        if Event_flag
                            T0_E2_record = [T0_E2_record;RECORDS(i),i];
                        else
                            T0_E1_record = [T0_E1_record;RECORDS(i),i];
                        end
                    else
                        T1_record = [T1_record;RECORDS(i),i];
                        if Event_flag
                            T1_E2_record = [T1_E2_record;RECORDS(i),i];
                        else
                            T1_E1_record = [T1_E1_record;RECORDS(i),i];
                        end
                    end
                case 'Ventricular_Tachycardia'
                    if GOLD_TRUTH(i)==0
                        VT0_record = [VT0_record;RECORDS(i),i];
                        if Event_flag
                            VT0_E2_record = [VT0_E2_record;RECORDS(i),i];
                        else
                            VT0_E1_record = [VT0_E1_record;RECORDS(i),i];
                        end
                    else
                        VT1_record = [VT1_record;RECORDS(i),i];
                        if Event_flag
                            VT1_E2_record = [VT1_E2_record;RECORDS(i),i];
                        else
                            VT1_E1_record = [VT1_E1_record;RECORDS(i),i];
                        end
                    end
                case 'Ventricular_Flutter_Fib'
                    if GOLD_TRUTH(i)==0
                        VF0_record = [VF0_record;RECORDS(i),i];
                        if Event_flag
                            VF0_E2_record = [VF0_E2_record;RECORDS(i),i];
                        else
                            VF0_E1_record = [VF0_E1_record;RECORDS(i),i];
                        end
                    else
                        VF1_record = [VF1_record;RECORDS(i),i];
                        if Event_flag
                            VF1_E2_record = [VF1_E2_record;RECORDS(i),i];
                        else
                            VF1_E1_record = [VF1_E1_record;RECORDS(i),i];
                        end
                    end
            end
        end
        
    end

%% Load and show data
    function load(hObject, eventdata)
        
        cur_record=[];
        switch Alarm_type
            case 1
                if Gold_flag==0
                    if Event==0
                        cur_record=A0_record;
                    elseif Event==1
                        cur_record=A0_E1_record;
                    else
                        cur_record=A0_E2_record;
                    end
                else
                    if Event==0
                        cur_record=A1_record;
                    elseif Event==1
                        cur_record=A1_E1_record;
                    else
                        cur_record=A1_E2_record;
                    end
                end
            case 2
                if Gold_flag==0
                    if Event==0
                        cur_record=B0_record;
                    elseif Event==1
                        cur_record=B0_E1_record;
                    else
                        cur_record=B0_E2_record;
                    end
                else
                    if Event==0
                        cur_record=B1_record;
                    elseif Event==1
                        cur_record=B1_E1_record;
                    else
                        cur_record=B1_E2_record;
                    end
                end
            case 3
                if Gold_flag==0
                    if Event==0
                        cur_record=T0_record;
                    elseif Event==1
                        cur_record=T0_E1_record;
                    else
                        cur_record=T0_E2_record;
                    end
                else
                    if Event==0
                        cur_record=T1_record;
                    elseif Event==1
                        cur_record=T1_E1_record;
                    else
                        cur_record=T1_E2_record;
                    end
                end
            case 4
                if Gold_flag==0
                    if Event==0
                        cur_record=VT0_record;
                    elseif Event==1
                        cur_record=VT0_E1_record;
                    else
                        cur_record=VT0_E2_record;
                    end
                else
                    if Event==0
                        cur_record=VT1_record;
                    elseif Event==1
                        cur_record=VT1_E1_record;
                    else
                        cur_record=VT1_E2_record;
                    end
                end
            case 5
                if Gold_flag==0
                    if Event==0
                        cur_record=VF0_record;
                    elseif Event==1
                        cur_record=VF0_E1_record;
                    else
                        cur_record=VF0_E2_record;
                    end
                else
                    if Event==0
                        cur_record=VF1_record;
                    elseif Event==1
                        cur_record=VF1_E1_record;
                    else
                        cur_record=VF1_E2_record;
                    end
                end
        end
        
        
        cur_record_num = length(cur_record);
        
        if SubNo>cur_record_num
            SubNo=1;
            set(hBeatNumSubject, 'Value',1);
        end
        set(hBeatNumSubject, 'Max',cur_record_num);
        set(ticksubject, 'String',strcat('Sub','-',num2str(SubNo)));
        set(tickRecordName, 'String',cur_record{SubNo,1});
        set(tickSubTypeNo, 'String',num2str(cur_record_num));
        set(tickOrderRecord, 'String',num2str(cur_record{SubNo,2}));
        
        
        [aa,signal,Fs,siginfo]=rdmat(cur_record{SubNo});
        alarmResult=1;
        description=squeeze(struct2cell(siginfo));
        description=description(4,:);   % description = 'II'    'V'    'PLETH'    'RESP'
        channel_num = length(description);
        % Resample signal to 125Hz
        Fs=Fs(1);
        if Fs~=125
            signal=resample(signal,125,Fs);
            Fs=125;
        end
        
        % process ECG signal -- R peak detection
        ECG1=signal(:,1);
        ECG2=signal(:,2);
        
        % process ECG with SampEn
        Segment_t=10;
        Segment_num=size(signal,1)/Fs/Segment_t;
        SampEn1_0=zeros(Segment_num,1);
        SampEn2_0=zeros(Segment_num,1);
        Sd_ECG1_0=ones(Segment_num,1)*1000;
        Sd_ECG2_0=ones(Segment_num,1)*1000;
        Sd_abp_0=ones(Segment_num,1)*1000;
        Sd_ppg_0=ones(Segment_num,1)*1000;
        Mean_ECG1_0=zeros(Segment_num,1);
        Mean_ECG2_0=zeros(Segment_num,1);
        PeakLoca1=[];
        PeakLoca2=[];
        PeakLoca1_cur=[];
        PeakLoca2_cur=[];
        cur_PeakLoca1=[];
        cur_PeakLoca2=[];
        cur_PeakLoca11=[];
        cur_PeakLoca22=[];
        Indx1=[];
        Indx2=[];
        SampEn_thr1=0.05;
        SampEn_thr2=1;
        for i=1:Segment_num
            SampEn1_0(i) = SampEn_fast(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,1), 2, 0.2);
            if SampEn1_0(i)>SampEn_thr1 & SampEn1_0(i)<SampEn_thr2
                cur_ECG10=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,1),1000,Fs);
                cur_ECG10 = wden(cur_ECG10, 'rigrsure', 's', 'mln', 3, 'coif5');
                [C, L] = wavedec(cur_ECG10, 6, 'coif5'); % about 8 Hz
                tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
                indf   = 1 + floor((length(tretp) - length(cur_ECG10))/2) - floor(1*length(wfilters('coif5')));
                cur_ECG10_tre = tretp(indf:indf + length(cur_ECG10) - 1);
                cur_ECG1 = cur_ECG10 - cur_ECG10_tre;
                cur_ECG1_sort=sort(cur_ECG1);
                m_high=mean(cur_ECG1_sort(end-Fs+1:end))-mean(cur_ECG1);
                m_low=mean(cur_ECG1)-mean(cur_ECG1_sort(1:Fs));
                if 1.5*m_high<m_low
                    cur_ECG1=-cur_ECG1;
                end
                PeakLoca1_cur = round(FindPeak1(cur_ECG1,1000)*Fs/1000);
                Sd_ECG1_0(i)=std(diff(PeakLoca1_cur));
                Mean_ECG1_0(i)=mean(diff(PeakLoca1_cur));
                PeakLoca1=[PeakLoca1;PeakLoca1_cur+Fs*Segment_t*(i-1)+1];
                Indx1=[Indx1;i];
            end
            
            SampEn2_0(i) = SampEn_fast(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,2), 2, 0.2);
            if SampEn2_0(i)>SampEn_thr1 & SampEn2_0(i)<SampEn_thr2
                cur_ECG20=resample(signal(Fs*Segment_t*(i-1)+1:Fs*Segment_t*i,2),1000,Fs);
                cur_ECG20 = wden(cur_ECG20, 'rigrsure', 's', 'mln', 3, 'coif5');
                [C, L] = wavedec(cur_ECG20, 6, 'coif5'); % about 8 Hz
                tretp  = upcoef('a', C(1:L(1)), 'coif5', 6);
                indf   = 1 + floor((length(tretp) - length(cur_ECG20))/2) - floor(1*length(wfilters('coif5')));
                cur_ECG20_tre = tretp(indf:indf + length(cur_ECG20) - 1);
                cur_ECG2 = cur_ECG20 - cur_ECG20_tre;
                cur_ECG2_sort=sort(cur_ECG2);
                m_high=mean(cur_ECG2_sort(end-Fs+1:end))-mean(cur_ECG2);
                m_low=mean(cur_ECG2)-mean(cur_ECG2_sort(1:Fs));
                if 1.5*m_high<m_low
                    cur_ECG2=-cur_ECG2;
                end
                PeakLoca2_cur = round(FindPeak1(cur_ECG2,1000)*Fs/1000);
                Sd_ECG2_0(i)=std(diff(PeakLoca2_cur));
                Mean_ECG2_0(i)=mean(diff(PeakLoca2_cur));
                PeakLoca2=[PeakLoca2;PeakLoca2_cur+Fs*Segment_t*(i-1)+1];
                Indx2=[Indx2;i];
            end
            SampEn1=round(mean(SampEn1_0)*100)/100;
            SampEn2=round(mean(SampEn2_0)*100)/100;
        end
        
        Flag_falsedet_thr=0.1;
        Amp_thr=2;
        HR_ECG1=NaN;
        Amp_ECG1=NaN;
        Flag_falsedet1=0;
        if (~isempty(PeakLoca1))
            if  PeakLoca1(end)>length(ECG1)
                PeakLoca1(end)=[];
            end
            [aa cur_indx1]=min(Sd_ECG1_0(1:300/Segment_t-1));
            if aa<1000
                cur_PeakLoca1=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(cur_indx1-1) & PeakLoca1<Fs*Segment_t*cur_indx1));
                ECG_template10=zeros(length(cur_PeakLoca1)-1,Fs);
                Distance1=zeros(length(cur_PeakLoca1)-1,length(cur_PeakLoca1)-1);
                for k=1:length(cur_PeakLoca1)-1
                    ECG_template10(k,:)=resample(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)),Fs,cur_PeakLoca1(k+1)-cur_PeakLoca1(k)+1);
                    Range(k)=max(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)))-min(ECG1(cur_PeakLoca1(k):cur_PeakLoca1(k+1)));
                    for k2=1:length(cur_PeakLoca1)-1
                        Range(k2)=max(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)))-min(ECG1(cur_PeakLoca1(k2):cur_PeakLoca1(k2+1)));
                        if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                            Distance1(k,k2)=1;
                        end
                    end
                end
                if sum(sum(Distance1))/(length(cur_PeakLoca1)-1).^2 <Flag_falsedet_thr
                    Flag_falsedet1=1;
                end
                ECG_template1=mean(ECG_template10);
                HR_ECG1=60*Fs/mean(diff(cur_PeakLoca1));
                Amp_ECG1=max(ECG_template1)-min(ECG_template1);
                
                cur_PeakLoca11=PeakLoca1(find(PeakLoca1>Fs*Segment_t*(30-0.5) & PeakLoca1<Fs*Segment_t*30));
                ECG_Seg30_corr1=zeros(length(cur_PeakLoca11)-1,1);
                for k=1:length(cur_PeakLoca11)-1
                    cursig = resample(ECG1(cur_PeakLoca11(k):cur_PeakLoca11(k+1)),Fs,cur_PeakLoca11(k+1)-cur_PeakLoca11(k)+1);
                    xy = corrcoef(ECG_template1,cursig);
                    ECG_Seg30_corr1(k) = xy(2,1);
                end
                ECG_A_corr1=mean(abs(ECG_Seg30_corr1));
            end
        else ECG_A_corr1=0;
        end
        
        HR_ECG2=NaN;
        Amp_ECG2=NaN;
        Flag_falsedet2=0;
        if (~isempty(PeakLoca2))
            if  PeakLoca2(end)>length(ECG2)
                PeakLoca2(end)=[];
            end
            [aa cur_indx2]=min(Sd_ECG2_0(1:300/Segment_t-1));
            if aa<1000
                cur_PeakLoca2=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(cur_indx2-1) & PeakLoca2<Fs*Segment_t*cur_indx2));
                ECG_template20=zeros(length(cur_PeakLoca2)-1,Fs);
                Distance2=zeros(length(cur_PeakLoca2)-1,length(cur_PeakLoca2)-1);
                for k=1:length(cur_PeakLoca2)-1
                    ECG_template20(k,:)=resample(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)),Fs,cur_PeakLoca2(k+1)-cur_PeakLoca2(k)+1);
                    Range(k)=max(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)))-min(ECG2(cur_PeakLoca2(k):cur_PeakLoca2(k+1)));
                    for k2=1:length(cur_PeakLoca2)-1
                        Range(k2)=max(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)))-min(ECG2(cur_PeakLoca2(k2):cur_PeakLoca2(k2+1)));
                        if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                            Distance2(k,k2)=1;
                        end
                    end
                end
                if sum(sum(Distance2))/(length(cur_PeakLoca2)-1).^2 <Flag_falsedet_thr
                    Flag_falsedet2=1;
                end
                ECG_template2=mean(ECG_template20);
                HR_ECG2=60*Fs/mean(diff(cur_PeakLoca2));
                Amp_ECG2=max(ECG_template2)-min(ECG_template2);
                
                cur_PeakLoca22=PeakLoca2(find(PeakLoca2>Fs*Segment_t*(30-0.5) & PeakLoca2<Fs*Segment_t*30));
                ECG_Seg30_corr2=zeros(length(cur_PeakLoca22)-1,1);
                for k=1:length(cur_PeakLoca22)-1
                    cursig = resample(ECG2(cur_PeakLoca22(k):cur_PeakLoca22(k+1)),Fs,cur_PeakLoca22(k+1)-cur_PeakLoca22(k)+1);
                    xy = corrcoef(ECG_template2,cursig);
                    ECG_Seg30_corr2(k) = xy(2,1);
                end
                ECG_A_corr2=mean(abs(ECG_Seg30_corr2));
            end
        else ECG_A_corr2=0;
        end
        
        HR_ECG1=round(HR_ECG1);
        HR_ECG2=round(HR_ECG2);
        
        set(tickHR_ECG1, 'String',num2str(HR_ECG1));
        set(tickHR_ECG2, 'String',num2str(HR_ECG2));
        set(tickAmp_ECG1, 'String',num2str(Amp_ECG1));
        set(tickAmp_ECG2, 'String',num2str(Amp_ECG2));
        set(tickFlag_ECG1, 'String',num2str(Flag_falsedet1));
        set(tickFlag_ECG2, 'String',num2str(Flag_falsedet2));
        
        
        %Run WABP on the record, which by default will analyze the first ABP, ART, or BP signal
        N=[];
        N0=[];
        abp_ind=get_index(description,'ABP');
        ann_abp=[];
        features=[];
        BEATQ=[];
        R=[];
        HR_abp=NaN;
        Amp_abp=NaN;
        Flag_falsedet_abp=0;
        if(~isempty(abp_ind))
            abp=signal(:,abp_ind);
            ann_abp=wabp(signal(:,abp_ind),0,1);
            if debug
                figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
                plot((1:length(signal(:,abp_ind)))/Fs,signal(:,abp_ind),'b-')
                hold on
                plot(ann_abp/Fs,signal(ann_abp,abp_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
            end
            % Analyze the signal quality index of ABP using jSQI
            if length(ann_abp)>=3 % at least 3 abp beats detected
                [features] = abpfeature(signal(:,abp_ind),ann_abp);
                [BEATQ R] = jSQI(features, ann_abp, signal(:,abp_ind));
            end
            
            if (~isempty(ann_abp))
                if  ann_abp(end)>length(abp)
                    ann_abp(end)=[];
                end
                for i=1:300/Segment_t-1
                    cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(i-1)+1 & ann_abp<Fs*Segment_t*i));
                    if length(cur_ann_abp)>3
                        Sd_abp_0(i)=std(diff(cur_ann_abp));
                    end
                end
                [aa cur_indx3]=min(Sd_abp_0(1:300/Segment_t-1));
                if aa<1000
                    cur_ann_abp=ann_abp(find(ann_abp>Fs*Segment_t*(cur_indx3-1) & ann_abp<Fs*Segment_t*cur_indx3));
                    abp_template_0=zeros(length(cur_ann_abp)-1,Fs);
                    Distance3=zeros(length(cur_ann_abp)-1,length(cur_ann_abp)-1);
                    for k=1:length(cur_ann_abp)-1
                        abp_template_0(k,:)=resample(abp(cur_ann_abp(k):cur_ann_abp(k+1)),Fs,cur_ann_abp(k+1)-cur_ann_abp(k)+1);
                        Range(k)=max(abp(cur_ann_abp(k):cur_ann_abp(k+1)))-min(abp(cur_ann_abp(k):cur_ann_abp(k+1)));
                        for k2=1:length(cur_ann_abp)-1
                            Range(k2)=max(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)))-min(abp(cur_ann_abp(k2):cur_ann_abp(k2+1)));
                            if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                                Distance3(k,k2)=1;
                            end
                        end
                    end
                    if sum(sum(Distance3))/(length(cur_ann_abp)-1).^2 <Flag_falsedet_thr
                        Flag_falsedet_abp=1;
                    end
                    abp_template=mean(abp_template_0);
                    HR_abp=60*Fs/mean(diff(cur_ann_abp));
                    Amp_abp=max(abp_template)-min(abp_template);
                end
            end
        end
        
        %Run WABP on the record of 'PLETH' to analyze photoplethysmogram signal
        ppg_ind=get_index(description,'PLETH');
        ann_ppg=[];
        HR_ppg=NaN;
        Amp_ppg=NaN;
        Flag_falsedet_ppg=0;
        if (~isempty(ppg_ind))
            ppg=signal(:,ppg_ind);
            y=quantile(signal(:,ppg_ind),[0.05,0.5,0.95]);  % returns quantiles of the values in signal(:,ppg_ind)
            ann_ppg=wabp(signal(:,ppg_ind),0,(y(3)-y(1))/120);
            if debug
                figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 6, 4.5]);
                plot((1:length(signal(:,ppg_ind)))/Fs,signal(:,ppg_ind),'b-')
                hold on
                plot(ann_ppg/Fs,signal(ann_ppg,ppg_ind),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
            end
            % Analyze the signal quality index of PPG
            if ~isempty(ann_ppg)
                [psqi]=ppgSQI(signal(:,ppg_ind),ann_ppg);
            end
            
            if (~isempty(ann_ppg))
                if  ann_ppg(end)>length(ppg)
                    ann_ppg(end)=[];
                end
                for i=1:300/Segment_t-1
                    cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(i-1)+1 & ann_ppg<Fs*Segment_t*i));
                    if length(cur_ann_ppg)>3
                        Sd_ppg_0(i)=std(diff(cur_ann_ppg));
                    end
                end
                [aa cur_indx4]=min(Sd_ppg_0(1:300/Segment_t-1));
                if aa<1000
                    cur_ann_ppg=ann_ppg(find(ann_ppg>Fs*Segment_t*(cur_indx4-1) & ann_ppg<Fs*Segment_t*cur_indx4));
                    ppg_template_0=zeros(length(cur_ann_ppg)-1,Fs);
                    Distance4=zeros(length(cur_ann_ppg)-1,length(cur_ann_ppg)-1);
                    for k=1:length(cur_ann_ppg)-1
                        ppg_template_0(k,:)=resample(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)),Fs,cur_ann_ppg(k+1)-cur_ann_ppg(k)+1);
                        Range(k)=max(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)))-min(ppg(cur_ann_ppg(k):cur_ann_ppg(k+1)));
                        for k2=1:length(cur_ann_ppg)-1
                            Range(k2)=max(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)))-min(ppg(cur_ann_ppg(k2):cur_ann_ppg(k2+1)));
                            if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                                Distance4(k,k2)=1;
                            end
                        end
                    end
                    if sum(sum(Distance4))/(length(cur_ann_ppg)-1).^2 <Flag_falsedet_thr
                        Flag_falsedet_ppg=1;
                    end
                    ppg_template=mean(ppg_template_0);
                    HR_ppg=60*Fs/mean(diff(cur_ann_ppg));
                    Amp_ppg=max(ppg_template)-min(ppg_template);
                end
            end
        end
        
        
        HR_abp=round(HR_abp);
        HR_ppg=round(HR_ppg);
        
        set(tickHR_abp, 'String',num2str(HR_abp));
        set(tickHR_ppg, 'String',num2str(HR_ppg));
        set(tickAmp_abp, 'String',num2str(Amp_abp));
        set(tickAmp_ppg, 'String',num2str(Amp_ppg));
        
        
        
        %% Judgement
        N_d=Fs*5*60; % alarm position
        N0_d=N_d-Fs*16+1; % 16s before the alarm
        
        % select the beats in the segment
        n_abp_beats=intersect(find(ann_abp>=N0_d),find(ann_abp<=N_d));
        n_ppg_beats=intersect(find(ann_ppg>=N0_d),find(ann_ppg<=N_d));
        
        hr_max_abp=NaN;
        max_rr_abp=NaN;
        hr_max_ppg=NaN;
        max_rr_ppg=NaN;
        
        % calculate the heart rate
        if length(n_abp_beats)>=2
            hr_max_abp=60*Fs/min(diff(ann_abp(n_abp_beats)));   % 16s maximun HR
            max_rr_abp1=max(diff(ann_abp(n_abp_beats)))/Fs;     % % 16s maximun RR
            max_rr_abp2=(Fs*5*60-ann_abp(n_abp_beats(end)))/Fs;
            max_rr_abp=max(max_rr_abp1,max_rr_abp2);
        end
        if length(n_ppg_beats)>=2
            hr_max_ppg=60*Fs/min(diff(ann_ppg(n_ppg_beats)));
            max_rr_ppg1=max(diff(ann_ppg(n_ppg_beats)))/Fs;
            max_rr_ppg2=(Fs*5*60-ann_ppg(n_ppg_beats(end)))/Fs;
            max_rr_ppg=max(max_rr_ppg1,max_rr_ppg2);
        end
        
        % calculate low heart rate of 5 consecutive beats for Bradycardia
        low_hr_abp=NaN;
        low_hr_ppg=NaN;
        if length(n_abp_beats>=5)
            for i=1:length(n_abp_beats)-4
                low_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+4))-ann_abp(n_abp_beats(i)))/4);
            end
        end
        low_hr_abp=min(low_hr_abp);
        if length(n_ppg_beats>=5)
            for i=1:length(n_ppg_beats)-4
                low_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+4))-ann_ppg(n_ppg_beats(i)))/4);
            end
        end
        low_hr_ppg=min(low_hr_ppg);
        
        % calculate high heart reate of 17 consecutive beats for Tachycardia
        high_hr_abp=NaN;
        high_hr_ppg=NaN;
        if length(n_abp_beats>=17)
            for i=1:length(n_abp_beats)-16
                high_hr_abp(i)=60*Fs/((ann_abp(n_abp_beats(i+16))-ann_abp(n_abp_beats(i)))/16);
            end
        end
        high_hr_abp=max(high_hr_abp);
        if length(n_ppg_beats>=17)
            for i=1:length(n_ppg_beats)-16
                high_hr_ppg(i)=60*Fs/((ann_ppg(n_ppg_beats(i+16))-ann_ppg(n_ppg_beats(i)))/16);
            end
        end
        high_hr_ppg=max(high_hr_ppg);
        
        % calculate the signal quality index
        if ~isempty(ann_abp)
            abpsqi=1-sum(sum(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:)))/numel(BEATQ(intersect(n_abp_beats,1:length(BEATQ)),:));
        else
            abpsqi=0;
        end
        if ~isempty(ann_ppg)
            ppgsqi=mean(psqi(intersect(n_ppg_beats,1:length(psqi))));  % intersect: get the intersection of two sets
        else
            ppgsqi=0;
        end
        
        % SQI threshold
        sqi_th = 0.6;
        sqi_th_A = 0.6;
        sqi_th_B = 0.5;
        sqi_th_T = 0.9;
        sqi_th_VT = 0.9;
        sqi_th_VF = 0.6;
        
        % Alarm threshold (seconds)
        ASY_th = 3.5;
        BRA_th = 40;
        TAC_th = 140;
        VTA_th = 100;
        VFB_th = 170;
        tolerance = 5; % tolerance = 5 bmp
        
        %% For ECG judgement
        Falg_ECG1_A=0;
        Falg_ECG2_A=0;
        Falg_ECG1_B=1;
        Falg_ECG2_B=1;
        Falg_ECG1_VT=0;
        Falg_ECG2_VT=0;
        Falg_ECG1_VF=0;
        Falg_ECG2_VF=0;
        
        N0_d_A=Fs*(5*60-5);
        N0_d_B=Fs*(5*60-6);
        N0_d_VT=Fs*(5*60-5);
        N0_d_VF=Fs*(5*60-5);
        
        hr_VT_ECG1=NaN;
        hr_VT_ECG2=NaN;
        
        if Flag_falsedet1
            cur_data=ECG1(N0_d_A+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG1);
            if length(find(diff(cur_index)>10))+1>HR_ECG1/12*0.8
                Falg_ECG1_A=1;
            end
            
            cur_data=ECG1(N0_d_B+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG1*0.8);
            if length(find(diff(cur_index)>10))+1<4
                Falg_ECG1_B=0;
            end
            
            high_hr_abp=max(high_hr_abp,HR_ECG1);
            
            %             cur_data=ECG1(N0_d_VT+1:N_d);
            %         cur_data=cur_data-min(cur_data);
            %         cur_index=find(cur_data>Amp_ECG1*0.8);
            %         if length(find(diff(cur_index)>10))+1>7 && (HR_ECG1>=VTA_th+20 || HR_ECG1<=VTA_th-20)
            %             Falg_ECG1_VT=1;
            %         end
            
            
            n_ECG1_beats_VT=intersect(find(PeakLoca1>=N0_d_VT),find(PeakLoca1<=N_d));
            if length(n_ECG1_beats_VT)>5
                hr_VT_ECG1=60*Fs/(mean(diff(PeakLoca1(n_ECG1_beats_VT))));
                if  HR_ECG1<75 || Amp_ECG1<0.35  || SampEn1>0.8 || SampEn1==0 || hr_VT_ECG1>170
                    Falg_ECG1_VT=1;
                end
            end
            
            cur_data=ECG1(N0_d_VF+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG1*0.6);
            if length(find(diff(cur_index)>10))+1>12  && HR_ECG1>=VFB_th-20
                Falg_ECG1_VF=1;
            end
            
        end
        
        if Flag_falsedet2
            cur_data=ECG2(N0_d_A+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG2);
            if length(find(diff(cur_index)>10))+1>HR_ECG2/12*0.8
                Falg_ECG2_A=1;
            end
            
            cur_data=ECG2(N0_d_B+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG2*0.8);
            if length(find(diff(cur_index)>10))+1<4
                Falg_ECG2_B=0;
            end
            
            high_hr_abp=max(high_hr_abp,HR_ECG2);
            
            %            cur_data=ECG2(N0_d_VT+1:N_d);
            %         cur_data=cur_data-min(cur_data);
            %         cur_index=find(cur_data>Amp_ECG2*0.8);
            %         if length(find(diff(cur_index)>10))+1>7  && (HR_ECG2>=VTA_th+20 || HR_ECG2<=VTA_th-20)
            %             Falg_ECG2_VT=1;
            %         end
            
            n_ECG2_beats_VT=intersect(find(PeakLoca2>=N0_d_VT),find(PeakLoca2<=N_d));
            if length(n_ECG2_beats_VT)>5
                hr_VT_ECG2=60*Fs/(mean(diff(PeakLoca2(n_ECG2_beats_VT))));
                if  HR_ECG2<75 || Amp_ECG2>4.5 || SampEn2>0.85 || SampEn2==0 || hr_VT_ECG2>170
                    Falg_ECG2_VT=1;
                end
            end
            
            cur_data=ECG2(N0_d_VF+1:N_d);
            cur_data=cur_data-min(cur_data);
            cur_index=find(cur_data>Amp_ECG2*0.6);
            if length(find(diff(cur_index)>10))+1>12  && HR_ECG2>=VFB_th-20
                Falg_ECG2_VF=1;
            end
            
        end
        
      
%           set(tickAmp_ECG1, 'String',num2str(round(60*Fs/(mean(diff(PeakLoca1(n_ECG1_beats_VT)))))));
%         set(tickAmp_ECG2, 'String',num2str(round(60*Fs/(mean(diff(PeakLoca2(n_ECG2_beats_VT)))))));
        
        abpsqi=round(abpsqi*100)/100;
        ppgsqi=round(ppgsqi*100)/100;
        hr_max_abp=round(hr_max_abp);
        hr_max_ppg=round(hr_max_ppg);
        max_rr_abp=round(max_rr_abp*100)/100;
        max_rr_ppg=round(max_rr_ppg*100)/100;
        low_hr_abp=round(low_hr_abp);
        low_hr_ppg=round(low_hr_ppg);
        high_hr_abp=round(high_hr_abp);
        high_hr_ppg=round(high_hr_ppg);
        
        switch Alarm_type
            case 1
                % if the signal quality is good enough and the maximum RR interval
                % is less than the Asystole threshold, set the alarm as 'F'
                if (abpsqi>=sqi_th_A && max_rr_abp<ASY_th) || (ppgsqi>=sqi_th_A && max_rr_ppg<ASY_th) || Falg_ECG1_A || Falg_ECG2_A
                    alarmResult=0;
                end
            case 2
                % if the signal quality is good enough and the low heart rate
                % is greater than the Bradycardia threshold, set the alarm as 'F'
                if (abpsqi>=sqi_th_B && low_hr_abp-tolerance>BRA_th) || (ppgsqi>=sqi_th_B && low_hr_ppg-tolerance>BRA_th)
                    alarmResult=0;
                end
            case 3
                % if the signal quality is good enough and the high heart rate
                % is less than the Tachycardia threshold, set the alarm as 'F'
                if (abpsqi>=sqi_th_T && high_hr_abp+tolerance<TAC_th) || (ppgsqi>=sqi_th_T && high_hr_ppg+tolerance<TAC_th)
                    alarmResult=0;
                end
            case 4
                % suppress false alarm using hr_max & sqi
                if (abpsqi>=sqi_th_VT && hr_max_abp+tolerance<VTA_th) || (ppgsqi>=sqi_th_VT && hr_max_ppg+tolerance<VTA_th) || Falg_ECG1_VT || Falg_ECG2_VT
                    alarmResult=0;
                end
            case 5
                % suppress false alarm using hr_max & sqi
                if (abpsqi>=sqi_th_VF && hr_max_abp+tolerance<VFB_th) || (ppgsqi>=sqi_th_VF && hr_max_ppg+tolerance<VFB_th) || Falg_ECG1_VF || Falg_ECG2_VF
                    alarmResult=0;
                end
        end
        
        
        set(tickABPquality, 'String',num2str(abpsqi));
        set(tickPPGquality, 'String',num2str(ppgsqi));
        set(tickABPhr_max, 'String',num2str(hr_max_abp));
        set(tickPPGhr_max, 'String',num2str(hr_max_ppg));
        set(tickABPmax_rr, 'String',num2str(max_rr_abp));
        set(tickPPGmax_rr, 'String',num2str(max_rr_ppg));
        set(tickABPlow_hr, 'String',num2str(low_hr_abp));
        set(tickPPGlow_hr, 'String',num2str(low_hr_ppg));
        set(tickABPhigh_hr, 'String',num2str(high_hr_abp));
        set(tickPPGhigh_hr, 'String',num2str(high_hr_ppg));
        
        % output result
        if alarmResult==Gold_flag
            set(tickDetectionresult, 'String','','ForegroundColor','g');
        else
            set(tickDetectionresult, 'String','x','ForegroundColor','r');
        end
        
        % plot figure
        NN=length(signal(:,1));
        t = 1/Fs:1/Fs:NN/Fs; % fs = 2000Hz
        time = NN/Fs;
        for i=1:channel_num
            plot(eval(['hData',num2str(i),'Axes']),t,signal(:,i));
            set(eval(['hData',num2str(i),'Axes']),'XLim',[0 time]);
            ylabel(eval(['hData',num2str(i),'Axes']),description{i});
        end
    end




    function alarm_type(hObject, eventdata)
        kickNumberalarm_type = kickNumberalarm_type+1;
        if mod(kickNumberalarm_type,5) == 0
            Alarm_type = 1;
            set(tickalarm_type, 'String','Asystole');
        elseif mod(kickNumberalarm_type,5) == 1
            Alarm_type = 2;
            set(tickalarm_type, 'String','Bradycardia');
        elseif mod(kickNumberalarm_type,5) == 2
            Alarm_type = 3;
            set(tickalarm_type, 'String','Tachycardia');
        elseif mod(kickNumberalarm_type,5) == 3
            Alarm_type = 4;
            set(tickalarm_type, 'String','Ventricular_T');
        else Alarm_type = 5;
            set(tickalarm_type, 'String','Ventricular_F');
        end
    end

    function gold(hObject, eventdata)
        kickNumbergold = kickNumbergold+1;
        if mod(kickNumbergold,2) == 0
            Gold_flag = 0;
            set(tickgold, 'String','False');
        else
            Gold_flag = 1;
            set(tickgold, 'String','Truth');
        end
    end

    function event(hObject, eventdata)
        kickNumberevent = kickNumberevent+1;
        if mod(kickNumberevent,3) == 0
            Event = 0;
            set(tickevent, 'String','Event 1&2');
        else if mod(kickNumberevent,3) == 1
                Event = 1;
                set(tickevent, 'String','Event 1');
            else Event = 2;
                set(tickevent, 'String','Event 2');
            end
        end
    end

    function room_window(hObject, eventdata)
        kickNumberroom_window = kickNumberroom_window+1;
        xw=[32 2 8 16];
        Room_window = xw(mod(kickNumberroom_window,4)+1);
        set(tickroom_window, 'String',strcat(num2str(Room_window),'s'));
    end

    function subject(hObject, eventdata)
        SubNo = round(get(hObject,'Value'));
        set(ticksubject, 'String',strcat('Sub','-',num2str(SubNo)));
        set(tickRecordName, 'String','--');
        %         set(hBeatNumSubject, 'Max',cur_record_num);
    end


%% Show 0.5 s local waveform
    function play_room(hObject, eventdata)
        [xt,yt] = ginput(1);
        cur_time = xt(1);
        t_start=cur_time-Room_window/2;
        t_end=cur_time+Room_window/2;
        if cur_time<Room_window/2
            t_start=0;
            t_end=Room_window;
        end
        if time-cur_time<Room_window/2
            t_start=time-Room_window;
            t_end=time;
        end
        
        figure('Color', 'w', 'Units', 'Inch', 'Position', [1, 1, 8, 5]);
        for i=1:channel_num
            subplot(channel_num,1,i)
            plot(t,signal(:,i));
            if i==1
                hold on
                plot(PeakLoca1/Fs,signal(PeakLoca1,i),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
            end
            if i==2
                hold on
                plot(PeakLoca2/Fs,signal(PeakLoca2,i),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
            end
            if strcmp(description{i},'PLETH')
                hold on
                plot(ann_ppg/Fs,signal(ann_ppg,i),'ro','MarkerSize',4,'MarkerEdgeColor','r','MarkerFaceColor','r');
            end
            if strcmp(description{i},'ABP')
                hold on
                plot(ann_abp/Fs,signal(ann_abp,i),'mo','MarkerSize',4,'MarkerEdgeColor','m','MarkerFaceColor','m');
            end
            xlim([t_start t_end]);
            if i==channel_num
                xlabel('Time (s)');
            end
            ylabel(description{i});
            box off;
        end
    end

%%%%%%%%%%%% Helper Functions %%%%%%%%%%%%%%%%%%%%%
    function ind=get_index(description,pattern)
        M=length(description);
        tmp_ind=strfind(description,pattern);
        ind=[];
        for m=1:M
            if(~isempty(tmp_ind{m}))
                ind(end+1)=m;
            end
        end
    end

end
