function [Flag,Corr0,cur_HR]=Determine_VT_ECG_post(x,feature_loca,Template,HR_base,Range_base,Amp_base,Fs)

% $This algorithm was used to detect if the current ICU alarm belongs to the VT type (Ventricular Tachycardia) only using ECG signals.
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   Template: ECG signal template with Fs points length.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.08.07
% $Last update:    2015.08.08

Flag=1;
Corr0=0;
cur_HR=[];
Cons_tem_num=10;
feature_loca(1)=[];
if length(feature_loca)-Cons_tem_num>1
   RR=diff(feature_loca);
    for i=1:length(feature_loca)-Cons_tem_num
        RR_sd(i)=std(RR(i:i+Cons_tem_num-1));
    end
    [aa cur_indx1]=min(RR_sd);
    cur_loca=feature_loca(cur_indx1:cur_indx1+Cons_tem_num);
    
    RR_cur=diff(cur_loca);
    if length(RR_cur)>2
        cur_HR=(60*Fs)/mean(RR_cur);
    end   
    
    Corr0=zeros(length(cur_loca)-1,1);
    for i=1:length(cur_loca)-1
        cursig = resample(x(cur_loca(i):cur_loca(i+1)),Fs,cur_loca(i+1)-cur_loca(i)+1);
        xy = corrcoef(Template,cursig);
        Corr0(i) = xy(2,1);         
    end    
    Corr0=mean(Corr0);
    
    if Corr0>0.9 || cur_HR<90
        Flag=0;
    end
end       
