function Flag=Determine_A_post(HR_base,Range_base,HR_base_post,Range_base_post)

% $This algorithm was used to detect if the current ICU alarm belongs to the A type (asystole).
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.01
% $Last update:    2015.07.14
Flag=0;
if (abs(HR_base-HR_base_post)<10 && ~(Range_base/Range_base_post>3/2 || Range_base/Range_base_post<2/3)) || HR_base_post>65
    Flag=1;
end


