function Flag=Determine_A(x,feature_loca,HR_base,Range_base,Amp_base,T_A_be,T_A,Fs)

% $This algorithm was used to detect if the current ICU alarm belongs to the A type (asystole).
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.01
% $Last update:    2015.07.14

Flag=1;
% cur_loca=feature_loca(feature_loca>(T_A_be-T_A)*Fs+1  & feature_loca<T_A_be*Fs & abs(x(feature_loca))> 0.5*abs(Amp_base));
cur_loca=feature_loca(feature_loca>(T_A_be-T_A)*Fs+1  & feature_loca<T_A_be*Fs);
if ~isempty(cur_loca)
    indx=[];
    for i=1:length(cur_loca)-1
        cur_data=x(cur_loca(i)-round(Fs*0.1):cur_loca(i)+round(Fs*0.15));
        if abs(x(cur_loca(i))) > 0.5*abs(Amp_base) || (max(cur_data)-min(cur_data))>0.5*Range_base
            indx=[indx;i];
        end
    end
    if abs(x(cur_loca(end))) > 0.5*abs(Amp_base)
        indx=[indx;length(cur_loca)];
    end
    cur_loca=[cur_loca(indx);T_A_be*Fs];
    if length(cur_loca)>0.7*(HR_base/60*T_A) && max(diff(cur_loca))<3*Fs
        Flag=0;
    end   
end

