function [AEcg Flag_Exist] = DetectNan(ECG,T_A_be,Fs)

% $This algorithm was used to detect the NaN values in ECG signals.
% If there are NaN values in the start or the end of the selected ECG
% segment, this segment is set as 0 time series
%
% $inputs:
%   ECG: (T_A_bexFs)x1 column vector, select the time window [300-T_A_be 300].
%   T_A_be: time window
%   Fs: sample frequency
% $output:
%   AEcg: IF there are NaN values within the ECG segment (not locate start and end), AEcg return the interpolated results.
%   Flag_Exist: If there are NaN values in the start or the end of the selected ECG segment, Flag_Exist=0, denoting the ECG does not exist. 
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.06.13
% $Last update:    2015.07.01


AEcg = ECG;
Flag_Exist=1;
if any(isnan(ECG)) % existing NaN in this column
    AEcg_cur = ECG;
    loca_nan = find(isnan(ECG));
    if loca_nan(1)==1 || loca_nan(end)==Fs*T_A_be
        Flag_Exist=0;
        AEcg=zeros(length(ECG),1);
        return;
    end
    if Flag_Exist
        index_loca_nan = [0; find(diff([loca_nan; 10e5]) ~= 1)];
        if loca_nan(1) <= 10
            index_loca_nan = index_loca_nan(2:end);
        end
        if loca_nan(end) >= length(AEcg_cur)-10
            tb = loca_nan(index_loca_nan(end-1) + 1)-1;
            te = loca_nan(index_loca_nan(end));
            AEcg_cur(tb:te) = AEcg_cur(tb);
            index_loca_nan = index_loca_nan(1:end-1);
        end
        for i  = 1:length(index_loca_nan)-1
            tb = loca_nan(index_loca_nan(i) + 1)-1;
            te = loca_nan(index_loca_nan(i+1))+1;
            x_interp = interp1([tb-9:tb,te:te+9]', AEcg_cur([tb-9:tb,te:te+9]), tb-9:te+9, 'spline');
            AEcg_cur(tb:te) = x_interp(10:end-9);
        end
        AEcg = AEcg_cur;
    end
end
