function [Flag,Template,HR_base,Range_base,Amp_base]=DetAcc_VF(x,feature_loca,Cons_tem_num,T_A_be,T_A,Fs)

% $This algorithm was used to detect if the feature detection results are accurate.
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   Cons_tem_num: beat number for construct the signal template.
%   Fs: sample frequency
% $output:
%   Flag: Flag=1 denotes the feature detecion results are accurate.
%   Template: constructed signal template based on the slected Cons_tem_num beats (RR interval minimum).
%   HR_base: heart rate of the current signal.
%   Range_base: the range of signal amplitude of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.09
% $Last update:    2015.07.09

Flag=0;
Template=[];
HR_base=[];
Range_base=[];
Amp_base=[];
T_A=T_A+10;
Flag_DecAcc_thr=0.25;
Amp_thr=2.5;
RR=diff(feature_loca);
indx=find(feature_loca<(T_A_be-T_A)*Fs);
feature_loca1=feature_loca(indx);
if length(feature_loca1)-Cons_tem_num>1
    for i=1:length(feature_loca1)-Cons_tem_num
        RR_sd(i)=std(RR(i:i+Cons_tem_num-1));
    end
    [aa cur_indx1]=min(RR_sd);
    cur_loca=feature_loca(cur_indx1:cur_indx1+Cons_tem_num);
    x_template0=zeros(Cons_tem_num,Fs);
    Distance1=zeros(Cons_tem_num,Cons_tem_num);
    for k=1:Cons_tem_num
        x_template0(k,:)=resample(x(cur_loca(k):cur_loca(k+1)),Fs,cur_loca(k+1)-cur_loca(k)+1);
        Range(k)=max(x(cur_loca(k):cur_loca(k+1)))-min(x(cur_loca(k):cur_loca(k+1)));
        for k2=1:Cons_tem_num
            Range(k2)=max(x(cur_loca(k2):cur_loca(k2+1)))-min(x(cur_loca(k2):cur_loca(k2+1)));
            if Range(k)/Range(k2)>Amp_thr || Range(k)/Range(k2)>Amp_thr
                Distance1(k,k2)=1;
            end
        end
    end
    if sum(sum(Distance1))/(Cons_tem_num).^2 <Flag_DecAcc_thr
        Flag=1;
    end
    Template=mean(x_template0);
    HR_base=60*Fs/mean(diff(cur_loca));
    Range_base=max(Template)-min(Template);
    Amp_base=mean(x(cur_loca));
end