function y=polar2p(x,Fs,Seg_tw)

% $This algorithm was used to change the ECG R wave peaks to the positive polar.
%
% $inputs:
%   x: ECG signal.
%   Fs: sample frequency
%   Seg_tw: time window for the ECG segment
% $output:
%   y: ECG output with positive polar. 
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.06.13
% $Last update:    2015.07.03

y=x;
N=floor(length(x)/Fs/Seg_tw);
Num_p=0;
Num_n=0;
for i=1:N
    cur_x=x((i-1)*Fs*Seg_tw+1:i*Fs*Seg_tw);
    m_high=abs(max(cur_x));
    m_low=abs(min(cur_x));
    if m_high<m_low
        Num_n=Num_n+1;
    else
        Num_p=Num_p+1;
    end
end
if Num_p<Num_n
    y=-x;
end