function [Flag,Corr0]=Determine_VT_Pulse_post(x,feature_loca,Template,HR_base,Range_base,Amp_base,Fs)

% $This algorithm was used to detect if the current ICU alarm belongs to the VT type (Ventricular Tachycardia) only using pulse signals.
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.05
% $Last update:    2015.07.07

Flag=1;
Corr0=[];
if length(feature_loca)>2
    cur_loca=feature_loca(2:end);    
    if ~isempty(cur_loca)
        indx=[];
        for i=1:length(cur_loca)-1
            cur_data=x(cur_loca(i)-round(Fs*0.05):cur_loca(i)+round(Fs*0.25));
            if (abs(x(cur_loca(i))) > 0.75*abs(Amp_base) && abs(x(cur_loca(i))) < 1.25*abs(Amp_base)) || ((max(cur_data)-min(cur_data)) > 0.75*Range_base &&  (max(cur_data)-min(cur_data)) < 1.25*Range_base)
                indx=[indx;i];
            end
        end
        if abs(x(cur_loca(end))) > 0.75*abs(Amp_base)
            indx=[indx;length(cur_loca)];
        end
        cur_loca=cur_loca(indx);
        if length(cur_loca)>2
            Corr0=zeros(length(cur_loca)-1,1);
            for i=1:length(cur_loca)-1
                cursig = resample(x(cur_loca(i):cur_loca(i+1)),Fs,cur_loca(i+1)-cur_loca(i)+1);
                xy = corrcoef(Template,cursig);
                Corr0(i) = xy(2,1);
            end
            RR_cur=diff(cur_loca);
            RR_cur(RR_cur>Fs)=[];
            if ~isempty(RR_cur)
                if mean(Corr0)>0.975 && (60*Fs)/mean(RR_cur) < 101
                    Flag=0;
                end
            end
        end
    end
end

