function [Flag,Corr0,Corr,Shape_change,cur_HR]=Determine_VT_ECG(x,feature_loca,Template,HR_base,Range_base,Amp_base,T_A_be,T_A,Fs)

% $This algorithm was used to detect if the current ICU alarm belongs to the VT type (Ventricular Tachycardia) only using ECG signals.
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   Template: ECG signal template with Fs points length.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.05
% $Last update:    2015.07.05

Flag=0;
T_A=T_A+6;
cur_loca=feature_loca(feature_loca>(T_A_be-T_A)*Fs+1  & feature_loca<T_A_be*Fs);
cur_locas4=feature_loca(feature_loca>55*Fs+1  & feature_loca<60*Fs);
cur_locas3=feature_loca(feature_loca>53*Fs+1  & feature_loca<58*Fs);
cur_locas2=feature_loca(feature_loca>50*Fs+1  & feature_loca<55*Fs);
cur_locas1=feature_loca(feature_loca>48*Fs+1  & feature_loca<53*Fs);
Corr=[];
Corr0=0;
cur_HR=[];
Shape_change=[];
if length(cur_loca)>4
    Corr0=zeros(length(cur_loca)-1,1);
    Shape_change0=zeros(length(cur_loca)-1,1);
    for i=1:length(cur_loca)-1
        cursig = resample(x(cur_loca(i):cur_loca(i+1)),Fs,cur_loca(i+1)-cur_loca(i)+1);
        xy = corrcoef(Template,cursig);
        Corr0(i) = xy(2,1); 
        if (max(cursig)-min(cursig)) > 1.2*Range_base || (max(cursig)-min(cursig)) < 0.85*Range_base  || max(cursig)< 0.8*Amp_base || max(cursig)> 1.5*Amp_base 
            Shape_change0(i)=1;
        end
    end
    VT=intersect(find(Corr0<0.97),find(Shape_change0==1));    
    cur_loca2=cur_loca;
    cur_loca2(VT)=[];
    if length(cur_loca2)>1
        RR_cur=diff(cur_loca2);
        if max(RR_cur) >3*Fs
           Flag=1;
        end
    end     
    if Flag==0
        Amp_mean=mean(x(cur_loca(VT)));
        VT_flag=ones(length(VT),1);
        for i=1:length(VT)
            if x(cur_loca(VT(i)))/Amp_mean > 1.25 || x(cur_loca(VT(i)))/Amp_mean <0.75
                VT_flag(i)=0;
            end
        end
        VT=VT(VT_flag==1);
        dVT=diff(VT);
        if length(dVT)>2
            ss=zeros(length(dVT)-2,1);
            for k=1:length(dVT)-2
                ss(k)=sum(dVT(k:k+2));
            end
            indd=find(ss==3);
            if ~isempty(indd)
                Flag=1;
            end
        end
    end   
    
    if Flag==0
        KK=zeros(length(cur_loca)-1,1);
        for i=1:length(cur_loca)-1
            sig_be=x(cur_loca(i)-round(Fs*0.2):cur_loca(i));
            for j=1:length(sig_be)-1
                if sig_be(end-j+1)<sig_be(end-j)
                    SS=j;
                    break;
                else
                    SS=length(sig_be);
                end
            end
            if cur_loca(i)+round(Fs*0.2)>length(x)
                sig_af=x(cur_loca(i):end);
            else                
                sig_af=x(cur_loca(i):cur_loca(i)+round(Fs*0.2));
            end
            for j=1:length(sig_af)-1
                if sig_af(j)<sig_be(j+1)
                    EE=j;
                    break;
                else
                    EE=length(sig_af);
                end
            end 
            [a1 indx1]=min(abs(sig_be(end-SS+1:end)));
            [a2 indx2]=min(abs(sig_af(1:EE)));
            if indx1+indx2 > 0.12*Fs
                KK(i)=1;
            end
        end
        if sum(KK)>4
            Flag=1;
        end            
    end
    
    Corr0=mean(Corr0);
    
    if length(cur_locas1)>2
        Corr_cur=zeros(length(cur_locas1)-1,1);
        Shape_change_cur=zeros(length(cur_locas1)-1,1);
        for i=1:length(cur_locas1)-1
            cursig = resample(x(cur_locas1(i):cur_locas1(i+1)),Fs,cur_locas1(i+1)-cur_locas1(i)+1);
            xy = corrcoef(Template,cursig);
            Corr_cur(i) = xy(2,1);
            if (max(cursig)-min(cursig)) > 1.2*Range_base || (max(cursig)-min(cursig)) < 0.85*Range_base  || max(cursig)< 0.8*Amp_base || max(cursig)> 1.5*Amp_base
                Shape_change_cur(i)=1;
            end
        end
        Corr=[Corr;mean(Corr_cur)];
        Shape_change=[Shape_change;sum(Shape_change_cur)/length(Shape_change_cur)];
        
        RR_cur=diff(cur_locas1);
        RR_cur(RR_cur>2*Fs)=[];
        if length(RR_cur)>2
            cur_HR0=(60*Fs)/mean(RR_cur);
        else
            cur_HR0=0;
        end
        cur_HR=[cur_HR;cur_HR0];
    end
    
    if length(cur_locas2)>2
        Corr_cur=zeros(length(cur_locas2)-1,1);
        Shape_change_cur=zeros(length(cur_locas1)-1,1);
        for i=1:length(cur_locas2)-1
            cursig = resample(x(cur_locas2(i):cur_locas2(i+1)),Fs,cur_locas2(i+1)-cur_locas2(i)+1);
            xy = corrcoef(Template,cursig);
            Corr_cur(i) = xy(2,1);
            if (max(cursig)-min(cursig)) > 1.2*Range_base || (max(cursig)-min(cursig)) < 0.85*Range_base  || max(cursig)< 0.8*Amp_base || max(cursig)> 1.5*Amp_base
                Shape_change_cur(i)=1;
            end
        end
        Corr=[Corr;mean(Corr_cur)];
        Shape_change=[Shape_change;sum(Shape_change_cur)/length(Shape_change_cur)];
        
        RR_cur=diff(cur_locas2);
        RR_cur(RR_cur>2*Fs)=[];
        if length(RR_cur)>2
            cur_HR0=(60*Fs)/mean(RR_cur);
            else
            cur_HR0=0;
        end
        cur_HR=[cur_HR;cur_HR0];
    end
    if length(cur_locas3)>2
        Corr_cur=zeros(length(cur_locas3)-1,1);
        Shape_change_cur=zeros(length(cur_locas1)-1,1);
        for i=1:length(cur_locas3)-1
            cursig = resample(x(cur_locas3(i):cur_locas3(i+1)),Fs,cur_locas3(i+1)-cur_locas3(i)+1);
            xy = corrcoef(Template,cursig);
            Corr_cur(i) = xy(2,1);
            if (max(cursig)-min(cursig)) > 1.2*Range_base || (max(cursig)-min(cursig)) < 0.85*Range_base  || max(cursig)< 0.8*Amp_base || max(cursig)> 1.5*Amp_base
                Shape_change_cur(i)=1;
            end
        end
        Corr=[Corr;mean(Corr_cur)]; 
        Shape_change=[Shape_change;sum(Shape_change_cur)/length(Shape_change_cur)];
        
        RR_cur=diff(cur_locas3);
        RR_cur(RR_cur>2*Fs)=[];
        if length(RR_cur)>2
            cur_HR0=(60*Fs)/mean(RR_cur);
            else
            cur_HR0=0;
        end
        
        cur_HR=[cur_HR;cur_HR0];
    end
    if length(cur_locas4)>2
        Corr_cur=zeros(length(cur_locas4)-1,1);
        Shape_change_cur=zeros(length(cur_locas1)-1,1);
        for i=1:length(cur_locas4)-1
            cursig = resample(x(cur_locas4(i):cur_locas4(i+1)),Fs,cur_locas4(i+1)-cur_locas4(i)+1);
            xy = corrcoef(Template,cursig);
            Corr_cur(i) = xy(2,1);
            if (max(cursig)-min(cursig)) > 1.2*Range_base || (max(cursig)-min(cursig)) < 0.85*Range_base  || max(cursig)< 0.8*Amp_base || max(cursig)> 1.5*Amp_base
                Shape_change_cur(i)=1;
            end
        end
        Corr=[Corr;mean(Corr_cur)];
        Shape_change=[Shape_change;sum(Shape_change_cur)/length(Shape_change_cur)];
        
        RR_cur=diff(cur_locas4);
        RR_cur(RR_cur>2*Fs)=[];
        if length(RR_cur)>2
            cur_HR0=(60*Fs)/mean(RR_cur);
            else
            cur_HR0=0;
        end
        
        cur_HR=[cur_HR;cur_HR0];
    end
    
end       
