function [Flag,Corr0,Shape_change,cur_HR]=Determine_VF_ECG_post(x,feature_loca,Template,HR_base,Range_base,Amp_base,Fs)

% $This algorithm was used to detect if the current ICU alarm belongs to the VT type (Ventricular Tachycardia) only using ECG signals.
%
% $inputs:
%   x: the signal, column vector.
%   feature loca: detected feature information: for ECG is the R peak location, for pulse is the pusle foot.
%   Template: ECG signal template with Fs points length.
%   HR_base: heart rate of the current signal
%   Amp_base: the mean amplitude at the feature points of the current signal.
%   T_A_be: time window
%   T_A: time window for the potential signal segment with A type.
%   Fs: sample frequency
% $output:
%   Flag:  Flag=1 denotes the alarm is true based on the current channel signal.
%
% $Author:  Chengyu Liu; bestlcy@sdu.edu.cn
%           School of Control Science and Engineering,
%           Shandong University
% $Date:    2015.07.09
% $Last update:    2015.07.09

Flag=0;
Corr0=0;
cur_HR=[];
Shape_change=[];
Cons_tem_num=10;
feature_loca(1)=[];
if length(feature_loca)-Cons_tem_num>1
    RR=diff(feature_loca);
    for i=1:length(feature_loca)-Cons_tem_num
        RR_sd(i)=std(RR(i:i+Cons_tem_num-1));
    end
    [aa cur_indx1]=min(RR_sd);
    cur_loca=feature_loca(cur_indx1:cur_indx1+Cons_tem_num);
     RR_cur=diff(cur_loca);
     RR_cur(RR_cur>Fs)=[];
    if length(RR_cur)>2
        cur_HR=(60*Fs)/mean(RR_cur);
    end   
    Corr0=zeros(length(cur_loca)-1,1);
    Shape_change=zeros(length(cur_loca)-1,1);

    for i=1:length(cur_loca)-1
        cursig = resample(x(cur_loca(i):cur_loca(i+1)),Fs,cur_loca(i+1)-cur_loca(i)+1);
        xy = corrcoef(Template,cursig);
        Corr0(i) = xy(2,1);
        if ((max(cursig)-min(cursig)) > 1.5*Range_base || (max(cursig)-min(cursig)) < 0.6*Range_base)
            Shape_change(i)=1;
        end
    end
    cur_loca=cur_loca(find(Corr0<0.95));
    KK=zeros(length(cur_loca)-1,1);
    for i=1:length(cur_loca)-1
        sig_be=x(cur_loca(i)-round(Fs*0.2):cur_loca(i));
        for j=1:length(sig_be)-1
            if sig_be(end-j+1)<sig_be(end-j)
                SS=j;
                break;
            else
                SS=length(sig_be);
            end
        end
        sig_af=x(cur_loca(i):cur_loca(i)+round(Fs*0.2));
        for j=1:length(sig_af)-1
            if sig_af(j)<sig_be(j+1)
                EE=j;
                break;
            else
                EE=length(sig_af);
            end
        end
        [a1 indx1]=min(abs(sig_be(end-SS+1:end)));
        [a2 indx2]=min(abs(sig_af(1:EE)));
        if indx1+indx2 > 0.10*Fs
            KK(i)=1;
        end
    end
    if sum(KK)>4
        Flag=1;
    end
    
    Corr0=mean(Corr0);
end
