function [ecg1, ecg2, abp, ppg, Fs, names] = preprocess(sig, description, Fs)

    names = {};

    % Resample sig to 125Hz
    Fs=Fs(1);
    if Fs~=125
        sig=resample(sig,125,Fs);
        Fs=125;
    end    

    ecg_names = {'II','V','III','aVF','I','MCL','aVL','aVR'};
    ecg_indices = {};
    for i = 1:length(ecg_names)
        ind = find(strcmp(description,ecg_names{i}));
        if(length(ind)==1)
            ecg_indices = [ecg_indices, {ecg_names{i};ind}];
        end
    end    

    if(size(ecg_indices,2)==0)
        warning(['Cannot find two ECG leads. recordName = ' recordName]);
    end

    ecg1_ind = [];
    ecg2_ind = [];
    if(any(strcmp(ecg_indices(1,:),'II')))
        ecg1_ind = ecg_indices{2,strcmp(ecg_indices(1,:),'II')};
        ecg_indices(:,strcmp(ecg_indices(1,:),'II')) = [];
    end    
    if(any(strcmp(ecg_indices(1,:),'V')))
        ecg2_ind = ecg_indices{2,strcmp(ecg_indices(1,:),'V')};
        ecg_indices(:,strcmp(ecg_indices(1,:),'V')) = [];
    end
    if(isempty(ecg1_ind))
        ecg1_ind = ecg_indices{2,1};
        ecg_indices(:,1) = [];
    end
    if(isempty(ecg2_ind))
        ecg2_ind = ecg_indices{2,1};
        ecg_indices(:,1) = [];
    end
    ecg1 = sig(:,ecg1_ind);
    ecg2 = sig(:,ecg2_ind);
    
    names = {description{ecg1_ind}, description{ecg2_ind}, 'ABP', 'PLETH'};

    ecg1(isnan(ecg1)) = 0;
%     if(length(unique(ecg1))<1000 || sum(ecg1==0)>30*Fs)
%         ecg1 = [];
%     end        
    
    ecg2(isnan(ecg2)) = 0;
%     if(length(unique(ecg2))<1000 || sum(ecg2==0)>30*Fs)
%         ecg2 = [];
%     end    
    
    abp_ind = find(strcmp(description,'ABP'));    
    if(isempty(abp_ind))
        abp = [];
    else
        abp = sig(:,abp_ind);
        abp(isnan(abp)) = 0;
    end
    
    ppg_ind = find(strcmp(description,'PLETH'));    
    if(isempty(ppg_ind))
        ppg = [];
    else
        ppg = sig(:,ppg_ind);
        ppg(isnan(ppg)) = 0;
    end    
           
end

