function mask = segmentsDetection(y,fs)
% *************************************************************************
% function mask = segmentsDetection(y,fs)
% *************************************************************************


% window length and step (in seconds)
winLen = 5;
step = winLen;      % not applied in the rest of the program

% detrend data
y = y-nanmean(y);



%% THRESHOLD ESTIMATION
% *************************************************************************
Weight = 5;         % used in the threshold estimation method (it was 5 by default)

% Compute short-time energy and spectral centroid of the signal
Eor = ShortTimeEnergy(y,round(winLen*fs),round(step*fs));

% Apply median filtering in the feature sequences (twice),
% using medfno windows (i.e. medfno*winLen)
medfno = 2;
E1 = medfilt1(Eor,medfno);
E = medfilt1(E1,medfno);

% Get the average values of the smoothed feature sequences
E_mean = mean(E);

% Find energy threshold
[HistE,X_E] = hist(E,round(length(E)/50));        % histogram computation
[MaximaE, ~] = findMaxima(HistE,3);               % find the local maxima of the histogram
% if at least two local maxima have been found in the histogram
if size(MaximaE,2)>=2,
    % ... then compute the threshold as the weighted average between the two first histogram's local maxima.
    T_E = (Weight*X_E(MaximaE(1,1))+X_E(MaximaE(1,2)))/(Weight+1);
else
    T_E = 3*E_mean/2;
end

% Thresholding
flags = (E>=T_E);



%% SEGMENTS DETECTION
% *************************************************************************
count = 1;
WIN = 2;
Limits = [];
while count<length(flags),                       % while there are windows to be processed:
    % initialise
    countTemp = 1;
    while flags(count)==1 && count<length(flags),
        % if this is the first of the current segment
        if countTemp==1,
            Limit1 = max(1,round((count-WIN)*step*fs)+1);       % set start limit
        end
        count = count + 1;                        % increase overall counter
        countTemp = countTemp + 1;                % increase counter of the CURRENT segment
    end
    
    % if at least one segment has been found in the current loop
    if countTemp>1,
        Limit2 = min(length(y),round((count+WIN-2)*step*fs));	% set end counter
        Limits(end+1,1) = Limit1;
        Limits(end,  2) = Limit2;
    end
    count = count + 1;                            % increase overall counter
end



%% POST-PROCESSING
% A. Merge overlapping segments
RUN = 1;
while RUN==1,
    RUN = 0;
    for i=1:size(Limits,1)-1,                    % for each segment
        if Limits(i,2)>=Limits(i+1,1),
            RUN = 1;
            Limits(i,2) = Limits(i+1,2);
            Limits(i+1,:) = [];
            break
        end
    end
end

% B. Create mask
mask = ones(size(y));
for i=1:size(Limits,1),
    mask(Limits(i,1):Limits(i,2)) = NaN;
end
